/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.KonquestPlugin;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class KonConfig {
    private File file;
    private final String name;
    private final String fileName;
    private YamlConfiguration config;
    private final boolean doSave;
    private final KonquestPlugin plugin;

    public KonConfig(String name) {
        this.name = name;
        this.fileName = name + ".yml";
        this.doSave = true;
        this.plugin = Konquest.getInstance().getPlugin();
    }

    public KonConfig(String name, boolean doSave) {
        this.name = name;
        this.fileName = name + ".yml";
        this.doSave = doSave;
        this.plugin = Konquest.getInstance().getPlugin();
    }

    public boolean reloadConfig() {
        InputStream defaultFile;
        boolean isFileValid = false;
        boolean hasDefaultFile = false;
        this.config = new YamlConfiguration();
        if (this.file != null) {
            try {
                this.config.load(this.file);
                isFileValid = true;
            }
            catch (Exception e) {
                ChatUtil.printConsoleError(this.fileName + " contains syntax errors, and has been replaced with the default version. Review the following warning for details. A copy of the original file has been saved, ending in \".bad\".");
                ChatUtil.printConsoleWarning(e.getMessage());
                File badFile = new File(this.plugin.getDataFolder(), this.fileName + ".bad");
                Path source = this.file.toPath();
                Path destination = badFile.toPath();
                try {
                    Files.createDirectories(destination, new FileAttribute[0]);
                    Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
                    this.saveDefaultConfig();
                }
                catch (IOException io) {
                    io.printStackTrace();
                    ChatUtil.printConsoleError("Failed to save bad config file " + this.fileName);
                }
            }
        }
        if ((defaultFile = this.plugin.getResource(this.fileName)) != null) {
            InputStreamReader defaultConfigStream = new InputStreamReader(defaultFile, StandardCharsets.UTF_8);
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)defaultConfigStream);
            if (isFileValid) {
                this.config.setDefaults((Configuration)defaultConfig);
            } else {
                this.config = defaultConfig;
            }
            hasDefaultFile = true;
        }
        return isFileValid || hasDefaultFile;
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public void saveConfig() {
        if (this.config == null || this.file == null || this.config.getKeys(false).isEmpty() || !this.doSave) {
            return;
        }
        try {
            this.config.save(this.file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public boolean saveDefaultConfig() {
        if (this.file == null) {
            this.file = new File(this.plugin.getDataFolder(), this.fileName);
        }
        boolean result = true;
        if (!this.file.exists()) {
            try {
                this.plugin.saveResource(this.fileName, false);
                ChatUtil.printConsoleAlert("Created new default file " + this.fileName);
            }
            catch (IllegalArgumentException e) {
                result = false;
                ChatUtil.printConsoleError("Unknown resource " + this.fileName + ", check spelling.");
            }
        }
        return result;
    }

    public boolean updateVersion() {
        String pluginVersion;
        if (this.config == null || this.file == null) {
            return false;
        }
        boolean result = false;
        boolean hasVersion = this.config.contains("version", true);
        String fileVersion = this.config.getString("version", "0.0.0");
        if (!fileVersion.equalsIgnoreCase(pluginVersion = this.plugin.getDescription().getVersion())) {
            if (hasVersion && fileVersion.equals("0.0.0")) {
                this.config.set("version", (Object)pluginVersion);
                try {
                    this.config.save(this.file);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            } else {
                String oldFileName = this.name + "-v" + fileVersion + ".yml";
                File oldVersionFile = new File(this.plugin.getDataFolder(), oldFileName);
                try {
                    this.config.save(oldVersionFile);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Path source = this.file.toPath();
                    Path destination = oldVersionFile.toPath();
                    try {
                        Files.createDirectories(destination, new FileAttribute[0]);
                        Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException io) {
                        io.printStackTrace();
                        ChatUtil.printConsoleError("Failed to save old config " + oldFileName + ".");
                    }
                }
                InputStreamReader defaultConfigStream = new InputStreamReader(Objects.requireNonNull(this.plugin.getResource(this.fileName)), StandardCharsets.UTF_8);
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)defaultConfigStream);
                Map allPaths = this.config.getValues(true);
                for (String path : allPaths.keySet()) {
                    if (!defaultConfig.contains(path, false) || allPaths.get(path) instanceof ConfigurationSection) continue;
                    defaultConfig.set(path, allPaths.get(path));
                }
                defaultConfig.set("version", (Object)pluginVersion);
                this.file = new File(this.plugin.getDataFolder(), this.fileName);
                try {
                    defaultConfig.save(this.file);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                this.reloadConfig();
                ChatUtil.printConsoleAlert("Updated config file \"" + this.fileName + "\" to version " + pluginVersion);
            }
            result = true;
        }
        return result;
    }

    public void saveNewConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        File badFile = new File(this.plugin.getDataFolder(), this.fileName + ".bad");
        try {
            this.config.save(badFile);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        this.file = new File(this.plugin.getDataFolder(), this.fileName);
        this.plugin.saveResource(this.fileName, true);
        this.reloadConfig();
    }
}

