/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.model.KonGlobalEventEffect;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import javax.annotation.Nullable;

public class KonGlobalEvent {
    private Date startDate;
    private long duration;
    private long repetition;
    private final String name;
    private final HashSet<KonGlobalEventEffect> effects;
    private boolean isEnabled;
    private boolean isActive;
    private final DateFormat dateTimeFormatter;
    private final String nullDateFormat = "--";

    public KonGlobalEvent(String name) {
        this.name = name;
        this.effects = new HashSet();
        this.isEnabled = false;
        this.isActive = false;
        this.startDate = null;
        this.duration = 0L;
        this.repetition = 0L;
        this.dateTimeFormatter = DateFormat.getDateTimeInstance(3, 3);
    }

    public String getName() {
        return this.name;
    }

    public void setEnabled(boolean val) {
        this.isEnabled = val;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isRepeating() {
        return this.repetition > 0L;
    }

    @Nullable
    public KonGlobalEventEffect getConflictEffect(KonGlobalEventEffect effect) {
        for (KonGlobalEventEffect eventEffect : this.effects) {
            if (!eventEffect.isGroupConflict(effect)) continue;
            return eventEffect;
        }
        return null;
    }

    public boolean addEffect(KonGlobalEventEffect effect) {
        if (effect != null) {
            for (KonGlobalEventEffect eventEffect : this.effects) {
                if (!eventEffect.isGroupConflict(effect)) continue;
                return false;
            }
            this.effects.add(effect);
            return true;
        }
        return false;
    }

    public boolean removeEffect(KonGlobalEventEffect effect) {
        if (effect != null && this.effects.contains((Object)effect)) {
            this.effects.remove((Object)effect);
            return true;
        }
        return false;
    }

    public void clearEffects() {
        this.effects.clear();
    }

    public boolean hasEffect(KonGlobalEventEffect effect) {
        return this.effects.contains((Object)effect);
    }

    public HashSet<KonGlobalEventEffect> getEffects() {
        return new HashSet<KonGlobalEventEffect>(this.effects);
    }

    public boolean hasStartDate() {
        return this.startDate != null;
    }

    public void setStart(Date val) {
        this.startDate = val;
    }

    public void setStart(long val) {
        this.startDate = val != 0L ? new Date(val) : null;
    }

    public void setDuration(long val) {
        this.duration = val;
    }

    public void setRepetition(long val) {
        this.repetition = val;
    }

    public long getStartTime() {
        if (this.startDate != null) {
            return this.startDate.getTime();
        }
        return 0L;
    }

    public long getDurationTime() {
        return this.duration;
    }

    public long getRepetitionTime() {
        return this.repetition;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean refreshActive() {
        Date now = new Date();
        this.isActive = this.isActiveOnDate(now);
        return this.isActive;
    }

    private boolean isActiveOnDate(Date date) {
        if (this.hasStartDate() && date.after(this.startDate)) {
            long startOffset = 0L;
            if (this.repetition > 0L) {
                long diffTime = date.getTime() - this.startDate.getTime();
                int numReps = (int)(diffTime / this.repetition);
                startOffset = (long)numReps * this.repetition;
            }
            Date activeStart = new Date(this.startDate.getTime() + startOffset);
            Date activeEnd = new Date(activeStart.getTime() + this.duration);
            return date.after(activeStart) && date.before(activeEnd);
        }
        return false;
    }

    public boolean isActiveOnDay(Date day) {
        if (!this.hasStartDate()) {
            return false;
        }
        Calendar checkCal = Calendar.getInstance();
        checkCal.setTime(day);
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(this.startDate);
        if (checkCal.get(1) < startCal.get(1)) {
            return false;
        }
        if (checkCal.get(1) == startCal.get(1) && checkCal.get(6) < startCal.get(6)) {
            return false;
        }
        long startTime_ms = this.getStartTime();
        long endTime_ms = startTime_ms + this.duration;
        long startPreOffset = 0L;
        long startPostOffset = 0L;
        if (this.repetition > 0L) {
            long numReps = (day.getTime() - startTime_ms) / this.repetition;
            startPreOffset = numReps * this.repetition;
            startPostOffset = startPreOffset + this.repetition;
        }
        long startPreTime_ms = startTime_ms + startPreOffset;
        long endPreTime_ms = endTime_ms + startPreOffset;
        long startPostTime_ms = startTime_ms + startPostOffset;
        long endPostTime_ms = endTime_ms + startPostOffset;
        Calendar startPreTimeCal = Calendar.getInstance();
        startPreTimeCal.setTimeInMillis(startPreTime_ms);
        Calendar endPreTimeCal = Calendar.getInstance();
        endPreTimeCal.setTimeInMillis(endPreTime_ms);
        Calendar startPostTimeCal = Calendar.getInstance();
        startPostTimeCal.setTimeInMillis(startPostTime_ms);
        Calendar endPostTimeCal = Calendar.getInstance();
        endPostTimeCal.setTimeInMillis(endPostTime_ms);
        return this.isCalDayInRange(checkCal, startPreTimeCal, endPreTimeCal) || this.isCalDayInRange(checkCal, startPostTimeCal, endPostTimeCal);
    }

    private boolean isCalDayInRange(Calendar checkCal, Calendar startCal, Calendar endCal) {
        if (startCal.get(1) == endCal.get(1)) {
            if (checkCal.get(1) == startCal.get(1)) {
                return checkCal.get(6) >= startCal.get(6) && checkCal.get(6) <= endCal.get(6);
            }
        } else if (startCal.get(1) < endCal.get(1)) {
            if (checkCal.get(1) == startCal.get(1)) {
                return checkCal.get(6) >= startCal.get(6);
            }
            if (checkCal.get(1) < endCal.get(1)) {
                return true;
            }
            if (checkCal.get(1) == endCal.get(1)) {
                return checkCal.get(6) <= endCal.get(6);
            }
        }
        return false;
    }

    @Nullable
    public Date getNextStartDate() {
        if (this.hasStartDate()) {
            Date now = new Date();
            if (now.before(this.startDate)) {
                return this.startDate;
            }
            if (this.isRepeating()) {
                long diffTime = now.getTime() - this.startDate.getTime();
                int numReps = (int)(diffTime / this.repetition);
                long startOffset = (long)(numReps + 1) * this.repetition;
                return new Date(this.startDate.getTime() + startOffset);
            }
        }
        return null;
    }

    @Nullable
    public Date getNextEndDate() {
        if (this.hasStartDate()) {
            Date now = new Date();
            Date endDate = new Date(this.startDate.getTime() + this.duration);
            if (now.before(endDate)) {
                return endDate;
            }
            if (this.isRepeating()) {
                long diffTime = now.getTime() - (this.startDate.getTime() + this.duration);
                int numReps = (int)(diffTime / this.repetition);
                long endOffset = (long)(numReps + 1) * this.repetition;
                return new Date(this.startDate.getTime() + this.duration + endOffset);
            }
        }
        return null;
    }

    public String getStartDateFormat() {
        if (this.startDate == null) {
            return "--";
        }
        return this.dateTimeFormatter.format(this.startDate);
    }

    public String getNextStartDateFormat() {
        Date nextStart = this.getNextStartDate();
        if (nextStart == null) {
            return "--";
        }
        return this.dateTimeFormatter.format(nextStart);
    }

    public String getNextEndDateFormat() {
        Date nextEnd = this.getNextEndDate();
        if (nextEnd == null) {
            return "--";
        }
        return this.dateTimeFormatter.format(nextEnd);
    }

    public double getDurationHours() {
        return (double)this.duration / 1000.0 / 60.0 / 60.0;
    }

    public double getRepetitionDays() {
        return (double)this.repetition / 1000.0 / 60.0 / 60.0 / 24.0;
    }
}

