/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.event.kingdom.KonquestKingdomCapitalSwapEvent;
import com.github.rumsfield.konquest.api.model.KonquestDiplomacyType;
import com.github.rumsfield.konquest.api.model.KonquestKingdom;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.model.KonCapital;
import com.github.rumsfield.konquest.model.KonGlobalEventEffect;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.RequestKeeper;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.Nullable;

public class KonKingdom
implements Timeable,
KonquestKingdom,
KonPropertyFlagHolder {
    public static final KonquestDiplomacyType defaultRelation = KonquestDiplomacyType.getDefault();
    private String name;
    private final Konquest konquest;
    private KonCapital capital;
    private KonTown swapCapital;
    private KonMonumentTemplate monumentTemplate;
    private final HashMap<String, KonTown> townMap;
    private boolean isSmallest;
    private boolean isOfflineProtected;
    private final Timer protectedWarmupTimer;
    private final Timer capitalSwapWarmupTimer;
    private final Timer capitalSwapCountdownTimer;
    private int capitalSwapWarmup;
    private final boolean isCreated;
    private boolean isAdminOperated;
    private boolean isOpen;
    private boolean isLegacy;
    private final RequestKeeper joinRequestKeeper;
    private UUID master;
    private final Map<UUID, Boolean> members;
    private final Map<KonquestKingdom, KonquestDiplomacyType> activeRelationships;
    private final Map<KonquestKingdom, KonquestDiplomacyType> requestRelationships;
    private final Map<KonPropertyFlag, Boolean> properties;
    private int webColor;

    public KonKingdom(Location loc, String name, Konquest konquest) {
        this.name = name;
        this.konquest = konquest;
        this.capital = new KonCapital(loc, this, konquest);
        this.swapCapital = null;
        this.townMap = new HashMap();
        this.monumentTemplate = null;
        this.isSmallest = false;
        this.isOfflineProtected = true;
        this.protectedWarmupTimer = new Timer(this);
        this.capitalSwapWarmupTimer = new Timer(this);
        this.capitalSwapCountdownTimer = new Timer(this);
        this.capitalSwapWarmup = 1;
        this.isCreated = true;
        this.isAdminOperated = false;
        this.isOpen = false;
        this.isLegacy = false;
        this.joinRequestKeeper = new RequestKeeper();
        this.master = null;
        this.members = new HashMap<UUID, Boolean>();
        this.activeRelationships = new HashMap<KonquestKingdom, KonquestDiplomacyType>();
        this.requestRelationships = new HashMap<KonquestKingdom, KonquestDiplomacyType>();
        this.properties = new HashMap<KonPropertyFlag, Boolean>();
        this.initProperties();
        this.webColor = -1;
    }

    public KonKingdom(String name, Konquest konquest) {
        this.name = name;
        this.konquest = konquest;
        this.capital = new KonCapital(new Location(konquest.getPlugin().getServer().getWorld("world"), 0.0, 65.0, 0.0), "konquest_default", this, konquest);
        this.townMap = new HashMap();
        this.monumentTemplate = null;
        this.isSmallest = false;
        this.isOfflineProtected = false;
        this.protectedWarmupTimer = new Timer(this);
        this.capitalSwapWarmupTimer = new Timer(this);
        this.capitalSwapCountdownTimer = new Timer(this);
        this.capitalSwapWarmup = 1;
        this.isCreated = false;
        this.isAdminOperated = false;
        this.isOpen = true;
        this.isLegacy = false;
        this.joinRequestKeeper = new RequestKeeper();
        this.master = null;
        this.members = new HashMap<UUID, Boolean>();
        this.activeRelationships = new HashMap<KonquestKingdom, KonquestDiplomacyType>();
        this.requestRelationships = new HashMap<KonquestKingdom, KonquestDiplomacyType>();
        this.properties = new HashMap<KonPropertyFlag, Boolean>();
        this.webColor = -1;
    }

    public static List<KonPropertyFlag> getProperties() {
        ArrayList<KonPropertyFlag> result = new ArrayList<KonPropertyFlag>();
        result.add(KonPropertyFlag.PEACEFUL);
        result.add(KonPropertyFlag.GOLEMS);
        result.add(KonPropertyFlag.JOIN);
        result.add(KonPropertyFlag.LEAVE);
        result.add(KonPropertyFlag.PROMOTE);
        result.add(KonPropertyFlag.DEMOTE);
        result.add(KonPropertyFlag.TRANSFER);
        return result;
    }

    @Override
    public void initProperties() {
        this.properties.clear();
        for (KonPropertyFlag flag : KonKingdom.getProperties()) {
            this.properties.put(flag, this.konquest.getConfigManager().getConfig("properties").getBoolean("properties.kingdoms." + flag.toString().toLowerCase()));
        }
    }

    @Override
    public boolean isCreated() {
        return this.isCreated;
    }

    public void setIsOpen(boolean val) {
        this.isOpen = val;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setIsLegacy(boolean val) {
        this.isLegacy = val;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public void setIsAdminOperated(boolean val) {
        this.isAdminOperated = val;
    }

    @Override
    public boolean isAdminOperated() {
        return this.isAdminOperated;
    }

    @Override
    public boolean isPeaceful() {
        return this.getPropertyValue(KonPropertyFlag.PEACEFUL);
    }

    public boolean isJoinable() {
        return this.getPropertyValue(KonPropertyFlag.JOIN);
    }

    public boolean isLeaveable() {
        return this.getPropertyValue(KonPropertyFlag.LEAVE);
    }

    public boolean isPromoteable() {
        return this.getPropertyValue(KonPropertyFlag.PROMOTE);
    }

    public boolean isDemoteable() {
        return this.getPropertyValue(KonPropertyFlag.DEMOTE);
    }

    public boolean isTransferable() {
        return this.getPropertyValue(KonPropertyFlag.TRANSFER);
    }

    public void setWebColor(int val) {
        this.webColor = val;
    }

    public int getWebColor() {
        return this.webColor;
    }

    public int getWebColorFormal() {
        int webColorHash = this.webColor;
        if (this.webColor == -1) {
            webColorHash = this.getName().hashCode() & 0xFFFFFF;
        }
        return webColorHash;
    }

    public String getWebColorString() {
        return ChatUtil.parseHex(String.format("#%06X", this.getWebColorFormal()));
    }

    @Override
    public boolean setPropertyValue(KonPropertyFlag property, boolean value) {
        boolean result = false;
        if (this.properties.containsKey((Object)property)) {
            this.properties.put(property, value);
            result = true;
        }
        return result;
    }

    @Override
    public boolean getPropertyValue(KonPropertyFlag property) {
        boolean result = false;
        if (this.properties.containsKey((Object)property)) {
            result = this.properties.get((Object)property);
        }
        return result;
    }

    @Override
    public boolean hasPropertyValue(KonPropertyFlag property) {
        return this.properties.containsKey((Object)property);
    }

    @Override
    public Map<KonPropertyFlag, Boolean> getAllProperties() {
        return new HashMap<KonPropertyFlag, Boolean>(this.properties);
    }

    public void forceMaster(UUID id) {
        if (!this.isCreated) {
            return;
        }
        this.master = id;
        this.members.put(id, true);
    }

    public boolean setMaster(UUID id) {
        if (this.isCreated && !this.isAdminOperated && this.members.containsKey(id)) {
            this.master = id;
            this.members.put(id, true);
            return true;
        }
        return false;
    }

    public boolean isMaster(UUID id) {
        if (this.isCreated && !this.isAdminOperated && this.master != null) {
            return id.equals(this.master);
        }
        return false;
    }

    public boolean setOfficer(UUID id, boolean val) {
        if (this.master != null && this.master.equals(id)) {
            return false;
        }
        if (this.isCreated && this.members.containsKey(id)) {
            this.members.put(id, val);
            return true;
        }
        return false;
    }

    public boolean isOfficer(UUID id) {
        if (this.isCreated && this.members.containsKey(id)) {
            return this.members.get(id);
        }
        return false;
    }

    public boolean addMember(UUID id, boolean isOfficer) {
        if (!this.isCreated) {
            ChatUtil.printDebug("Failed to add member to non-created kingdom " + this.getName());
            return false;
        }
        if (this.members.containsKey(id)) {
            ChatUtil.printDebug("Failed to add existing member to kingdom " + this.getName());
            return false;
        }
        this.members.put(id, isOfficer);
        return true;
    }

    public boolean removeMember(UUID id) {
        if (this.master != null && this.master.equals(id)) {
            ChatUtil.printDebug("Failed to remove master from kingdom " + this.getName());
            return false;
        }
        if (!this.isCreated) {
            ChatUtil.printDebug("Failed to remove member from non-created kingdom " + this.getName());
            return false;
        }
        if (!this.members.containsKey(id)) {
            ChatUtil.printDebug("Failed to remove non-existent member from kingdom " + this.getName());
            return false;
        }
        this.members.remove(id);
        this.removeTownResidencies(id);
        return true;
    }

    public void removeTownResidencies(UUID id) {
        OfflinePlayer townPlayer = Bukkit.getOfflinePlayer((UUID)id);
        for (KonTown town : this.getCapitalTowns()) {
            if (!town.removePlayerResident(townPlayer)) continue;
            this.konquest.getMapHandler().drawLabelTerritory(town);
        }
    }

    public boolean isMember(UUID id) {
        return this.isCreated && this.members.containsKey(id);
    }

    public boolean isMasterValid() {
        return this.isCreated && this.master != null;
    }

    public UUID getMaster() {
        return this.master;
    }

    public void clearMaster() {
        this.master = null;
    }

    public void clearMembers() {
        this.members.clear();
    }

    @Nullable
    public OfflinePlayer getPlayerMaster() {
        if (this.isCreated && this.master != null) {
            return Bukkit.getOfflinePlayer((UUID)this.master);
        }
        return null;
    }

    public ArrayList<OfflinePlayer> getPlayerOfficers() {
        ArrayList<OfflinePlayer> officerList = new ArrayList<OfflinePlayer>();
        for (UUID id : this.members.keySet()) {
            if (!this.members.get(id).booleanValue()) continue;
            officerList.add(Bukkit.getOfflinePlayer((UUID)id));
        }
        return officerList;
    }

    public ArrayList<OfflinePlayer> getPlayerOfficersOnly() {
        ArrayList<OfflinePlayer> officerList = new ArrayList<OfflinePlayer>();
        for (UUID id : this.members.keySet()) {
            if (this.master != null && this.master.equals(id) || !this.members.get(id).booleanValue()) continue;
            officerList.add(Bukkit.getOfflinePlayer((UUID)id));
        }
        return officerList;
    }

    public ArrayList<OfflinePlayer> getPlayerMembers() {
        ArrayList<OfflinePlayer> memberList = new ArrayList<OfflinePlayer>();
        for (UUID id : this.members.keySet()) {
            memberList.add(Bukkit.getOfflinePlayer((UUID)id));
        }
        return memberList;
    }

    public ArrayList<OfflinePlayer> getPlayerMembersOnly() {
        ArrayList<OfflinePlayer> memberList = new ArrayList<OfflinePlayer>();
        for (UUID id : this.members.keySet()) {
            if (this.members.get(id).booleanValue()) continue;
            memberList.add(Bukkit.getOfflinePlayer((UUID)id));
        }
        return memberList;
    }

    public String getPlayerRankName(KonOfflinePlayer offlinePlayer) {
        return this.getPlayerRankName(offlinePlayer.getOfflineBukkitPlayer());
    }

    public String getPlayerRankName(OfflinePlayer offlinePlayer) {
        return this.getPlayerRankName(offlinePlayer.getUniqueId());
    }

    public String getPlayerRankName(UUID id) {
        String result = "";
        if (this.isMaster(id)) {
            result = MessagePath.RELATIONSHIP_RANK_MASTER.getMessage(new Object[0]);
        } else if (this.isOfficer(id)) {
            result = MessagePath.RELATIONSHIP_RANK_OFFICER.getMessage(new Object[0]);
        } else if (this.isMember(id)) {
            result = MessagePath.RELATIONSHIP_RANK_MEMBER.getMessage(new Object[0]);
        }
        return result;
    }

    public List<OfflinePlayer> getJoinRequests() {
        return this.joinRequestKeeper.getJoinRequests();
    }

    public List<OfflinePlayer> getJoinInvites() {
        return this.joinRequestKeeper.getJoinInvites();
    }

    public boolean addJoinRequest(UUID id, Boolean type) {
        return this.joinRequestKeeper.addJoinRequest(id, type);
    }

    public boolean isJoinRequestValid(UUID id) {
        return this.joinRequestKeeper.isJoinRequestValid(id);
    }

    public boolean isJoinInviteValid(UUID id) {
        return this.joinRequestKeeper.isJoinInviteValid(id);
    }

    public void removeJoinRequest(UUID id) {
        this.joinRequestKeeper.removeJoinRequest(id);
    }

    public void setActiveRelation(KonquestKingdom kingdom, KonquestDiplomacyType relation) {
        if (!this.isCreated || !kingdom.isCreated()) {
            return;
        }
        if (kingdom.equals(this)) {
            return;
        }
        if (this.isPeaceful()) {
            return;
        }
        if (relation.equals((Object)defaultRelation)) {
            this.activeRelationships.remove(kingdom);
        } else {
            this.activeRelationships.put(kingdom, relation);
        }
    }

    @Override
    public KonquestDiplomacyType getActiveRelation(KonquestKingdom kingdom) {
        return this.activeRelationships.getOrDefault(kingdom, defaultRelation);
    }

    public void removeActiveRelation(KonquestKingdom kingdom) {
        this.activeRelationships.remove(kingdom);
    }

    public void clearActiveRelations() {
        this.activeRelationships.clear();
    }

    public Collection<KonquestKingdom> getActiveRelationKingdoms() {
        return new HashSet<KonquestKingdom>(this.activeRelationships.keySet());
    }

    public List<KonKingdom> getActiveRelationKingdoms(KonquestDiplomacyType relation) {
        ArrayList<KonKingdom> result = new ArrayList<KonKingdom>();
        for (KonquestKingdom kingdom : this.activeRelationships.keySet()) {
            if (!this.activeRelationships.get(kingdom).equals((Object)relation) || !(kingdom instanceof KonKingdom)) continue;
            result.add((KonKingdom)kingdom);
        }
        return result;
    }

    public void setRelationRequest(KonquestKingdom kingdom, KonquestDiplomacyType relation) {
        if (!this.isCreated || !kingdom.isCreated()) {
            return;
        }
        if (kingdom.equals(this)) {
            return;
        }
        this.requestRelationships.put(kingdom, relation);
    }

    public KonquestDiplomacyType getRelationRequest(KonquestKingdom kingdom) {
        return this.requestRelationships.getOrDefault(kingdom, defaultRelation);
    }

    public boolean hasRelationRequest(KonquestKingdom kingdom) {
        return this.requestRelationships.containsKey(kingdom);
    }

    public void removeRelationRequest(KonquestKingdom kingdom) {
        this.requestRelationships.remove(kingdom);
    }

    public void clearRelationRequests() {
        this.requestRelationships.clear();
    }

    public Collection<KonquestKingdom> getRelationRequestKingdoms() {
        return new HashSet<KonquestKingdom>(this.requestRelationships.keySet());
    }

    public List<String> getRelationRequestNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (KonquestKingdom kingdom : this.requestRelationships.keySet()) {
            result.add(kingdom.getName());
        }
        return result;
    }

    public int getNumMembers() {
        return this.members.size();
    }

    public int getNumMembersOnline() {
        int result = 0;
        for (UUID id : this.members.keySet()) {
            if (!Bukkit.getOfflinePlayer((UUID)id).isOnline()) continue;
            ++result;
        }
        return result;
    }

    public int getNumTowns() {
        return this.townMap.size();
    }

    public int getNumLand() {
        int result = 0;
        for (KonTown town : this.townMap.values()) {
            result += town.getChunkList().size();
        }
        return result;
    }

    public boolean isCapitalImmune() {
        boolean result = true;
        boolean isGlobalEventNoImmunity = this.konquest.getGlobalEventManager().isEffectValid(KonGlobalEventEffect.NO_IMMUNITY);
        int immunityThreshold = this.konquest.getCore().getInt(CorePath.KINGDOMS_CAPITAL_IMMUNITY_TOWNS.getPath(), 0);
        if (!isGlobalEventNoImmunity && immunityThreshold > 0) {
            if (this.getNumTowns() < immunityThreshold) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public int initCapital() {
        int status = this.capital.initClaim();
        if (status != 0) {
            ChatUtil.printDebug("Problem initializing capital of " + this.name);
        }
        return status;
    }

    public boolean removeCapital() {
        boolean result = false;
        if (this.capital != null) {
            ChatUtil.printDebug("Removed capital of kingdom " + this.name);
            this.capital.removeAllBarPlayers();
            result = this.capital.removeMonumentBlocks();
            if (!result) {
                ChatUtil.printDebug("Encountered problem removing monument blocks of capital");
            }
        }
        return result;
    }

    public boolean addTown(Location loc, String name) {
        if (!this.hasTown(name)) {
            this.townMap.put(name, new KonTown(loc, name, this, this.konquest));
            return true;
        }
        return false;
    }

    public int initTown(String name) {
        int exitCode = this.townMap.get(name).initClaim();
        if (exitCode != 0) {
            ChatUtil.printDebug("Problem initializing town " + name);
        }
        return exitCode;
    }

    public boolean removeTown(String name) {
        KonTown oldTown = this.townMap.remove(name);
        if (oldTown != null) {
            ChatUtil.printDebug("Removed town " + name);
            oldTown.removeAllBarPlayers();
            oldTown.purgeResidents();
            oldTown.clearPlots();
            oldTown.clearUpgrades();
            oldTown.clearShieldsArmors();
            oldTown.stopTimers();
            boolean pass = oldTown.removeMonumentBlocks();
            if (!pass) {
                ChatUtil.printDebug("Encountered problem removing monument blocks");
            }
            oldTown = null;
            return true;
        }
        return false;
    }

    public KonTown removeTownConquer(String name) {
        return this.townMap.remove(name);
    }

    public boolean addTownConquer(String name, KonTown town) {
        if (!this.townMap.containsKey(name)) {
            this.townMap.put(name, town);
            return true;
        }
        return false;
    }

    public boolean renameTown(String oldName, String newName) {
        if (this.hasTown(oldName)) {
            KonTown town = this.getTown(oldName);
            String oldNameActual = town.getName();
            town.setName(newName);
            this.townMap.remove(oldNameActual);
            this.townMap.put(newName, town);
            this.townMap.get(newName).updateBarTitle();
            this.townMap.get(newName).updateBarPlayers();
            return true;
        }
        return false;
    }

    @Override
    public boolean isSmallest() {
        return this.isSmallest;
    }

    public void setSmallest(boolean val) {
        this.isSmallest = val;
    }

    @Override
    public boolean isOfflineProtected() {
        boolean isBreakDisabledOffline = this.konquest.getCore().getBoolean(CorePath.KINGDOMS_NO_ENEMY_EDIT_OFFLINE.getPath());
        boolean isGlobalEventNoProtection = this.konquest.getGlobalEventManager().isEffectValid(KonGlobalEventEffect.NO_PROTECTION);
        return this.isOfflineProtected && isBreakDisabledOffline && !isGlobalEventNoProtection;
    }

    public void setOfflineProtected(boolean val) {
        this.isOfflineProtected = val;
    }

    public boolean isMonumentTemplateValid() {
        boolean result = false;
        if (this.monumentTemplate != null) {
            result = this.monumentTemplate.isValid();
        }
        return result;
    }

    public void setMonumentTemplate(KonMonumentTemplate template) {
        this.monumentTemplate = template;
    }

    public KonMonumentTemplate getMonumentTemplate() {
        return this.monumentTemplate;
    }

    public String getMonumentTemplateName() {
        String result = "";
        if (this.monumentTemplate != null) {
            result = this.monumentTemplate.getName();
        }
        return result;
    }

    public void clearMonumentTemplate() {
        this.monumentTemplate = null;
    }

    public boolean hasMonumentTemplate() {
        return this.monumentTemplate != null;
    }

    public void updateMonumentTemplate(KonMonumentTemplate template) {
        this.setMonumentTemplate(template);
        for (KonTown town : this.getCapitalTowns()) {
            town.updateMonumentFromTemplate();
        }
        this.reloadLoadedTownMonuments();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public KonCapital getCapital() {
        return this.capital;
    }

    public boolean hasCapital() {
        return this.capital != null;
    }

    public boolean hasCapital(String name) {
        return name.equalsIgnoreCase(this.name) && this.capital != null;
    }

    @Override
    public ArrayList<String> getTownNames() {
        return new ArrayList<String>(this.townMap.keySet());
    }

    @Override
    public KonTown getTown(String name) {
        boolean isTown = this.townMap.containsKey(name);
        if (isTown) {
            return this.townMap.get(name);
        }
        for (String townName : this.townMap.keySet()) {
            if (!name.equalsIgnoreCase(townName)) continue;
            return this.townMap.get(townName);
        }
        return null;
    }

    public ArrayList<KonTown> getTowns() {
        return new ArrayList<KonTown>(this.townMap.values());
    }

    public ArrayList<KonTown> getCapitalTowns() {
        ArrayList<KonTown> result = new ArrayList<KonTown>(this.townMap.values());
        result.add(this.capital);
        return result;
    }

    public KonTown getTownCapital(String name) {
        KonTown resultTown = null;
        boolean isTown = this.hasTown(name);
        boolean isCapital = this.hasCapital(name);
        if (isTown) {
            resultTown = this.getTown(name);
        } else if (isCapital) {
            resultTown = this.getCapital();
        }
        return resultTown;
    }

    @Override
    public boolean hasTown(String name) {
        boolean isTown = false;
        isTown = this.townMap.containsKey(name);
        if (isTown) {
            return true;
        }
        for (String townName : this.townMap.keySet()) {
            if (!townName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public void onEndTimer(int taskID) {
        if (taskID == 0) {
            ChatUtil.printDebug("Kingdom Timer ended with null taskID!");
        } else if (taskID == this.protectedWarmupTimer.getTaskID()) {
            ChatUtil.printDebug("Kingdom protection warmup Timer ended with taskID: " + taskID);
            this.isOfflineProtected = true;
        } else if (taskID == this.capitalSwapWarmupTimer.getTaskID()) {
            ChatUtil.printDebug("Kingdom capital swap warmup Timer ended with taskID: " + taskID);
            this.capitalSwapCountdownTimer.stopTimer();
            this.swapCapital.updateCapitalSwapBar(1.0, true, "");
            this.capital.updateCapitalSwapBar(1.0, false, "");
            this.swapCapitalToTown(this.swapCapital);
            this.swapCapital = null;
            this.capitalSwapWarmup = 0;
        } else if (taskID == this.capitalSwapCountdownTimer.getTaskID()) {
            String remainingTime = HelperUtil.getTimeFormat(this.capitalSwapWarmupTimer.getTime(), ChatColor.GOLD);
            double progress = 1.0;
            if (this.capitalSwapWarmup > 0) {
                progress = (double)(this.capitalSwapWarmup - this.capitalSwapWarmupTimer.getTime()) / (double)this.capitalSwapWarmup;
            }
            this.swapCapital.updateCapitalSwapBar(progress, true, remainingTime);
            this.capital.updateCapitalSwapBar(progress, false, remainingTime);
        }
    }

    public Timer getProtectedWarmupTimer() {
        return this.protectedWarmupTimer;
    }

    public void startCapitalSwapWarmup(KonTown town, int warmupTime) {
        this.swapCapital = town;
        this.capitalSwapWarmup = warmupTime;
        this.capitalSwapWarmupTimer.stopTimer();
        this.capitalSwapWarmupTimer.setTime(warmupTime);
        this.capitalSwapWarmupTimer.startTimer();
        this.capitalSwapCountdownTimer.stopTimer();
        this.capitalSwapCountdownTimer.setTime(0);
        this.capitalSwapCountdownTimer.startLoopTimer();
        String remainingTime = HelperUtil.getTimeFormat(warmupTime, "");
        this.swapCapital.updateCapitalSwapBar(0.0, true, remainingTime);
        this.capital.updateCapitalSwapBar(0.0, false, remainingTime);
        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_CAPITAL_WARMUP.getMessage(this.getName(), town.getName(), remainingTime));
    }

    public void cancelCapitalSwapWarmup() {
        if (this.swapCapital != null) {
            this.swapCapital.updateCapitalSwapBar(0.0, true, "");
            ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_CAPITAL_CANCEL.getMessage(this.getName(), this.swapCapital.getName()));
        }
        this.capital.updateCapitalSwapBar(0.0, false, "");
        this.capitalSwapWarmupTimer.stopTimer();
        this.capitalSwapCountdownTimer.stopTimer();
        this.swapCapital = null;
        this.capitalSwapWarmup = 0;
    }

    public boolean isCapitalSwapInProgress(KonTown town) {
        return this.capitalSwapWarmup > 0 && this.swapCapital != null && (this.capital.equals(town) || this.swapCapital.equals(town));
    }

    public boolean swapCapitalToTown(KonTown town) {
        KonTown oldTown;
        if (town == null || this.capital == null) {
            return false;
        }
        if (!town.getKingdom().equals(this)) {
            return false;
        }
        if (town.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
            return false;
        }
        String townName = town.getName();
        KonCapital newCapital = (KonCapital)town.copy(new KonCapital(town.getCenterLoc(), this, this.konquest));
        KonTown newTown = this.capital.copy(new KonTown(this.capital.getCenterLoc(), townName, this, this.konquest));
        if (this.capital != null) {
            this.capital.removeAllBarPlayers();
            this.capital.stopTimers();
            this.konquest.getTerritoryManager().removeAllTerritory(this.capital.getWorld(), this.capital.getChunkList().keySet());
            this.konquest.getMapHandler().drawRemoveTerritory(this.capital);
        }
        if ((oldTown = this.townMap.remove(townName)) != null) {
            oldTown.removeAllBarPlayers();
            oldTown.stopTimers();
            this.konquest.getTerritoryManager().removeAllTerritory(oldTown.getWorld(), oldTown.getChunkList().keySet());
            this.konquest.getMapHandler().drawRemoveTerritory(oldTown);
        }
        this.capital = newCapital;
        this.townMap.put(townName, newTown);
        this.konquest.getTerritoryManager().addAllTerritory(this.capital.getWorld(), this.capital.getChunkList());
        this.konquest.getTerritoryManager().addAllTerritory(newTown.getWorld(), newTown.getChunkList());
        this.capital.refreshMonument();
        newTown.refreshMonument();
        this.capital.updateBarTitle();
        newTown.updateBarTitle();
        this.capital.updateBarPlayers();
        newTown.updateBarPlayers();
        this.konquest.getKingdomManager().refreshTownNerfs(this.capital);
        this.konquest.getKingdomManager().refreshTownNerfs(newTown);
        this.konquest.getKingdomManager().refreshTownHearts(this.capital);
        this.konquest.getKingdomManager().refreshTownHearts(newTown);
        this.konquest.getUpgradeManager().updateTownDisabledUpgrades(this.capital);
        this.konquest.getUpgradeManager().updateTownDisabledUpgrades(newTown);
        this.konquest.getMapHandler().drawUpdateTerritory(this.capital);
        this.konquest.getMapHandler().drawUpdateTerritory(newTown);
        ChatUtil.sendBroadcast(MessagePath.COMMAND_KINGDOM_BROADCAST_CAPITAL_SWAP.getMessage(this.getName(), townName));
        Konquest.callKonquestEvent(new KonquestKingdomCapitalSwapEvent(this.konquest, this, this.capital, newTown));
        return true;
    }

    public void reloadLoadedTownMonuments() {
        ArrayList<KonTown> allTownsAndCapital = new ArrayList<KonTown>();
        allTownsAndCapital.add(this.getCapital());
        allTownsAndCapital.addAll(this.getTowns());
        for (KonTown town : allTownsAndCapital) {
            Point tPoint = HelperUtil.toPoint(town.getCenterLoc());
            if (!town.getWorld().isChunkLoaded(tPoint.x, tPoint.y)) continue;
            if (town.isAttacked()) {
                ChatUtil.printDebug("Could not paste monument in town " + town.getName() + " while under attack");
                continue;
            }
            for (KonPlayer player : this.konquest.getPlayerManager().getPlayersOnline()) {
                if (!town.getMonument().isLocInside(player.getBukkitPlayer().getLocation())) continue;
                player.getBukkitPlayer().teleport(this.konquest.getSafeRandomCenteredLocation(town.getCenterLoc(), 2));
            }
            Konquest.playTownSettleSound(town.getCenterLoc());
            town.reloadMonument();
        }
    }
}

