/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import java.util.HashMap;

public class KonKingdomScoreAttributes {
    private final HashMap<ScoreAttribute, Integer> attributeMap = new HashMap();
    private final HashMap<ScoreAttribute, Integer> attributeWeights = new HashMap();

    public KonKingdomScoreAttributes() {
        for (ScoreAttribute attribute : ScoreAttribute.values()) {
            this.attributeMap.put(attribute, 0);
            this.attributeWeights.put(attribute, attribute.getWeight());
        }
    }

    public void setAttributeWeight(ScoreAttribute attribute, int value) {
        this.attributeWeights.put(attribute, value);
    }

    public void setAttribute(ScoreAttribute attribute, int value) {
        this.attributeMap.put(attribute, value);
    }

    public int getAttributeValue(ScoreAttribute attribute) {
        int result = 0;
        if (this.attributeMap.containsKey((Object)attribute)) {
            result = this.attributeMap.get((Object)attribute);
        }
        return result;
    }

    public int getAttributeScore(ScoreAttribute attribute) {
        int result = 0;
        if (this.attributeMap.containsKey((Object)attribute)) {
            result = this.attributeMap.get((Object)attribute) * this.attributeWeights.get((Object)attribute);
        }
        return result;
    }

    public int getScore() {
        int result = 0;
        for (ScoreAttribute attribute : this.attributeMap.keySet()) {
            result += this.attributeMap.get((Object)attribute) * this.attributeWeights.get((Object)attribute);
        }
        return result;
    }

    public static enum ScoreAttribute {
        TOWNS(100),
        LAND(10),
        FAVOR(1),
        POPULATION(50);

        private final int weight;

        private ScoreAttribute(int weight) {
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

