/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.manager.LootManager;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class KonLootTable {
    private String name = LootManager.defaultLootTableName;
    private final HashMap<ItemStack, Integer> loot = new HashMap();
    private final ArrayList<ItemStack> weightedLoot = new ArrayList();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addLoot(HashMap<ItemStack, Integer> otherLoot) {
        this.loot.putAll(otherLoot);
        this.weightedLoot.clear();
        for (ItemStack item : this.loot.keySet()) {
            for (int weight = Math.max(this.loot.get(item), 1); weight > 0; --weight) {
                this.weightedLoot.add(item);
            }
        }
    }

    public void clearLoot() {
        this.loot.clear();
        this.weightedLoot.clear();
    }

    public boolean isEmptyLoot() {
        return this.loot.isEmpty();
    }

    public ItemStack chooseRandomItem() {
        Map enchants;
        EnchantmentStorageMeta enchantMeta;
        ItemStack item;
        if (!this.weightedLoot.isEmpty()) {
            int tableIndex = ThreadLocalRandom.current().nextInt(this.weightedLoot.size());
            item = this.weightedLoot.get(tableIndex).clone();
        } else {
            item = new ItemStack(Material.DIRT, 1);
        }
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof EnchantmentStorageMeta && (enchantMeta = (EnchantmentStorageMeta)meta).hasStoredEnchants() && !(enchants = enchantMeta.getStoredEnchants()).isEmpty()) {
            for (Enchantment e : enchants.keySet()) {
                if ((Integer)enchants.get(e) != 0) continue;
                int newLevel = ThreadLocalRandom.current().nextInt(e.getMaxLevel() + 1);
                if (newLevel < e.getStartLevel()) {
                    newLevel = e.getStartLevel();
                }
                enchantMeta.removeStoredEnchant(e);
                enchantMeta.addStoredEnchant(e, newLevel, true);
                item.setItemMeta((ItemMeta)enchantMeta);
                ChatUtil.printDebug("Enchanted loot item " + String.valueOf(item.getType()) + " updated " + e.getKey().getKey() + " from level 0 to " + newLevel);
            }
        }
        return item;
    }
}

