/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.api.model.KonquestMonument;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.utility.ChatUtil;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;

public class KonMonument
implements KonquestMonument {
    private final Location centerLoc;
    private int baseY;
    private int height;
    private Location travelPoint;
    private boolean isValid;
    private int criticalHits;
    private boolean isItemDropsDisabled;
    private boolean isDamageDisabled;

    public KonMonument(Location centerLoc) {
        this.centerLoc = centerLoc;
        this.baseY = (int)centerLoc.getY();
        this.height = 0;
        this.travelPoint = centerLoc;
        this.isValid = false;
        this.criticalHits = 0;
        this.isItemDropsDisabled = false;
        this.isDamageDisabled = false;
    }

    public int initialize(KonMonumentTemplate template, Location centerLoc, int flatness) {
        if (template == null) {
            return 1;
        }
        if (!template.isValid()) {
            ChatUtil.printDebug("Monument init failed: template is not valid");
            return 1;
        }
        int x_diff = (int)Math.abs(template.getCornerOne().getX() - template.getCornerTwo().getX()) + 1;
        int z_diff = (int)Math.abs(template.getCornerOne().getZ() - template.getCornerTwo().getZ()) + 1;
        if (Math.abs(x_diff) != 16 || Math.abs(z_diff) != 16) {
            ChatUtil.printDebug("Monument init failed: template is not 16x16 blocks");
            return 1;
        }
        Chunk chunk = centerLoc.getChunk();
        ChunkSnapshot chunkSnap = chunk.getChunkSnapshot(true, false, false);
        Object minMaterial = "";
        Object maxMaterial = "";
        int maxY = centerLoc.getWorld().getMinHeight();
        int minY = centerLoc.getWorld().getMaxHeight();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = chunkSnap.getHighestBlockYAt(x, z);
                while (chunk.getBlock(x, y, z).isPassable() || !chunkSnap.getBlockType(x, y, z).isOccluding() || chunkSnap.getBlockType(x, y, z).equals((Object)Material.AIR)) {
                    if (--y > 0) continue;
                    ChatUtil.printDebug("Could not find non-leaves block in chunk " + String.valueOf(chunkSnap) + ", local position " + x + "," + y + "," + z);
                    break;
                }
                if (y > maxY) {
                    maxY = y;
                    maxMaterial = String.valueOf(chunkSnap.getBlockType(x, y, z)) + " at " + x + ", " + y + ", " + z;
                }
                if (y >= minY) continue;
                minY = y;
                minMaterial = String.valueOf(chunkSnap.getBlockType(x, y, z)) + " at " + x + ", " + y + ", " + z;
            }
        }
        ChatUtil.printDebug("Total Highest block: " + (String)maxMaterial);
        ChatUtil.printDebug("Total Lowest block: " + (String)minMaterial);
        if (flatness != -1) {
            int gradient;
            if (flatness < 0) {
                flatness = 0;
            }
            if ((gradient = maxY - minY) > flatness) {
                ChatUtil.printDebug("Monument init failed: town center is not flat enough, gradient is " + gradient + " but must be at most " + flatness);
                return 2;
            }
        }
        if (((String)maxMaterial).equals(Material.BEDROCK.toString())) {
            ChatUtil.printDebug("Monument init failed: town monument attempted to place on bedrock.");
            return 3;
        }
        int standY = centerLoc.getBlockY() - 1;
        if (standY < minY || standY > maxY) {
            ChatUtil.printDebug("Monument init failed: center position " + standY + " is outside of gradiant bounds (" + minY + "," + maxY + ")");
            return 3;
        }
        this.baseY = standY;
        boolean updatePass = this.updateFromTemplate(template);
        if (!updatePass) {
            ChatUtil.printDebug("Monument init failed: could not update invalid template");
        }
        return updatePass ? 0 : 1;
    }

    public boolean updateFromTemplate(KonMonumentTemplate template) {
        if (template == null || !template.isValid()) {
            return false;
        }
        int minBlockX = Math.min(template.getCornerOne().getBlockX(), template.getCornerTwo().getBlockX());
        int minBlockY = Math.min(template.getCornerOne().getBlockY(), template.getCornerTwo().getBlockY());
        int minBlockZ = Math.min(template.getCornerOne().getBlockZ(), template.getCornerTwo().getBlockZ());
        int offsetX = (int)(template.getTravelPoint().getX() - (double)minBlockX);
        int offsetY = (int)(template.getTravelPoint().getY() - (double)minBlockY);
        int offsetZ = (int)(template.getTravelPoint().getZ() - (double)minBlockZ);
        int mX = (int)Math.floor((double)this.centerLoc.getBlockX() / 16.0) * 16;
        int mZ = (int)Math.floor((double)this.centerLoc.getBlockZ() / 16.0) * 16;
        this.travelPoint = new Location(this.centerLoc.getWorld(), (double)(mX + offsetX), (double)(this.baseY + offsetY + 1), (double)(mZ + offsetZ));
        this.height = template.getHeight();
        return true;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public Location getTravelPoint() {
        return this.travelPoint;
    }

    @Override
    public int getBaseY() {
        return this.baseY;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getCriticalHits() {
        return this.criticalHits;
    }

    public int getTopY() {
        return this.baseY + this.height;
    }

    public boolean isItemDropsDisabled() {
        return this.isItemDropsDisabled;
    }

    public boolean isDamageDisabled() {
        return this.isDamageDisabled;
    }

    @Override
    public boolean isLocInside(Location loc) {
        if (this.height == 0) {
            return false;
        }
        Chunk centerChunk = this.centerLoc.getChunk();
        Chunk testChunk = loc.getChunk();
        boolean isChunkMatch = this.centerLoc.getWorld().equals((Object)loc.getWorld()) && centerChunk.getX() == testChunk.getX() && centerChunk.getZ() == testChunk.getZ();
        return isChunkMatch && loc.getBlockY() >= this.baseY && loc.getBlockY() < this.baseY + this.height;
    }

    public void setIsValid(boolean val) {
        this.isValid = val;
    }

    public void setBaseY(int newY) {
        this.baseY = newY;
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
    }

    public void addCriticalHit() {
        ++this.criticalHits;
    }

    public void clearCriticalHits() {
        this.criticalHits = 0;
    }

    public void setIsItemDropsDisabled(boolean val) {
        this.isItemDropsDisabled = val;
    }

    public void setIsDamageDisabled(boolean val) {
        this.isDamageDisabled = val;
    }
}

