/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.manager.LootManager;
import com.github.rumsfield.konquest.utility.HelperUtil;
import java.awt.Point;
import org.bukkit.Location;
import org.bukkit.World;

public class KonMonumentTemplate {
    private Location corner1;
    private Location corner2;
    private Location travelPoint;
    private boolean isValid;
    private boolean isBlanking;
    private boolean hasLoot;
    private String name;
    private double cost;
    private int numCriticals;
    private int numBlocks;
    private int numLootChests;
    private Location shadowCorner1;
    private Location shadowCorner2;
    private Location shadowTravelPoint;
    private double shadowCost;
    private String lootTableName;

    public KonMonumentTemplate(String name, Location corner1, Location corner2, Location travelPoint, double cost) {
        this.name = name;
        this.corner1 = corner1;
        this.corner2 = corner2;
        this.travelPoint = travelPoint;
        this.cost = cost;
        this.isValid = false;
        this.isBlanking = false;
        this.hasLoot = false;
        this.numCriticals = 0;
        this.numBlocks = 0;
        this.numLootChests = 0;
        this.shadowCorner1 = null;
        this.shadowCorner2 = null;
        this.shadowTravelPoint = null;
        this.shadowCost = 0.0;
        this.lootTableName = LootManager.defaultLootTableName;
    }

    public int getNumCriticals() {
        return this.numCriticals;
    }

    public int getNumBlocks() {
        return this.numBlocks;
    }

    public int getNumLootChests() {
        return this.numLootChests;
    }

    public String getName() {
        return this.name;
    }

    public double getCost() {
        return this.cost;
    }

    public int getHeight() {
        if (this.isValid && this.corner1 != null && this.corner2 != null) {
            return (int)Math.abs(this.corner1.getY() - this.corner2.getY());
        }
        return 0;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isBlanking() {
        return this.isBlanking;
    }

    public Location getCornerOne() {
        return this.corner1;
    }

    public Location getCornerTwo() {
        return this.corner2;
    }

    public Location getTravelPoint() {
        return this.travelPoint;
    }

    public Location getSpawnLoc() {
        return new Location(this.travelPoint.getWorld(), (double)this.travelPoint.getBlockX(), (double)(this.travelPoint.getBlockY() + 1), (double)this.travelPoint.getBlockZ());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNumCriticals(int val) {
        this.numCriticals = val;
    }

    public void setNumBlocks(int val) {
        this.numBlocks = val;
    }

    public void setNumLootChests(int val) {
        this.numLootChests = val;
    }

    public void setCornerOne(Location loc) {
        this.shadowCorner1 = this.corner1;
        this.corner1 = loc;
    }

    public void setCornerTwo(Location loc) {
        this.shadowCorner2 = this.corner2;
        this.corner2 = loc;
    }

    public void setTravelPoint(Location loc) {
        this.shadowTravelPoint = this.travelPoint;
        this.travelPoint = loc;
    }

    public void setCost(double cost) {
        this.shadowCost = this.cost;
        this.cost = cost;
    }

    public boolean restorePrevious() {
        if (this.shadowCorner1 != null && this.shadowCorner2 != null && this.shadowTravelPoint != null) {
            this.corner1 = this.shadowCorner1;
            this.corner2 = this.shadowCorner2;
            this.travelPoint = this.shadowTravelPoint;
            this.cost = this.shadowCost;
            return true;
        }
        return false;
    }

    public void setValid(boolean isNewValid) {
        this.isValid = isNewValid;
    }

    public void setBlanking(boolean isNewBlanking) {
        this.isBlanking = isNewBlanking;
    }

    public void setLoot(boolean val) {
        this.hasLoot = val;
    }

    public boolean hasLoot() {
        return this.hasLoot;
    }

    public String getLootTableName() {
        return this.lootTableName.isEmpty() ? LootManager.defaultLootTableName : this.lootTableName;
    }

    public void setLootTableName(String name) {
        this.lootTableName = name.isEmpty() ? LootManager.defaultLootTableName : name;
    }

    public boolean isLootTableDefault() {
        return this.lootTableName.equalsIgnoreCase(LootManager.defaultLootTableName);
    }

    public void setLootTableDefault() {
        this.lootTableName = LootManager.defaultLootTableName;
    }

    public boolean isLocInside(Location loc) {
        int topBlockX = Math.max(this.corner1.getBlockX(), this.corner2.getBlockX());
        int topBlockY = Math.max(this.corner1.getBlockY(), this.corner2.getBlockY());
        int topBlockZ = Math.max(this.corner1.getBlockZ(), this.corner2.getBlockZ());
        int bottomBlockX = Math.min(this.corner1.getBlockX(), this.corner2.getBlockX());
        int bottomBlockY = Math.min(this.corner1.getBlockY(), this.corner2.getBlockY());
        int bottomBlockZ = Math.min(this.corner1.getBlockZ(), this.corner2.getBlockZ());
        return loc.getBlockX() <= topBlockX && loc.getBlockY() <= topBlockY && loc.getBlockZ() <= topBlockZ && loc.getBlockX() >= bottomBlockX && loc.getBlockY() >= bottomBlockY && loc.getBlockZ() >= bottomBlockZ;
    }

    public boolean isInsideChunk(Point point, World world) {
        boolean result = false;
        if (this.corner1.getWorld().equals((Object)world) && this.corner2.getWorld().equals((Object)world)) {
            World allWorld = this.corner1.getWorld();
            double topX = Math.max(this.corner1.getX(), this.corner2.getX());
            double topZ = Math.max(this.corner1.getZ(), this.corner2.getZ());
            double botX = Math.min(this.corner1.getX(), this.corner2.getX());
            double botZ = Math.min(this.corner1.getZ(), this.corner2.getZ());
            Location c1 = new Location(allWorld, topX, 0.0, topZ);
            Location c2 = new Location(allWorld, topX, 0.0, botZ);
            Location c3 = new Location(allWorld, botX, 0.0, topZ);
            Location c4 = new Location(allWorld, botX, 0.0, botZ);
            Point p1 = HelperUtil.toPoint(c1);
            Point p2 = HelperUtil.toPoint(c2);
            Point p3 = HelperUtil.toPoint(c3);
            Point p4 = HelperUtil.toPoint(c4);
            if (point.equals(p1) || point.equals(p2) || point.equals(p3) || point.equals(p4)) {
                result = true;
            }
        }
        return result;
    }
}

