/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.api.model.KonquestPlayer;
import com.github.rumsfield.konquest.model.KonClaimRegister;
import com.github.rumsfield.konquest.model.KonDirective;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPrefix;
import com.github.rumsfield.konquest.model.KonStats;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class KonPlayer
extends KonOfflinePlayer
implements KonquestPlayer,
Timeable {
    private final Player bukkitPlayer;
    private RegionType settingRegion;
    private FollowType autoFollow;
    private String regionTemplateName;
    private String regionSanctuaryName;
    private Location regionCornerOneBuffer;
    private Location regionCornerTwoBuffer;
    private double regionTemplateCost;
    private boolean isAdminBypassActive;
    private boolean isGlobalChat;
    private boolean isMapAuto;
    private boolean isPriorityTitleDisplay;
    private boolean isCombatTagged;
    private boolean isFlying;
    private boolean isBorderDisplay;
    private boolean isAfk;
    private boolean isRegionBlank;
    private final Timer priorityTitleDisplayTimer;
    private final Timer borderUpdateLoopTimer;
    private final Timer monumentTemplateLoopTimer;
    private final Timer monumentShowLoopTimer;
    private final Timer combatTagTimer;
    private final Timer flyDisableWarmupTimer;
    private final Timer setRegionBlankTimer;
    private long recordPlayCooldownTime;
    private int monumentShowLoopCount;
    private long flyDisableTime;
    private final ArrayList<Mob> targetMobList;
    private final HashMap<KonDirective, Integer> directiveProgress;
    private final KonStats playerStats;
    private final KonPrefix playerPrefix;
    private final HashMap<Location, Color> borderMap;
    private final HashMap<Location, Color> borderPlotMap;
    private final HashMap<Location, Color> monumentTemplateBoundary;
    private final HashSet<Location> monumentShowBoundary;
    private Block lastTargetBlock;
    private final KonClaimRegister adminClaimRegister;

    public KonPlayer(Player bukkitPlayer, KonKingdom kingdom, boolean isBarbarian) {
        super((OfflinePlayer)bukkitPlayer, kingdom, isBarbarian);
        this.bukkitPlayer = bukkitPlayer;
        this.settingRegion = RegionType.NONE;
        this.regionTemplateName = "";
        this.regionSanctuaryName = "";
        this.regionTemplateCost = 0.0;
        this.isAdminBypassActive = false;
        this.autoFollow = FollowType.NONE;
        this.isGlobalChat = true;
        this.isMapAuto = false;
        this.isPriorityTitleDisplay = false;
        this.isCombatTagged = false;
        this.isFlying = false;
        this.isBorderDisplay = true;
        this.isAfk = false;
        this.isRegionBlank = false;
        this.priorityTitleDisplayTimer = new Timer(this);
        this.borderUpdateLoopTimer = new Timer(this);
        this.monumentTemplateLoopTimer = new Timer(this);
        this.monumentShowLoopTimer = new Timer(this);
        this.combatTagTimer = new Timer(this);
        this.flyDisableWarmupTimer = new Timer(this);
        this.setRegionBlankTimer = new Timer(this);
        this.recordPlayCooldownTime = 0L;
        this.monumentShowLoopCount = 0;
        this.flyDisableTime = 0L;
        this.targetMobList = new ArrayList();
        this.directiveProgress = new HashMap();
        this.playerStats = new KonStats();
        this.playerPrefix = new KonPrefix();
        this.adminClaimRegister = new KonClaimRegister();
        this.borderMap = new HashMap();
        this.borderPlotMap = new HashMap();
        this.monumentTemplateBoundary = new HashMap();
        this.monumentShowBoundary = new HashSet();
    }

    public void addMobAttacker(Mob mob) {
        if (!this.targetMobList.contains(mob)) {
            this.targetMobList.add(mob);
        }
    }

    public void removeMobAttacker(Mob mob) {
        if (this.targetMobList.contains(mob)) {
            mob.setTarget(null);
            this.targetMobList.remove(mob);
        }
    }

    public void clearAllMobAttackers() {
        for (Mob m : this.targetMobList) {
            m.setTarget(null);
        }
        this.targetMobList.clear();
    }

    public void setDirectiveProgress(KonDirective dir, int stage) {
        this.directiveProgress.put(dir, stage);
    }

    public int getDirectiveProgress(KonDirective dir) {
        int result = 0;
        if (this.directiveProgress.containsKey((Object)dir)) {
            result = this.directiveProgress.get((Object)dir);
        }
        return result;
    }

    @Override
    public Player getBukkitPlayer() {
        return this.bukkitPlayer;
    }

    public boolean isSettingRegion() {
        return !this.settingRegion.equals((Object)RegionType.NONE);
    }

    public RegionType getRegionType() {
        return this.settingRegion;
    }

    public Location getRegionCornerOneBuffer() {
        return this.regionCornerOneBuffer;
    }

    public Location getRegionCornerTwoBuffer() {
        return this.regionCornerTwoBuffer;
    }

    public String getRegionTemplateName() {
        return this.regionTemplateName;
    }

    public String getRegionSanctuaryName() {
        return this.regionSanctuaryName;
    }

    public double getRegionTemplateCost() {
        return this.regionTemplateCost;
    }

    @Override
    public boolean isAdminBypassActive() {
        return this.isAdminBypassActive;
    }

    public boolean isAutoFollowActive() {
        return !this.autoFollow.equals((Object)FollowType.NONE);
    }

    public FollowType getAutoFollow() {
        return this.autoFollow;
    }

    @Override
    public boolean isGlobalChat() {
        return this.isGlobalChat;
    }

    public boolean isMapAuto() {
        return this.isMapAuto;
    }

    public boolean isPriorityTitleDisplay() {
        return this.isPriorityTitleDisplay;
    }

    @Override
    public boolean isCombatTagged() {
        return this.isCombatTagged;
    }

    @Override
    public boolean isFlyEnabled() {
        return this.isFlying;
    }

    public boolean isBorderDisplay() {
        return this.isBorderDisplay;
    }

    public boolean isAfk() {
        return this.isAfk;
    }

    public boolean isRegionBlank() {
        return this.isRegionBlank;
    }

    public Timer getPriorityTitleDisplayTimer() {
        return this.priorityTitleDisplayTimer;
    }

    public KonStats getPlayerStats() {
        return this.playerStats;
    }

    public KonPrefix getPlayerPrefix() {
        return this.playerPrefix;
    }

    public KonClaimRegister getAdminClaimRegister() {
        return this.adminClaimRegister;
    }

    public Timer getBorderUpdateLoopTimer() {
        return this.borderUpdateLoopTimer;
    }

    public Timer getCombatTagTimer() {
        return this.combatTagTimer;
    }

    public void setRegionBlank() {
        this.isRegionBlank = true;
        this.setRegionBlankTimer.stopTimer();
        this.setRegionBlankTimer.setTime(2);
        this.setRegionBlankTimer.startTimer();
        ChatUtil.printDebug("Starting region blank Timer for " + this.bukkitPlayer.getName());
    }

    public void settingRegion(RegionType type) {
        this.settingRegion = type;
        if (type.equals((Object)RegionType.MONUMENT)) {
            this.monumentTemplateLoopTimer.stopTimer();
            this.monumentTemplateLoopTimer.setTime(1);
            this.monumentTemplateLoopTimer.startLoopTimer(5);
            ChatUtil.printDebug("Starting monument template Timer for " + this.bukkitPlayer.getName());
        } else if (this.monumentTemplateLoopTimer.isRunning()) {
            this.monumentTemplateLoopTimer.stopTimer();
            this.monumentTemplateBoundary.clear();
            ChatUtil.printDebug("Stopped running monument template Timer for " + this.bukkitPlayer.getName());
        } else {
            ChatUtil.printDebug("Doing nothing with monument template Timer for " + this.bukkitPlayer.getName());
        }
    }

    public void setRegionCornerOneBuffer(Location loc) {
        this.regionCornerOneBuffer = loc;
    }

    public void setRegionCornerTwoBuffer(Location loc) {
        this.regionCornerTwoBuffer = loc;
    }

    public void setRegionTemplateName(String name) {
        this.regionTemplateName = name;
    }

    public void setRegionSanctuaryName(String name) {
        this.regionSanctuaryName = name;
    }

    public void setRegionTemplateCost(double cost) {
        this.regionTemplateCost = cost;
    }

    public void setIsAdminBypassActive(boolean val) {
        if (val) {
            ChatUtil.sendConstantTitle(this.getBukkitPlayer(), "", String.valueOf(ChatColor.GOLD) + MessagePath.LABEL_BYPASS.getMessage(new Object[0]));
        } else {
            ChatUtil.resetTitle(this.getBukkitPlayer());
        }
        this.isAdminBypassActive = val;
    }

    public void setAutoFollow(FollowType val) {
        this.autoFollow = val;
    }

    public void setIsGlobalChat(boolean val) {
        this.isGlobalChat = val;
    }

    public void setIsPriorityTitleDisplay(boolean val) {
        this.isPriorityTitleDisplay = val;
    }

    public void setIsCombatTagged(boolean val) {
        this.isCombatTagged = val;
    }

    public void setIsBorderDisplay(boolean val) {
        this.isBorderDisplay = val;
    }

    public void setIsAfk(boolean val) {
        this.isAfk = val;
    }

    public void setIsFlyEnabled(boolean val) {
        try {
            if (val && !this.isFlying) {
                this.bukkitPlayer.setAllowFlight(true);
                this.isFlying = true;
            } else if (!val && this.isFlying) {
                if (this.bukkitPlayer.isFlying()) {
                    Location playerLoc = this.bukkitPlayer.getLocation();
                    ChunkSnapshot snap = playerLoc.getChunk().getChunkSnapshot();
                    int x = playerLoc.getBlockX() - snap.getX() * 16;
                    int y = playerLoc.getBlockY();
                    int z = playerLoc.getBlockZ() - snap.getZ() * 16;
                    while (snap.getBlockType(x, y, z).isAir()) {
                        if (--y >= playerLoc.getWorld().getMinHeight()) continue;
                        y = playerLoc.getWorld().getMinHeight();
                        break;
                    }
                    this.bukkitPlayer.teleport(new Location(playerLoc.getWorld(), (double)playerLoc.getBlockX() + 0.5, (double)(y + 1), (double)playerLoc.getBlockZ() + 0.5), PlayerTeleportEvent.TeleportCause.PLUGIN);
                }
                this.bukkitPlayer.setFlying(false);
                this.bukkitPlayer.setAllowFlight(false);
                this.isFlying = false;
                this.flyDisableWarmupTimer.stopTimer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFlyDisableWarmup(boolean enable) {
        if (enable && this.isFlying) {
            Date now = new Date();
            this.flyDisableTime = now.getTime() + 5000L;
            this.flyDisableWarmupTimer.stopTimer();
            this.flyDisableWarmupTimer.setTime(0);
            this.flyDisableWarmupTimer.startLoopTimer();
        } else {
            this.flyDisableWarmupTimer.stopTimer();
        }
    }

    public void removeAllBorders() {
        this.borderMap.clear();
    }

    public void addTerritoryBorders(HashMap<Location, Color> locs) {
        this.borderMap.putAll(locs);
    }

    public void removeAllPlotBorders() {
        this.borderPlotMap.clear();
    }

    public void addTerritoryPlotBorders(HashMap<Location, Color> locs) {
        this.borderPlotMap.putAll(locs);
    }

    public void stopTimers() {
        this.priorityTitleDisplayTimer.stopTimer();
        this.borderUpdateLoopTimer.stopTimer();
        this.monumentTemplateLoopTimer.stopTimer();
        this.monumentShowLoopTimer.stopTimer();
        this.combatTagTimer.stopTimer();
        this.flyDisableWarmupTimer.stopTimer();
        this.setRegionBlankTimer.stopTimer();
    }

    public void setIsMapAuto(boolean val) {
        this.isMapAuto = val;
    }

    public void markRecordPlayCooldown() {
        Date now = new Date();
        this.recordPlayCooldownTime = now.getTime() + 60000L;
    }

    public boolean isRecordPlayCooldownOver() {
        Date now = new Date();
        return now.after(new Date(this.recordPlayCooldownTime));
    }

    public void startMonumentShow(Location loc0, Location loc1) {
        this.monumentShowLoopTimer.stopTimer();
        this.monumentShowLoopTimer.setTime(1);
        this.monumentShowLoopTimer.startLoopTimer(5);
        this.monumentShowLoopCount = 40;
        this.monumentShowBoundary.clear();
        this.monumentShowBoundary.addAll(this.getEdgeLocations(loc0, loc1));
        ChatUtil.printDebug("Starting monument show Timer for " + this.bukkitPlayer.getName());
    }

    @Override
    public void onEndTimer(int taskID) {
        if (taskID == 0) {
            ChatUtil.printDebug("Player Timer ended with null taskID!");
        } else if (taskID == this.priorityTitleDisplayTimer.getTaskID()) {
            this.isPriorityTitleDisplay = false;
        } else if (taskID == this.borderUpdateLoopTimer.getTaskID()) {
            Color particleColor;
            for (Location loc : this.borderMap.keySet()) {
                if (!loc.getWorld().equals((Object)this.getBukkitPlayer().getWorld()) || !(loc.distance(this.getBukkitPlayer().getLocation()) < 12.0)) continue;
                particleColor = this.borderMap.get(loc);
                this.getBukkitPlayer().spawnParticle(CompatibilityUtil.getParticle("dust"), loc, 2, 0.25, 0.0, 0.25, (Object)new Particle.DustOptions(particleColor, 1.0f));
            }
            for (Location loc : this.borderPlotMap.keySet()) {
                if (!loc.getWorld().equals((Object)this.getBukkitPlayer().getWorld()) || !(loc.distance(this.getBukkitPlayer().getLocation()) < 12.0)) continue;
                particleColor = this.borderPlotMap.get(loc);
                CompatibilityUtil.playerSpawnEffect(this.getBukkitPlayer(), loc, particleColor);
            }
        } else if (taskID == this.monumentTemplateLoopTimer.getTaskID()) {
            this.updateMonumentTemplateBoundary();
            for (Location loc : this.monumentTemplateBoundary.keySet()) {
                this.getBukkitPlayer().spawnParticle(CompatibilityUtil.getParticle("dust"), loc, 1, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(this.monumentTemplateBoundary.get(loc), 1.0f));
            }
        } else if (taskID == this.monumentShowLoopTimer.getTaskID()) {
            if (this.monumentShowLoopCount <= 0) {
                this.monumentShowLoopTimer.stopTimer();
                ChatUtil.printDebug("Ended monument show Timer for " + this.bukkitPlayer.getName());
            } else {
                --this.monumentShowLoopCount;
                for (Location loc : this.monumentShowBoundary) {
                    this.getBukkitPlayer().spawnParticle(CompatibilityUtil.getParticle("dust"), loc, 1, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.LIME, 1.0f));
                }
            }
        } else if (taskID == this.combatTagTimer.getTaskID()) {
            this.isCombatTagged = false;
            ChatUtil.sendKonPriorityTitle(this, "", String.valueOf(ChatColor.GOLD) + MessagePath.PROTECTION_NOTICE_UNTAGGED.getMessage(new Object[0]), 20, 1, 10);
            ChatUtil.sendNotice((CommandSender)this.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_UNTAG_MESSAGE.getMessage(new Object[0]));
            ChatUtil.printDebug("Combat tag timer ended with taskID: " + taskID + " for " + this.bukkitPlayer.getName());
        } else if (taskID == this.flyDisableWarmupTimer.getTaskID()) {
            Date now = new Date();
            if (this.flyDisableTime <= now.getTime()) {
                this.setIsFlyEnabled(false);
                this.flyDisableWarmupTimer.stopTimer();
            } else {
                int timeLeft = (int)(this.flyDisableTime - now.getTime()) / 1000;
                this.getBukkitPlayer().sendTitle(" ", String.valueOf(ChatColor.GOLD) + (timeLeft + 1), 2, 10, 2);
            }
        } else if (taskID == this.setRegionBlankTimer.getTaskID()) {
            this.isRegionBlank = false;
            ChatUtil.printDebug("Ended region blank Timer for " + this.bukkitPlayer.getName());
        }
    }

    private void updateMonumentTemplateBoundary() {
        Block target = this.bukkitPlayer.getTargetBlock(null, 3);
        if (this.lastTargetBlock == null || !this.lastTargetBlock.equals((Object)target)) {
            this.lastTargetBlock = target;
            if (this.isSettingRegion() && this.getRegionType().equals((Object)RegionType.MONUMENT)) {
                Location loc0 = this.getRegionCornerOneBuffer();
                Location loc1 = target.getLocation();
                if (loc0 != null && this.getRegionCornerTwoBuffer() == null) {
                    int yMin;
                    int yMax;
                    int zMin;
                    int zMax;
                    int xMin;
                    int xMax;
                    this.monumentTemplateBoundary.clear();
                    if (loc1.getBlockX() > loc0.getBlockX()) {
                        xMax = loc1.getBlockX();
                        xMin = loc0.getBlockX();
                    } else {
                        xMax = loc0.getBlockX();
                        xMin = loc1.getBlockX();
                    }
                    Color xColor = xMax - xMin == 15 ? Color.LIME : (xMax - xMin < 15 ? Color.ORANGE : Color.MAROON);
                    for (int i = xMin; i <= xMax; ++i) {
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)i + 0.5, (double)(loc0.getBlockY() + 1), (double)loc0.getBlockZ() + 0.5), xColor);
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)i + 0.5, (double)(loc0.getBlockY() + 1), (double)loc1.getBlockZ() + 0.5), xColor);
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)i + 0.5, (double)(loc1.getBlockY() + 1), (double)loc0.getBlockZ() + 0.5), xColor);
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)i + 0.5, (double)(loc1.getBlockY() + 1), (double)loc1.getBlockZ() + 0.5), xColor);
                    }
                    if (loc1.getBlockZ() > loc0.getBlockZ()) {
                        zMax = loc1.getBlockZ();
                        zMin = loc0.getBlockZ();
                    } else {
                        zMax = loc0.getBlockZ();
                        zMin = loc1.getBlockZ();
                    }
                    Color zColor = zMax - zMin == 15 ? Color.LIME : (zMax - zMin < 15 ? Color.ORANGE : Color.MAROON);
                    for (int i = zMin; i <= zMax; ++i) {
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)loc0.getBlockX() + 0.5, (double)(loc0.getBlockY() + 1), (double)i + 0.5), zColor);
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)loc0.getBlockX() + 0.5, (double)(loc1.getBlockY() + 1), (double)i + 0.5), zColor);
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)loc1.getBlockX() + 0.5, (double)(loc0.getBlockY() + 1), (double)i + 0.5), zColor);
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)loc1.getBlockX() + 0.5, (double)(loc1.getBlockY() + 1), (double)i + 0.5), zColor);
                    }
                    if (loc1.getBlockY() > loc0.getBlockY()) {
                        yMax = loc1.getBlockY();
                        yMin = loc0.getBlockY();
                    } else {
                        yMax = loc0.getBlockY();
                        yMin = loc1.getBlockY();
                    }
                    Color yColor = xMax - xMin == 15 && zMax - zMin == 15 ? Color.LIME : (xMax - xMin > 15 || zMax - zMin > 15 ? Color.MAROON : Color.ORANGE);
                    for (int i = yMin; i <= yMax; ++i) {
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)loc0.getBlockX() + 0.5, (double)(i + 1), (double)loc0.getBlockZ() + 0.5), yColor);
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)loc0.getBlockX() + 0.5, (double)(i + 1), (double)loc1.getBlockZ() + 0.5), yColor);
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)loc1.getBlockX() + 0.5, (double)(i + 1), (double)loc0.getBlockZ() + 0.5), yColor);
                        this.monumentTemplateBoundary.put(new Location(loc0.getWorld(), (double)loc1.getBlockX() + 0.5, (double)(i + 1), (double)loc1.getBlockZ() + 0.5), yColor);
                    }
                }
            }
        }
    }

    private HashSet<Location> getEdgeLocations(Location loc0, Location loc1) {
        int yMin;
        int yMax;
        int zMin;
        int zMax;
        int xMin;
        int xMax;
        HashSet<Location> locationSet = new HashSet<Location>();
        if (loc1.getBlockX() > loc0.getBlockX()) {
            xMax = loc1.getBlockX();
            xMin = loc0.getBlockX();
        } else {
            xMax = loc0.getBlockX();
            xMin = loc1.getBlockX();
        }
        for (int i = xMin; i <= xMax; ++i) {
            locationSet.add(new Location(loc0.getWorld(), (double)i + 0.5, (double)(loc0.getBlockY() + 1), (double)loc0.getBlockZ() + 0.5));
            locationSet.add(new Location(loc0.getWorld(), (double)i + 0.5, (double)(loc0.getBlockY() + 1), (double)loc1.getBlockZ() + 0.5));
            locationSet.add(new Location(loc0.getWorld(), (double)i + 0.5, (double)(loc1.getBlockY() + 1), (double)loc0.getBlockZ() + 0.5));
            locationSet.add(new Location(loc0.getWorld(), (double)i + 0.5, (double)(loc1.getBlockY() + 1), (double)loc1.getBlockZ() + 0.5));
        }
        if (loc1.getBlockZ() > loc0.getBlockZ()) {
            zMax = loc1.getBlockZ();
            zMin = loc0.getBlockZ();
        } else {
            zMax = loc0.getBlockZ();
            zMin = loc1.getBlockZ();
        }
        for (int i = zMin; i <= zMax; ++i) {
            locationSet.add(new Location(loc0.getWorld(), (double)loc0.getBlockX() + 0.5, (double)(loc0.getBlockY() + 1), (double)i + 0.5));
            locationSet.add(new Location(loc0.getWorld(), (double)loc0.getBlockX() + 0.5, (double)(loc1.getBlockY() + 1), (double)i + 0.5));
            locationSet.add(new Location(loc0.getWorld(), (double)loc1.getBlockX() + 0.5, (double)(loc0.getBlockY() + 1), (double)i + 0.5));
            locationSet.add(new Location(loc0.getWorld(), (double)loc1.getBlockX() + 0.5, (double)(loc1.getBlockY() + 1), (double)i + 0.5));
        }
        if (loc1.getBlockY() > loc0.getBlockY()) {
            yMax = loc1.getBlockY();
            yMin = loc0.getBlockY();
        } else {
            yMax = loc0.getBlockY();
            yMin = loc1.getBlockY();
        }
        for (int i = yMin; i <= yMax; ++i) {
            locationSet.add(new Location(loc0.getWorld(), (double)loc0.getBlockX() + 0.5, (double)(i + 1), (double)loc0.getBlockZ() + 0.5));
            locationSet.add(new Location(loc0.getWorld(), (double)loc0.getBlockX() + 0.5, (double)(i + 1), (double)loc1.getBlockZ() + 0.5));
            locationSet.add(new Location(loc0.getWorld(), (double)loc1.getBlockX() + 0.5, (double)(i + 1), (double)loc0.getBlockZ() + 0.5));
            locationSet.add(new Location(loc0.getWorld(), (double)loc1.getBlockX() + 0.5, (double)(i + 1), (double)loc1.getBlockZ() + 0.5));
        }
        return locationSet;
    }

    public static enum RegionType {
        NONE,
        MONUMENT,
        RUIN_CRITICAL,
        RUIN_SPAWN;

    }

    public static enum FollowType {
        NONE,
        CLAIM,
        UNCLAIM,
        ADMIN_CLAIM,
        ADMIN_UNCLAIM;

    }
}

