/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import java.util.HashMap;

public class KonPlayerScoreAttributes {
    private final HashMap<ScoreAttribute, Integer> attributeMap = new HashMap();
    private final HashMap<ScoreAttribute, Integer> attributeWeights = new HashMap();

    public KonPlayerScoreAttributes() {
        for (ScoreAttribute attribute : ScoreAttribute.values()) {
            this.attributeMap.put(attribute, 0);
            this.attributeWeights.put(attribute, attribute.getWeight());
        }
    }

    public void setAttributeWeight(ScoreAttribute attribute, int value) {
        this.attributeWeights.put(attribute, value);
    }

    public void setAttribute(ScoreAttribute attribute, int value) {
        this.attributeMap.put(attribute, value);
    }

    public void addAttribute(ScoreAttribute attribute, int value) {
        if (this.attributeMap.containsKey((Object)attribute)) {
            int current = this.attributeMap.get((Object)attribute);
            this.attributeMap.put(attribute, current + value);
        }
    }

    public int getAttributeValue(ScoreAttribute attribute) {
        int result = 0;
        if (this.attributeMap.containsKey((Object)attribute)) {
            result = this.attributeMap.get((Object)attribute);
        }
        return result;
    }

    public int getAttributeScore(ScoreAttribute attribute) {
        int result = 0;
        if (this.attributeMap.containsKey((Object)attribute)) {
            result = this.attributeMap.get((Object)attribute) * this.attributeWeights.get((Object)attribute);
        }
        return result;
    }

    public int getScore() {
        int result = 0;
        for (ScoreAttribute attribute : this.attributeMap.keySet()) {
            result += this.attributeMap.get((Object)attribute) * this.attributeWeights.get((Object)attribute);
        }
        return result;
    }

    public static enum ScoreAttribute {
        TOWN_LORDS(20),
        TOWN_KNIGHTS(10),
        TOWN_RESIDENTS(5),
        LAND_LORDS(4),
        LAND_KNIGHTS(2),
        LAND_RESIDENTS(1);

        private final int weight;

        private ScoreAttribute(int weight) {
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

