/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.api.model.KonquestPlot;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class KonPlot
implements KonquestPlot {
    private final HashSet<Point> points;
    private final ArrayList<UUID> users;

    public KonPlot(Point origin) {
        this.points = new HashSet();
        this.users = new ArrayList();
        this.points.add(origin);
    }

    public KonPlot(HashSet<Point> points, ArrayList<UUID> users) {
        this.points = points;
        this.users = users;
    }

    public void addPoint(Point p) {
        this.points.add(p);
    }

    public boolean removePoint(Point p) {
        return this.points.remove(p);
    }

    @Override
    public boolean hasPoint(Point p) {
        return this.points.contains(p);
    }

    @Override
    public List<Point> getPoints() {
        return new ArrayList<Point>(this.points);
    }

    public void addUsers(List<UUID> u) {
        for (UUID id : u) {
            this.addUser(id);
        }
    }

    public void addUser(UUID u) {
        if (!this.users.contains(u)) {
            this.users.add(u);
        }
    }

    public void addUser(OfflinePlayer u) {
        this.addUser(u.getUniqueId());
    }

    public boolean removeUser(UUID u) {
        return this.users.remove(u);
    }

    public boolean removeUser(OfflinePlayer u) {
        return this.removeUser(u.getUniqueId());
    }

    public void clearUsers() {
        this.users.clear();
    }

    @Override
    public boolean hasUser(OfflinePlayer u) {
        return this.users.contains(u.getUniqueId());
    }

    @Override
    public List<OfflinePlayer> getUserOfflinePlayers() {
        ArrayList<OfflinePlayer> result = new ArrayList<OfflinePlayer>();
        for (UUID id : this.users) {
            result.add(Bukkit.getOfflinePlayer((UUID)id));
        }
        return result;
    }

    public List<UUID> getUsers() {
        return new ArrayList<UUID>(this.users);
    }

    public List<String> getUserStrings() {
        ArrayList<String> result = new ArrayList<String>();
        for (UUID id : this.users) {
            result.add(id.toString());
        }
        return result;
    }

    public String getDisplayText() {
        Object result = MessagePath.LABEL_PLOT.getMessage(new Object[0]);
        if (!this.users.isEmpty()) {
            String firstName = Bukkit.getOfflinePlayer((UUID)this.users.get(0)).getName();
            result = (String)result + " " + firstName;
            if (this.users.size() > 1) {
                result = (String)result + " + " + (this.users.size() - 1);
            }
        }
        return result;
    }

    public KonPlot clone() {
        HashSet<Point> clonePoints = new HashSet<Point>(this.points);
        ArrayList<UUID> cloneUsers = new ArrayList<UUID>(this.users);
        return new KonPlot(clonePoints, cloneUsers);
    }
}

