/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.model.KonCustomPrefix;
import com.github.rumsfield.konquest.model.KonPrefixType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class KonPrefix {
    private final ArrayList<KonPrefixType> prefixList = new ArrayList();
    private KonPrefixType mainPrefix;
    private boolean enabled;
    private KonCustomPrefix customPrefix;
    private final HashSet<String> availableCustoms;

    public KonPrefix() {
        this.prefixList.add(KonPrefixType.getDefault());
        this.mainPrefix = KonPrefixType.getDefault();
        this.enabled = false;
        this.customPrefix = null;
        this.availableCustoms = new HashSet();
    }

    public void setEnable(boolean en) {
        this.enabled = en;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addPrefix(KonPrefixType prefix) {
        if (!this.prefixList.contains((Object)prefix)) {
            this.prefixList.add(prefix);
        }
    }

    public void removePrefix(KonPrefixType prefix) {
        this.prefixList.remove((Object)prefix);
    }

    public void clear() {
        this.prefixList.clear();
    }

    public boolean setPrefix(KonPrefixType prefix) {
        boolean result = false;
        if (this.hasPrefix(prefix)) {
            this.mainPrefix = prefix;
            result = true;
        }
        return result;
    }

    public boolean selectPrefix(KonPrefixType prefix) {
        boolean result = false;
        if (this.prefixList.contains((Object)prefix)) {
            this.mainPrefix = prefix;
            this.customPrefix = null;
            result = true;
        }
        return result;
    }

    public boolean hasPrefix(KonPrefixType prefix) {
        return this.prefixList.contains((Object)prefix);
    }

    public String getMainPrefixName() {
        if (this.customPrefix == null) {
            return this.mainPrefix.getName();
        }
        return this.customPrefix.getName();
    }

    public KonPrefixType getMainPrefix() {
        return this.mainPrefix;
    }

    public Collection<String> getPrefixNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (KonPrefixType pre : this.prefixList) {
            result.add(pre.getName());
        }
        return result;
    }

    public boolean setCustomPrefix(KonCustomPrefix prefix) {
        if (this.isCustomAvailable(prefix.getLabel())) {
            this.customPrefix = prefix;
            return true;
        }
        return false;
    }

    public String getCustom() {
        if (this.customPrefix == null) {
            return "";
        }
        return this.customPrefix.getLabel();
    }

    public void addAvailableCustom(String label) {
        this.availableCustoms.add(label);
    }

    public boolean isCustomAvailable(String label) {
        return this.availableCustoms.contains(label);
    }
}

