/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.model.KonPrefixCategory;
import com.github.rumsfield.konquest.utility.MessagePath;

public enum KonPrefixType {
    KING(KonPrefixCategory.ROYALTY, 10, MessagePath.PREFIX_TITLE_KING.getMessage(new Object[0])),
    QUEEN(KonPrefixCategory.ROYALTY, 10, MessagePath.PREFIX_TITLE_QUEEN.getMessage(new Object[0])),
    PRINCE(KonPrefixCategory.ROYALTY, 3, MessagePath.PREFIX_TITLE_PRINCE.getMessage(new Object[0])),
    PRINCESS(KonPrefixCategory.ROYALTY, 3, MessagePath.PREFIX_TITLE_PRINCESS.getMessage(new Object[0])),
    NOBLE(KonPrefixCategory.ROYALTY, 1, MessagePath.PREFIX_TITLE_NOBLE.getMessage(new Object[0])),
    CARDINAL(KonPrefixCategory.CLERGY, 1000, MessagePath.PREFIX_TITLE_CARDINAL.getMessage(new Object[0])),
    BISHOP(KonPrefixCategory.CLERGY, 750, MessagePath.PREFIX_TITLE_BISHOP.getMessage(new Object[0])),
    PRIEST(KonPrefixCategory.CLERGY, 500, MessagePath.PREFIX_TITLE_PRIEST.getMessage(new Object[0])),
    CLERIC(KonPrefixCategory.CLERGY, 300, MessagePath.PREFIX_TITLE_CLERIC.getMessage(new Object[0])),
    CHAPLAIN(KonPrefixCategory.CLERGY, 200, MessagePath.PREFIX_TITLE_CHAPLAIN.getMessage(new Object[0])),
    SCRIBE(KonPrefixCategory.CLERGY, 100, MessagePath.PREFIX_TITLE_SCRIBE.getMessage(new Object[0])),
    VICEROY(KonPrefixCategory.NOBILITY, 300, MessagePath.PREFIX_TITLE_VICEROY.getMessage(new Object[0])),
    DUKE(KonPrefixCategory.NOBILITY, 150, MessagePath.PREFIX_TITLE_DUKE.getMessage(new Object[0])),
    COUNT(KonPrefixCategory.NOBILITY, 100, MessagePath.PREFIX_TITLE_COUNT.getMessage(new Object[0])),
    EARL(KonPrefixCategory.NOBILITY, 75, MessagePath.PREFIX_TITLE_EARL.getMessage(new Object[0])),
    BARON(KonPrefixCategory.NOBILITY, 50, MessagePath.PREFIX_TITLE_BARON.getMessage(new Object[0])),
    LORD(KonPrefixCategory.NOBILITY, 30, MessagePath.PREFIX_TITLE_LORD.getMessage(new Object[0])),
    VASSAL(KonPrefixCategory.NOBILITY, 15, MessagePath.PREFIX_TITLE_VASSAL.getMessage(new Object[0])),
    PEASANT(KonPrefixCategory.NOBILITY, 0, MessagePath.PREFIX_TITLE_PEASANT.getMessage(new Object[0])),
    MASTER(KonPrefixCategory.TRADESMAN, 5000, MessagePath.PREFIX_TITLE_MASTER.getMessage(new Object[0])),
    ARTISAN(KonPrefixCategory.TRADESMAN, 2000, MessagePath.PREFIX_TITLE_ARTISAN.getMessage(new Object[0])),
    JOURNEYMAN(KonPrefixCategory.TRADESMAN, 1000, MessagePath.PREFIX_TITLE_JOURNEYMAN.getMessage(new Object[0])),
    CRAFTSMAN(KonPrefixCategory.TRADESMAN, 500, MessagePath.PREFIX_TITLE_CRAFTSMAN.getMessage(new Object[0])),
    MERCHANT(KonPrefixCategory.TRADESMAN, 250, MessagePath.PREFIX_TITLE_MERCHANT.getMessage(new Object[0])),
    PEDDLER(KonPrefixCategory.TRADESMAN, 100, MessagePath.PREFIX_TITLE_PEDDLER.getMessage(new Object[0])),
    GENERAL(KonPrefixCategory.MILITARY, 800, MessagePath.PREFIX_TITLE_GENERAL.getMessage(new Object[0])),
    MAJOR(KonPrefixCategory.MILITARY, 400, MessagePath.PREFIX_TITLE_MAJOR.getMessage(new Object[0])),
    CAPTAIN(KonPrefixCategory.MILITARY, 200, MessagePath.PREFIX_TITLE_CAPTAIN.getMessage(new Object[0])),
    SERGEANT(KonPrefixCategory.MILITARY, 100, MessagePath.PREFIX_TITLE_SERGEANT.getMessage(new Object[0])),
    KNIGHT(KonPrefixCategory.MILITARY, 50, MessagePath.PREFIX_TITLE_KNIGHT.getMessage(new Object[0])),
    SQUIRE(KonPrefixCategory.MILITARY, 10, MessagePath.PREFIX_TITLE_SQUIRE.getMessage(new Object[0])),
    COWBOY(KonPrefixCategory.FARMING, 1500, MessagePath.PREFIX_TITLE_COWBOY.getMessage(new Object[0])),
    BREEDER(KonPrefixCategory.FARMING, 1000, MessagePath.PREFIX_TITLE_BREEDER.getMessage(new Object[0])),
    RANCHER(KonPrefixCategory.FARMING, 600, MessagePath.PREFIX_TITLE_RANCHER.getMessage(new Object[0])),
    FARMER(KonPrefixCategory.FARMING, 300, MessagePath.PREFIX_TITLE_FARMER.getMessage(new Object[0])),
    PICKER(KonPrefixCategory.FARMING, 150, MessagePath.PREFIX_TITLE_PICKER.getMessage(new Object[0])),
    SPROUT(KonPrefixCategory.FARMING, 50, MessagePath.PREFIX_TITLE_SPROUT.getMessage(new Object[0])),
    JESTER(KonPrefixCategory.JOKING, 100, MessagePath.PREFIX_TITLE_JESTER.getMessage(new Object[0])),
    FOOL(KonPrefixCategory.JOKING, 69, MessagePath.PREFIX_TITLE_FOOL.getMessage(new Object[0])),
    DANCER(KonPrefixCategory.JOKING, 50, MessagePath.PREFIX_TITLE_DANCER.getMessage(new Object[0])),
    BARD(KonPrefixCategory.JOKING, 20, MessagePath.PREFIX_TITLE_BARD.getMessage(new Object[0])),
    FISHERMAN(KonPrefixCategory.FISHING, 200, MessagePath.PREFIX_TITLE_FISHERMAN.getMessage(new Object[0])),
    CASTER(KonPrefixCategory.FISHING, 100, MessagePath.PREFIX_TITLE_CASTER.getMessage(new Object[0])),
    CHUM(KonPrefixCategory.FISHING, 20, MessagePath.PREFIX_TITLE_CHUM.getMessage(new Object[0])),
    CHEF(KonPrefixCategory.COOKING, 200, MessagePath.PREFIX_TITLE_CHEF.getMessage(new Object[0])),
    COOK(KonPrefixCategory.COOKING, 100, MessagePath.PREFIX_TITLE_COOK.getMessage(new Object[0])),
    BAKER(KonPrefixCategory.COOKING, 20, MessagePath.PREFIX_TITLE_BAKER.getMessage(new Object[0]));

    private final KonPrefixCategory category;
    private final int level;
    private final String name;

    private KonPrefixType(KonPrefixCategory category, int level, String name) {
        this.category = category;
        this.level = level;
        this.name = name;
    }

    public KonPrefixCategory category() {
        return this.category;
    }

    public int level() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public static KonPrefixType getDefault() {
        return PEASANT;
    }

    public static KonPrefixType getPrefix(String name) {
        KonPrefixType result = KonPrefixType.getDefault();
        for (KonPrefixType pre : KonPrefixType.values()) {
            if (!pre.toString().equalsIgnoreCase(name)) continue;
            result = pre;
        }
        return result;
    }

    public static boolean isPrefixName(String name) {
        boolean result = false;
        for (KonPrefixType pre : KonPrefixType.values()) {
            if (!pre.getName().equalsIgnoreCase(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static KonPrefixType getPrefixByName(String name) {
        KonPrefixType result = KonPrefixType.getDefault();
        for (KonPrefixType pre : KonPrefixType.values()) {
            if (!pre.getName().equalsIgnoreCase(name)) continue;
            result = pre;
        }
        return result;
    }
}

