/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestRuin;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.manager.LootManager;
import com.github.rumsfield.konquest.model.KonBarDisplayer;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonRuinGolem;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class KonRuin
extends KonTerritory
implements KonquestRuin,
KonBarDisplayer,
KonPropertyFlagHolder,
Timeable {
    private final Timer spawnTimer;
    private final Timer captureTimer;
    private final Timer captureCountdownTimer;
    private boolean isCaptureDisabled;
    private final BossBar ruinBarAll;
    private final Map<KonPropertyFlag, Boolean> properties = new HashMap<KonPropertyFlag, Boolean>();
    private final HashMap<Location, Boolean> criticalLocations;
    private final HashMap<Location, KonRuinGolem> spawnLocations;
    private String lootTableName;

    public KonRuin(Location loc, String name, KonKingdom kingdom, Konquest konquest) {
        super(loc, name, kingdom, konquest);
        this.initProperties();
        this.spawnTimer = new Timer(this);
        this.captureTimer = new Timer(this);
        this.captureCountdownTimer = new Timer(this);
        this.isCaptureDisabled = false;
        this.ruinBarAll = Bukkit.getServer().createBossBar(this.getTitleName(), BarColor.WHITE, BarStyle.SOLID, new BarFlag[0]);
        this.ruinBarAll.setVisible(true);
        this.criticalLocations = new HashMap();
        this.spawnLocations = new HashMap();
        this.lootTableName = LootManager.defaultLootTableName;
    }

    public static List<KonPropertyFlag> getProperties() {
        ArrayList<KonPropertyFlag> result = new ArrayList<KonPropertyFlag>();
        result.add(KonPropertyFlag.ARENA);
        result.add(KonPropertyFlag.PVP);
        result.add(KonPropertyFlag.PVE);
        result.add(KonPropertyFlag.USE);
        result.add(KonPropertyFlag.CHEST);
        result.add(KonPropertyFlag.PORTALS);
        result.add(KonPropertyFlag.ENTER);
        result.add(KonPropertyFlag.EXIT);
        return result;
    }

    @Override
    public void initProperties() {
        this.properties.clear();
        for (KonPropertyFlag flag : KonRuin.getProperties()) {
            this.properties.put(flag, this.getKonquest().getConfigManager().getConfig("properties").getBoolean("properties.ruins." + flag.toString().toLowerCase()));
        }
    }

    @Override
    public boolean setPropertyValue(KonPropertyFlag property, boolean value) {
        boolean result = false;
        if (this.properties.containsKey((Object)property)) {
            this.properties.put(property, value);
            result = true;
        }
        return result;
    }

    @Override
    public boolean getPropertyValue(KonPropertyFlag property) {
        boolean result = false;
        if (this.properties.containsKey((Object)property)) {
            result = this.properties.get((Object)property);
        }
        return result;
    }

    @Override
    public boolean hasPropertyValue(KonPropertyFlag property) {
        return this.properties.containsKey((Object)property);
    }

    @Override
    public Map<KonPropertyFlag, Boolean> getAllProperties() {
        return new HashMap<KonPropertyFlag, Boolean>(this.properties);
    }

    @Override
    public int initClaim() {
        this.addChunk(HelperUtil.toPoint(this.getCenterLoc()));
        return 0;
    }

    @Override
    public boolean addChunk(Point point) {
        this.addPoint(point);
        return true;
    }

    @Override
    public boolean testChunk(Point point) {
        return true;
    }

    @Override
    public void onEndTimer(int taskID) {
        if (taskID == 0) {
            ChatUtil.printDebug("Ruin Timer ended with null taskID!");
        } else if (taskID != this.spawnTimer.getTaskID()) {
            if (taskID == this.captureTimer.getTaskID()) {
                ChatUtil.printDebug("Ruin Capture Timer ended with taskID: " + taskID);
                this.isCaptureDisabled = false;
                this.captureCountdownTimer.stopTimer();
                this.setBarProgress(1.0);
                this.updateBarTitle();
                this.regenCriticalBlocks();
                if (this.isEmpty()) {
                    this.removeAllGolems();
                } else {
                    this.spawnAllGolems();
                }
                this.getKonquest().getLootManager().resetRuinLoot(this);
                this.getKonquest().getMapHandler().drawLabelTerritory(this);
            } else if (taskID == this.captureCountdownTimer.getTaskID()) {
                String remainingTime = HelperUtil.getTimeFormat(this.captureTimer.getTime(), ChatColor.RED);
                this.ruinBarAll.setTitle(this.getTitleName() + " " + remainingTime);
            } else {
                for (KonRuinGolem golem : this.spawnLocations.values()) {
                    if (taskID != golem.getRespawnTimerId()) continue;
                    golem.setIsRespawnCooldown(false);
                    if (!this.isCaptureDisabled && !this.isEmpty()) {
                        golem.spawn();
                        continue;
                    }
                    ChatUtil.printDebug("Failed to respawn golem in disabled or empty ruin " + this.getName());
                }
            }
        }
    }

    public boolean onCriticalHit(Location criticalLoc) {
        this.startCaptureTimer();
        if (!this.criticalLocations.containsKey(criticalLoc)) {
            ChatUtil.printDebug("Bad critical location for Ruin " + this.getName());
            return false;
        }
        this.criticalLocations.put(criticalLoc, false);
        this.updateBarProgress();
        if (this.getRemainingCriticalHits() == 0) {
            this.setIsCaptureDisabled(true);
            return true;
        }
        this.respawnAllDistantGolems();
        return false;
    }

    public void resetRuinCapture() {
        this.isCaptureDisabled = false;
        this.captureCountdownTimer.stopTimer();
        this.captureTimer.stopTimer();
        this.setBarProgress(1.0);
        this.updateBarTitle();
        this.regenCriticalBlocks();
        this.respawnAllGolems();
        this.getKonquest().getLootManager().resetRuinLoot(this);
        this.getKonquest().getMapHandler().drawLabelTerritory(this);
    }

    public void regenCriticalBlocks() {
        for (Location loc : this.criticalLocations.keySet()) {
            this.criticalLocations.put(loc, true);
            if (loc.getWorld() != null) {
                loc.getWorld().getChunkAt(loc).load();
                loc.getWorld().getBlockAt(loc).setType(this.getKonquest().getRuinManager().getRuinCriticalBlock());
                loc.getWorld().playSound(loc, Sound.BLOCK_ANVIL_PLACE, 1.0f, 0.6f);
                continue;
            }
            ChatUtil.printDebug("Failed to regen critical ruin location in invalid world.");
        }
    }

    @Override
    public boolean isCaptureDisabled() {
        return this.isCaptureDisabled;
    }

    private void setIsCaptureDisabled(boolean val) {
        this.isCaptureDisabled = val;
        if (val) {
            this.killAllGolems();
            this.captureCountdownTimer.stopTimer();
            this.captureCountdownTimer.setTime(0);
            this.captureCountdownTimer.startLoopTimer();
            this.getKonquest().getMapHandler().drawLabelTerritory(this);
        }
    }

    public String getLootTableName() {
        return this.lootTableName.isEmpty() ? LootManager.defaultLootTableName : this.lootTableName;
    }

    public void setLootTableName(String name) {
        this.lootTableName = name.isEmpty() ? LootManager.defaultLootTableName : name;
    }

    public boolean isLootTableDefault() {
        return this.lootTableName.equalsIgnoreCase(LootManager.defaultLootTableName);
    }

    public void setLootTableDefault() {
        this.lootTableName = LootManager.defaultLootTableName;
    }

    private void startCaptureTimer() {
        int ruinCaptureTimeSeconds = this.getKonquest().getCore().getInt(CorePath.RUINS_CAPTURE_COOLDOWN.getPath());
        this.captureTimer.stopTimer();
        this.captureTimer.setTime(ruinCaptureTimeSeconds);
        this.captureTimer.startTimer();
        ChatUtil.printDebug("Starting ruin capture timer for " + ruinCaptureTimeSeconds + " seconds with taskID " + this.captureTimer.getTaskID() + " for Ruin " + this.getName());
    }

    public String getCaptureCooldownString() {
        return this.isCaptureDisabled ? String.format("%02d:%02d", this.captureTimer.getMinutes(), this.captureTimer.getSeconds()) : "00:00";
    }

    public String getCaptureTime() {
        String noColor = "";
        int timerCount = Math.max(this.captureTimer.getTime(), 0);
        return HelperUtil.getTimeFormat(timerCount, noColor);
    }

    @Override
    public void addBarPlayer(KonPlayer player) {
        this.ruinBarAll.addPlayer(player.getBukkitPlayer());
    }

    @Override
    public void removeBarPlayer(KonPlayer player) {
        this.ruinBarAll.removePlayer(player.getBukkitPlayer());
    }

    @Override
    public void removeAllBarPlayers() {
        this.ruinBarAll.removeAll();
    }

    @Override
    public void updateBarPlayers() {
        this.ruinBarAll.removeAll();
        for (KonPlayer player : this.getKonquest().getPlayerManager().getPlayersOnline()) {
            Player bukkitPlayer = player.getBukkitPlayer();
            if (!this.isLocInside(bukkitPlayer.getLocation())) continue;
            this.ruinBarAll.addPlayer(bukkitPlayer);
        }
    }

    @Override
    public void updateBarTitle() {
        this.ruinBarAll.setTitle(this.getTitleName());
    }

    private String getTitleName() {
        String title = Konquest.neutralColor2 + MessagePath.TERRITORY_RUIN.getMessage(new Object[0]).trim() + " " + this.getName();
        if (this.properties.get((Object)KonPropertyFlag.ARENA).booleanValue()) {
            title = title + " - " + String.valueOf(ChatColor.RED) + MessagePath.PROPERTIES_ARENA_NAME.getMessage(new Object[0]);
        }
        return title;
    }

    private void updateBarProgress() {
        double progress = (double)this.getRemainingCriticalHits() / (double)this.getMaxCriticalHits();
        this.setBarProgress(progress);
    }

    public void setBarProgress(double progress) {
        this.ruinBarAll.setProgress(progress);
    }

    public void setCriticalLocation(Location loc) {
        if (!this.isLocInside(loc)) {
            return;
        }
        this.criticalLocations.put(loc, true);
        this.getKonquest().getMapHandler().drawLabelTerritory(this);
    }

    @Override
    public boolean addCriticalLocation(Location loc) {
        if (!this.isLocInside(loc)) {
            return false;
        }
        if (!loc.getBlock().getType().equals((Object)this.getKonquest().getRuinManager().getRuinCriticalBlock())) {
            return false;
        }
        this.criticalLocations.put(loc, true);
        this.getKonquest().getMapHandler().drawLabelTerritory(this);
        return true;
    }

    @Override
    public boolean addCriticalLocation(Set<Location> locs) {
        for (Location loc : locs) {
            if (this.addCriticalLocation(loc)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addSpawnLocation(Location loc) {
        if (!this.isLocInside(loc)) {
            return false;
        }
        this.spawnLocations.put(loc, new KonRuinGolem(loc, this));
        this.getKonquest().getMapHandler().drawLabelTerritory(this);
        return true;
    }

    @Override
    public boolean addSpawnLocation(Set<Location> locs) {
        for (Location loc : locs) {
            if (this.addSpawnLocation(loc)) continue;
            return false;
        }
        return true;
    }

    public boolean isCriticalLocation(Location loc) {
        return this.criticalLocations.containsKey(loc);
    }

    public boolean isSpawnLocation(Location loc) {
        return this.spawnLocations.containsKey(loc);
    }

    @Override
    public void clearCriticalLocations() {
        this.criticalLocations.clear();
    }

    @Override
    public void clearSpawnLocations() {
        this.removeAllGolems();
        this.spawnLocations.clear();
    }

    @Override
    public Set<Location> getCriticalLocations() {
        return this.criticalLocations.keySet();
    }

    @Override
    public Set<Location> getSpawnLocations() {
        return this.spawnLocations.keySet();
    }

    public int getMaxCriticalHits() {
        int result = 0;
        if (!this.criticalLocations.isEmpty()) {
            result = this.criticalLocations.size();
        }
        return result;
    }

    @Override
    public int getRemainingCriticalHits() {
        int result = 0;
        if (!this.criticalLocations.isEmpty()) {
            for (boolean status : this.criticalLocations.values()) {
                if (!status) continue;
                ++result;
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = true;
        for (KonPlayer player : this.getKonquest().getPlayerManager().getPlayersOnline()) {
            Location playerLoc = player.getBukkitPlayer().getLocation();
            if (!this.getKonquest().getTerritoryManager().isChunkClaimed(playerLoc) || !this.getKonquest().getTerritoryManager().getChunkTerritory(playerLoc).equals(this)) continue;
            result = false;
            break;
        }
        return result;
    }

    public void spawnAllGolems() {
        this.pruneGolems();
        if (!this.isCaptureDisabled) {
            for (KonRuinGolem golem : this.spawnLocations.values()) {
                if (!this.isLocInside(golem.getLocation())) {
                    golem.remove();
                }
                golem.spawn();
            }
        }
    }

    public void pruneGolems() {
        if (!this.isCaptureDisabled) {
            int min_distance_town = this.getKonquest().getCore().getInt(CorePath.TOWNS_MIN_DISTANCE_TOWN.getPath());
            for (Entity ent : this.getCenterLoc().getWorld().getNearbyEntities(this.getCenterLoc(), (double)(min_distance_town * 16), 64.0, (double)(min_distance_town * 16))) {
                if (!ent.getType().equals((Object)EntityType.IRON_GOLEM) || !(ent instanceof IronGolem)) continue;
                IronGolem foundGolem = (IronGolem)ent;
                boolean foundMatches = false;
                for (KonRuinGolem golem : this.spawnLocations.values()) {
                    if (!golem.matches(foundGolem)) continue;
                    foundMatches = true;
                }
                if (foundMatches) continue;
                foundGolem.remove();
                foundGolem = null;
                ChatUtil.printDebug("Pruned Iron Golem in ruin " + this.getName());
            }
        }
    }

    public void respawnAllGolems() {
        if (!this.isCaptureDisabled) {
            for (KonRuinGolem golem : this.spawnLocations.values()) {
                golem.respawn();
            }
        }
    }

    private void respawnAllDistantGolems() {
        if (!this.isCaptureDisabled) {
            for (Location spawnLoc : this.spawnLocations.keySet()) {
                KonRuinGolem golem = this.spawnLocations.get(spawnLoc);
                if (!(golem.getLocation().distance(spawnLoc) > 32.0)) continue;
                golem.respawn();
            }
        }
    }

    public void removeAllGolems() {
        for (KonRuinGolem golem : this.spawnLocations.values()) {
            golem.remove();
        }
    }

    public void removeGolem(Location spawn) {
        if (this.spawnLocations.containsKey(spawn)) {
            this.spawnLocations.get(spawn).remove();
        }
    }

    public void killAllGolems() {
        for (KonRuinGolem golem : this.spawnLocations.values()) {
            golem.kill();
        }
    }

    public void targetAllGolemsToPlayer(Player player) {
        for (KonRuinGolem golem : this.spawnLocations.values()) {
            golem.targetTo((LivingEntity)player);
        }
    }

    public void targetGolemToPlayer(Player player, IronGolem targetGolem) {
        for (KonRuinGolem golem : this.spawnLocations.values()) {
            if (!golem.matches(targetGolem)) continue;
            golem.targetTo((LivingEntity)player);
        }
    }

    public void targetGolemToLast(IronGolem targetGolem) {
        for (KonRuinGolem golem : this.spawnLocations.values()) {
            if (!golem.matches(targetGolem)) continue;
            golem.targetToLast();
        }
    }

    public LivingEntity getGolemLastTarget(IronGolem targetGolem) {
        LivingEntity result = null;
        for (KonRuinGolem golem : this.spawnLocations.values()) {
            if (!golem.matches(targetGolem)) continue;
            result = golem.getLastTarget();
        }
        return result;
    }

    public void stopTargetingPlayer(Player player) {
        for (KonRuinGolem golem : this.spawnLocations.values()) {
            if (!golem.isTarget((LivingEntity)player)) continue;
            golem.dropTargets();
        }
    }

    public boolean isGolem(IronGolem testGolem) {
        boolean result = false;
        for (KonRuinGolem golem : this.spawnLocations.values()) {
            if (!golem.matches(testGolem)) continue;
            result = true;
        }
        return result;
    }

    public void onGolemDeath(IronGolem deadGolem) {
        for (KonRuinGolem golem : this.spawnLocations.values()) {
            if (!golem.matches(deadGolem)) continue;
            golem.setIsRespawnCooldown(true);
            golem.setLastTarget(null);
            int golemRespawnTimeSeconds = this.getKonquest().getCore().getInt(CorePath.RUINS_RESPAWN_COOLDOWN.getPath());
            golem.startRespawnTimer(golemRespawnTimeSeconds);
        }
    }

    @Override
    public KonquestTerritoryType getTerritoryType() {
        return KonquestTerritoryType.RUIN;
    }
}

