/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.model.KonRuin;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.Timer;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;

public class KonRuinGolem {
    private final Location spawnLoc;
    private IronGolem golem;
    private final Timer respawnTimer;
    private boolean isRespawnCooldown;
    private LivingEntity lastTarget;

    public KonRuinGolem(Location spawnLoc, KonRuin ruin) {
        this.spawnLoc = spawnLoc;
        this.golem = null;
        this.respawnTimer = new Timer(ruin);
        this.isRespawnCooldown = false;
        this.lastTarget = null;
    }

    public void spawn() {
        this.spawn(false);
    }

    public void spawn(boolean force) {
        if (!force && this.isRespawnCooldown) {
            return;
        }
        if (this.golem == null || this.golem.isDead()) {
            AttributeInstance golemSpeed;
            Attribute movementSpeed;
            double baseValue;
            AttributeInstance golemHealth;
            Location modLoc = new Location(this.spawnLoc.getWorld(), this.spawnLoc.getX() + 0.5, this.spawnLoc.getY() + 1.0, this.spawnLoc.getZ() + 0.5);
            if (!modLoc.getChunk().isLoaded()) {
                modLoc.getChunk().load();
            }
            this.golem = (IronGolem)this.spawnLoc.getWorld().spawnEntity(modLoc, EntityType.IRON_GOLEM);
            this.golem.setPlayerCreated(true);
            Attribute maxHealth = CompatibilityUtil.getAttribute("health");
            if (maxHealth != null && (golemHealth = this.golem.getAttribute(maxHealth)) != null) {
                baseValue = golemHealth.getBaseValue();
                golemHealth.setBaseValue(baseValue * 4.0);
                this.golem.setHealth(baseValue * 1.5);
            }
            if ((movementSpeed = CompatibilityUtil.getAttribute("speed")) != null && (golemSpeed = this.golem.getAttribute(movementSpeed)) != null) {
                baseValue = golemSpeed.getBaseValue();
                golemSpeed.setBaseValue(baseValue * 1.5);
            }
            this.spawnLoc.getWorld().playSound(this.spawnLoc, Sound.ENTITY_IRON_GOLEM_REPAIR, 1.0f, 1.2f);
        }
    }

    public void respawn() {
        this.remove();
        this.spawn(true);
    }

    public void remove() {
        if (this.golem != null) {
            if (!this.golem.getLocation().getChunk().isEntitiesLoaded()) {
                if (this.golem.getLocation().getChunk().load()) {
                    this.golem.remove();
                    ChatUtil.printDebug("Successfully removed golem in newly loaded chunk");
                } else {
                    ChatUtil.printDebug("Failed to load chunk for golem removal");
                }
            } else {
                this.golem.remove();
                ChatUtil.printDebug("Successfully removed golem in previously loaded chunk");
            }
        }
    }

    public void kill() {
        if (this.golem != null) {
            this.golem.damage(this.golem.getHealth());
        }
    }

    public Location getLocation() {
        if (this.golem != null && !this.golem.isDead()) {
            return this.golem.getLocation();
        }
        return this.spawnLoc;
    }

    public void targetTo(LivingEntity target) {
        if (this.golem != null && !this.golem.isDead()) {
            this.golem.setTarget(null);
            this.golem.setTarget(target);
            this.lastTarget = target;
            this.spawnLoc.getWorld().playSound(this.golem.getLocation(), Sound.ENTITY_WITHER_HURT, 1.0f, 0.4f);
        }
    }

    public void targetToLast() {
        if (this.lastTarget == null) {
            return;
        }
        this.targetTo(this.lastTarget);
    }

    public LivingEntity getLastTarget() {
        return this.lastTarget;
    }

    public void setLastTarget(LivingEntity target) {
        this.lastTarget = target;
    }

    public boolean isTarget(LivingEntity target) {
        LivingEntity currentTarget;
        boolean result = false;
        if (this.golem != null && !this.golem.isDead() && (currentTarget = this.golem.getTarget()) != null) {
            result = currentTarget.equals((Object)target);
        }
        return result;
    }

    public void dropTargets() {
        if (this.golem != null && !this.golem.isDead()) {
            this.golem.setTarget(null);
            this.lastTarget = null;
        }
    }

    public boolean matches(IronGolem otherGolem) {
        boolean result = false;
        if (this.golem != null) {
            result = this.golem.equals((Object)otherGolem);
        }
        return result;
    }

    public void setIsRespawnCooldown(boolean val) {
        this.isRespawnCooldown = val;
    }

    public void startRespawnTimer(int duration) {
        this.respawnTimer.stopTimer();
        this.respawnTimer.setTime(duration);
        this.respawnTimer.startTimer();
    }

    public int getRespawnTimerId() {
        return this.respawnTimer.getTaskID();
    }
}

