/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestSanctuary;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.model.KonBarDisplayer;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class KonSanctuary
extends KonTerritory
implements KonquestSanctuary,
KonBarDisplayer,
KonPropertyFlagHolder,
Timeable {
    private final BossBar sanctuaryBarAll;
    private final Map<KonPropertyFlag, Boolean> properties = new HashMap<KonPropertyFlag, Boolean>();
    private final Map<String, KonMonumentTemplate> templates;
    private final Map<String, Timer> templateBlankingTimers;

    public KonSanctuary(Location loc, String name, KonKingdom kingdom, Konquest konquest) {
        super(loc, name, kingdom, konquest);
        this.initProperties();
        this.sanctuaryBarAll = Bukkit.getServer().createBossBar(this.getTitleName(), BarColor.WHITE, BarStyle.SEGMENTED_20, new BarFlag[0]);
        this.sanctuaryBarAll.setVisible(true);
        this.templates = new HashMap<String, KonMonumentTemplate>();
        this.templateBlankingTimers = new HashMap<String, Timer>();
    }

    public static List<KonPropertyFlag> getProperties() {
        ArrayList<KonPropertyFlag> result = new ArrayList<KonPropertyFlag>();
        result.add(KonPropertyFlag.TRAVEL);
        result.add(KonPropertyFlag.ARENA);
        result.add(KonPropertyFlag.PVP);
        result.add(KonPropertyFlag.PVE);
        result.add(KonPropertyFlag.BUILD);
        result.add(KonPropertyFlag.USE);
        result.add(KonPropertyFlag.CHEST);
        result.add(KonPropertyFlag.MOBS);
        result.add(KonPropertyFlag.PORTALS);
        result.add(KonPropertyFlag.ENTER);
        result.add(KonPropertyFlag.EXIT);
        result.add(KonPropertyFlag.SHOP);
        return result;
    }

    @Override
    public void initProperties() {
        this.properties.clear();
        for (KonPropertyFlag flag : KonSanctuary.getProperties()) {
            this.properties.put(flag, this.getKonquest().getConfigManager().getConfig("properties").getBoolean("properties.sanctuaries." + flag.toString().toLowerCase()));
        }
    }

    @Override
    public void addBarPlayer(KonPlayer player) {
        if (this.sanctuaryBarAll == null) {
            return;
        }
        this.sanctuaryBarAll.addPlayer(player.getBukkitPlayer());
    }

    @Override
    public void removeBarPlayer(KonPlayer player) {
        if (this.sanctuaryBarAll == null) {
            return;
        }
        this.sanctuaryBarAll.removePlayer(player.getBukkitPlayer());
    }

    @Override
    public void removeAllBarPlayers() {
        if (this.sanctuaryBarAll == null) {
            return;
        }
        this.sanctuaryBarAll.removeAll();
    }

    @Override
    public void updateBarPlayers() {
        if (this.sanctuaryBarAll == null) {
            return;
        }
        this.sanctuaryBarAll.removeAll();
        for (KonPlayer player : this.getKonquest().getPlayerManager().getPlayersOnline()) {
            Player bukkitPlayer = player.getBukkitPlayer();
            if (!this.isLocInside(bukkitPlayer.getLocation())) continue;
            this.sanctuaryBarAll.addPlayer(bukkitPlayer);
        }
    }

    @Override
    public void updateBarTitle() {
        this.sanctuaryBarAll.setTitle(this.getTitleName());
    }

    private String getTitleName() {
        String title = Konquest.neutralColor2 + MessagePath.TERRITORY_SANCTUARY.getMessage(new Object[0]).trim() + " " + this.getName();
        if (this.properties.get((Object)KonPropertyFlag.ARENA).booleanValue()) {
            title = title + " - " + String.valueOf(ChatColor.RED) + MessagePath.PROPERTIES_ARENA_NAME.getMessage(new Object[0]);
        }
        return title;
    }

    @Override
    public int initClaim() {
        this.addChunk(HelperUtil.toPoint(this.getCenterLoc()));
        return 0;
    }

    @Override
    public boolean addChunk(Point point) {
        this.addPoint(point);
        return true;
    }

    @Override
    public boolean testChunk(Point point) {
        return true;
    }

    @Override
    public KonquestTerritoryType getTerritoryType() {
        return KonquestTerritoryType.SANCTUARY;
    }

    @Override
    public boolean setPropertyValue(KonPropertyFlag property, boolean value) {
        boolean result = false;
        if (this.properties.containsKey((Object)property)) {
            this.properties.put(property, value);
            result = true;
        }
        return result;
    }

    @Override
    public boolean getPropertyValue(KonPropertyFlag property) {
        boolean result = false;
        if (this.properties.containsKey((Object)property)) {
            result = this.properties.get((Object)property);
        }
        return result;
    }

    @Override
    public boolean hasPropertyValue(KonPropertyFlag property) {
        return this.properties.containsKey((Object)property);
    }

    @Override
    public Map<KonPropertyFlag, Boolean> getAllProperties() {
        return new HashMap<KonPropertyFlag, Boolean>(this.properties);
    }

    public Collection<KonMonumentTemplate> getTemplates() {
        return this.templates.values();
    }

    public Set<String> getTemplateNames() {
        HashSet<String> result = new HashSet<String>();
        for (KonMonumentTemplate template : this.templates.values()) {
            result.add(template.getName());
        }
        return result;
    }

    public boolean isTemplate(String name) {
        return this.templates.containsKey(name.toLowerCase());
    }

    public boolean isLocInsideTemplate(Location loc) {
        boolean result = false;
        for (KonMonumentTemplate template : this.templates.values()) {
            if (!template.isLocInside(loc)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean addTemplate(String name, KonMonumentTemplate template) {
        boolean result = false;
        if (!this.templates.containsKey(name.toLowerCase())) {
            this.templates.put(name.toLowerCase(), template);
            result = true;
        }
        return result;
    }

    public KonMonumentTemplate getTemplate(String name) {
        KonMonumentTemplate result = null;
        if (this.templates.containsKey(name.toLowerCase())) {
            result = this.templates.get(name.toLowerCase());
        }
        return result;
    }

    public KonMonumentTemplate getTemplate(Location loc) {
        KonMonumentTemplate result = null;
        for (KonMonumentTemplate template : this.templates.values()) {
            if (!template.isLocInside(loc)) continue;
            result = template;
            break;
        }
        return result;
    }

    public boolean renameTemplate(String name, String newName) {
        String nameLower = name.toLowerCase();
        if (this.templates.containsKey(nameLower)) {
            KonMonumentTemplate template = this.templates.remove(nameLower);
            template.setName(newName);
            this.templates.put(newName.toLowerCase(), template);
            return true;
        }
        return false;
    }

    public boolean removeTemplate(String name) {
        boolean result = false;
        String nameLower = name.toLowerCase();
        if (this.templates.containsKey(nameLower)) {
            this.templates.remove(nameLower);
            result = true;
        }
        return result;
    }

    public void clearAllTemplates() {
        this.templates.clear();
    }

    public boolean isChunkOnTemplate(Point point, World world) {
        for (KonMonumentTemplate template : this.templates.values()) {
            if (!template.isInsideChunk(point, world)) continue;
            return true;
        }
        return false;
    }

    public void startTemplateBlanking(String name) {
        KonMonumentTemplate template = this.getTemplate(name);
        if (template != null) {
            if (!template.isBlanking()) {
                ChatUtil.sendBroadcast(MessagePath.PROTECTION_NOTICE_TEMPLATE_MODIFY.getMessage(template.getName()));
                ChatUtil.printDebug("Starting monument blanking for template " + name);
            }
            this.stopTemplateBlanking(name);
            template.setBlanking(true);
            template.setValid(false);
            Timer timer = new Timer(this);
            timer.stopTimer();
            timer.setTime(60);
            timer.startTimer();
            this.templateBlankingTimers.put(name.toLowerCase(), timer);
        } else {
            ChatUtil.printDebug("Failed to start blanking for unknown template " + name);
        }
    }

    public void stopTemplateBlanking(String name) {
        KonMonumentTemplate template = this.getTemplate(name);
        if (template != null) {
            template.setBlanking(false);
        } else {
            ChatUtil.printDebug("Failed to stop blanking for unknown template " + name);
        }
        String nameLower = name.toLowerCase();
        if (this.templateBlankingTimers.containsKey(nameLower)) {
            this.templateBlankingTimers.get(nameLower).stopTimer();
            this.templateBlankingTimers.remove(nameLower);
        }
    }

    @Override
    public void onEndTimer(int taskID) {
        if (taskID == 0) {
            ChatUtil.printDebug("Sanctuary Timer ended with null taskID!");
        } else {
            block7: for (String templateName : this.templateBlankingTimers.keySet()) {
                if (taskID != this.templateBlankingTimers.get(templateName).getTaskID()) continue;
                ChatUtil.printDebug("Sanctuary " + this.getName() + ", Template " + templateName + " blanking Timer ended with taskID: " + taskID);
                KonMonumentTemplate monumentTemplate = this.getTemplate(templateName);
                if (monumentTemplate == null) continue;
                int status = this.getKonquest().getSanctuaryManager().validateTemplate(monumentTemplate, this);
                ChatUtil.printDebug("Template validation completed with return code: " + status);
                switch (status) {
                    case 0: {
                        ChatUtil.sendBroadcast(MessagePath.PROTECTION_NOTICE_TEMPLATE_READY.getMessage(monumentTemplate.getName()));
                        monumentTemplate.setValid(true);
                        monumentTemplate.setBlanking(false);
                        this.getKonquest().getKingdomManager().reloadMonumentsForTemplate(monumentTemplate);
                        continue block7;
                    }
                    case 1: {
                        Location c1 = monumentTemplate.getCornerOne();
                        Location c2 = monumentTemplate.getCornerTwo();
                        int diffX = (int)Math.abs(c1.getX() - c2.getX()) + 1;
                        int diffZ = (int)Math.abs(c1.getZ() - c2.getZ()) + 1;
                        ChatUtil.sendAdminBroadcast(MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_FAIL_BASE.getMessage(monumentTemplate.getName(), diffX, diffZ));
                        continue block7;
                    }
                    case 2: {
                        String criticalBlockTypeName = this.getKonquest().getCore().getString(CorePath.MONUMENTS_CRITICAL_BLOCK.getPath());
                        int maxCriticalhits = this.getKonquest().getCore().getInt(CorePath.MONUMENTS_DESTROY_AMOUNT.getPath());
                        ChatUtil.sendAdminBroadcast(MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_FAIL_CRITICAL.getMessage(monumentTemplate.getName(), maxCriticalhits, criticalBlockTypeName));
                        continue block7;
                    }
                    case 3: {
                        ChatUtil.sendAdminBroadcast(MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_FAIL_TRAVEL.getMessage(monumentTemplate.getName()));
                        continue block7;
                    }
                    case 4: {
                        ChatUtil.sendAdminBroadcast(MessagePath.COMMAND_ADMIN_MONUMENT_ERROR_FAIL_REGION.getMessage(monumentTemplate.getName()));
                        continue block7;
                    }
                }
                ChatUtil.printDebug("Monument blanking timer ended with unknown status for template " + monumentTemplate.getName());
            }
        }
    }
}

