/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestTerritory;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.HelperUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public abstract class KonTerritory
implements KonquestTerritory {
    private final HashMap<Point, KonTerritory> chunkList;
    private final Location centerLoc;
    private Location spawnLoc;
    private KonKingdom kingdom;
    private String name;
    private final Konquest konquest;

    public KonTerritory(Location loc, String name, KonKingdom kingdom, Konquest konquest) {
        this.centerLoc = loc;
        this.spawnLoc = loc;
        this.name = name;
        this.kingdom = kingdom;
        this.konquest = konquest;
        this.chunkList = new HashMap();
    }

    public boolean addChunks(ArrayList<Point> points) {
        boolean pass = true;
        for (Point point : points) {
            if (this.addChunk(point)) continue;
            pass = false;
            ChatUtil.printDebug("Failed to add point " + point.toString() + " in territory " + this.name);
        }
        return pass;
    }

    public void addPoint(Point point) {
        this.chunkList.put(point, this);
    }

    public void addPoints(ArrayList<Point> points) {
        for (Point point : points) {
            this.chunkList.put(point, this);
        }
    }

    public void addPoints(Set<Point> points) {
        for (Point point : points) {
            this.chunkList.put(point, this);
        }
    }

    public boolean removeChunk(Location loc) {
        return this.removeChunk(HelperUtil.toPoint(loc));
    }

    public boolean removeChunk(Point point) {
        return this.chunkList.remove(point) != null;
    }

    public void clearChunks() {
        this.chunkList.clear();
    }

    @Override
    public boolean isLocInside(Location loc) {
        return loc.getWorld().equals((Object)this.getWorld()) && this.chunkList.containsKey(HelperUtil.toPoint(loc));
    }

    public boolean isLocInCenter(Location loc) {
        return loc.getWorld().equals((Object)this.getWorld()) && HelperUtil.toPoint(loc).equals(HelperUtil.toPoint(this.centerLoc));
    }

    public boolean hasChunk(Chunk chunk) {
        return chunk.getWorld().equals((Object)this.getWorld()) && this.chunkList.containsKey(HelperUtil.toPoint(chunk));
    }

    @Override
    public boolean isLocAdjacent(Location loc) {
        boolean result = false;
        int[] coordLUTX = new int[]{0, 1, 0, -1};
        int[] coordLUTZ = new int[]{1, 0, -1, 0};
        Point center = HelperUtil.toPoint(loc);
        for (int i = 0; i < 4; ++i) {
            if (!loc.getWorld().equals((Object)this.getWorld()) || !this.chunkList.containsKey(new Point(center.x + coordLUTX[i], center.y + coordLUTZ[i]))) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public Location getCenterLoc() {
        return this.centerLoc;
    }

    @Override
    public World getWorld() {
        return this.centerLoc.getWorld();
    }

    @Override
    public Location getSpawnLoc() {
        return this.spawnLoc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getTravelName() {
        if (this.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
            return this.kingdom.getName();
        }
        return this.name;
    }

    @Override
    public KonKingdom getKingdom() {
        return this.kingdom;
    }

    public HashMap<Point, KonTerritory> getChunkList() {
        return this.chunkList;
    }

    @Override
    public HashSet<Point> getChunkPoints() {
        return new HashSet<Point>(this.chunkList.keySet());
    }

    public Konquest getKonquest() {
        return this.konquest;
    }

    public void setSpawn(Location loc) {
        this.spawnLoc = loc;
    }

    public void setKingdom(KonKingdom newKingdom) {
        this.kingdom = newKingdom;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public abstract int initClaim();

    public abstract boolean addChunk(Point var1);

    public abstract boolean testChunk(Point var1);

    @Override
    public abstract KonquestTerritoryType getTerritoryType();
}

