/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.model;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.event.town.KonquestTownRaidEvent;
import com.github.rumsfield.konquest.api.model.KonquestRelationshipType;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.api.model.KonquestTown;
import com.github.rumsfield.konquest.api.model.KonquestUpgrade;
import com.github.rumsfield.konquest.model.KonBarDisplayer;
import com.github.rumsfield.konquest.model.KonCapital;
import com.github.rumsfield.konquest.model.KonGlobalEventEffect;
import com.github.rumsfield.konquest.model.KonKingdom;
import com.github.rumsfield.konquest.model.KonMonument;
import com.github.rumsfield.konquest.model.KonMonumentTemplate;
import com.github.rumsfield.konquest.model.KonOfflinePlayer;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPlot;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTownOption;
import com.github.rumsfield.konquest.model.KonUpgrade;
import com.github.rumsfield.konquest.utility.BlockPaster;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CompatibilityUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.HelperUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.RequestKeeper;
import com.github.rumsfield.konquest.utility.Timeable;
import com.github.rumsfield.konquest.utility.Timer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class KonTown
extends KonTerritory
implements KonquestTown,
KonBarDisplayer,
KonPropertyFlagHolder,
Timeable {
    private KonMonument monument;
    private final Timer monumentTimer;
    private final Timer captureTimer;
    private final Timer raidAlertTimer;
    private final Timer shieldTimer;
    private final Timer protectedWarmupTimer;
    private final HashMap<UUID, Timer> playerTravelTimers;
    private boolean isCaptureDisabled;
    private boolean isRaidAlertDisabled;
    private final BossBar monumentBarFriendlies;
    private final BossBar monumentBarWar;
    private final BossBar monumentBarPeace;
    private final BossBar monumentBarTrade;
    private final BossBar monumentBarAlliance;
    private final BossBar capitalSwapBar;
    private UUID lord;
    private final HashMap<UUID, Boolean> residents;
    private final HashMap<UUID, Double> purchaseOffers;
    private RequestKeeper joinRequestKeeper;
    private final HashMap<KonTownOption, Boolean> townOptions;
    private final HashMap<KonTownOption, Boolean> townOptionsOverride;
    private boolean isAttacked;
    private boolean isShielded;
    private boolean isShieldFreeEvent;
    private boolean isShieldDisableEvent;
    private boolean isArmored;
    private boolean isArmorDisableEvent;
    private boolean isTownWatchProtected;
    private int shieldEndTimeSeconds;
    private int shieldNowTimeSeconds;
    private int shieldStoreTimeSeconds;
    private int armorTotalBlocks;
    private int armorCurrentBlocks;
    private double armorProgress;
    private final ArrayList<UUID> defenders;
    private final HashMap<KonquestUpgrade, Integer> upgrades;
    private final HashMap<KonquestUpgrade, Integer> disabledUpgrades;
    private final HashMap<Point, KonPlot> plots;
    private final Map<KonPropertyFlag, Boolean> properties;
    private Villager.Profession specialization;

    public KonTown(Location loc, String name, KonKingdom kingdom, Konquest konquest) {
        super(loc, name, kingdom, konquest);
        this.monument = new KonMonument(loc);
        this.monumentTimer = new Timer(this);
        this.captureTimer = new Timer(this);
        this.raidAlertTimer = new Timer(this);
        this.shieldTimer = new Timer(this);
        this.protectedWarmupTimer = new Timer(this);
        this.playerTravelTimers = new HashMap();
        this.isCaptureDisabled = false;
        this.isRaidAlertDisabled = false;
        this.monumentBarFriendlies = Bukkit.getServer().createBossBar(Konquest.friendColor2 + name, ChatUtil.mapBarColor(Konquest.friendColor1), BarStyle.SOLID, new BarFlag[0]);
        this.monumentBarFriendlies.setVisible(true);
        this.monumentBarFriendlies.setProgress(1.0);
        this.monumentBarWar = Bukkit.getServer().createBossBar(Konquest.enemyColor2 + name, ChatUtil.mapBarColor(Konquest.enemyColor1), BarStyle.SOLID, new BarFlag[0]);
        this.monumentBarWar.setVisible(true);
        this.monumentBarWar.setProgress(1.0);
        this.monumentBarPeace = Bukkit.getServer().createBossBar(Konquest.peacefulColor2 + name, ChatUtil.mapBarColor(Konquest.peacefulColor1), BarStyle.SOLID, new BarFlag[0]);
        this.monumentBarPeace.setVisible(true);
        this.monumentBarPeace.setProgress(1.0);
        this.monumentBarTrade = Bukkit.getServer().createBossBar(Konquest.tradeColor2 + name, ChatUtil.mapBarColor(Konquest.tradeColor1), BarStyle.SOLID, new BarFlag[0]);
        this.monumentBarTrade.setVisible(true);
        this.monumentBarTrade.setProgress(1.0);
        this.monumentBarAlliance = Bukkit.getServer().createBossBar(Konquest.alliedColor2 + name, ChatUtil.mapBarColor(Konquest.alliedColor1), BarStyle.SOLID, new BarFlag[0]);
        this.monumentBarAlliance.setVisible(true);
        this.monumentBarAlliance.setProgress(1.0);
        this.capitalSwapBar = Bukkit.getServer().createBossBar(String.valueOf(ChatColor.GOLD), ChatUtil.mapBarColor(ChatColor.GOLD), BarStyle.SOLID, new BarFlag[0]);
        this.capitalSwapBar.setVisible(false);
        this.capitalSwapBar.setProgress(1.0);
        this.lord = null;
        this.residents = new HashMap();
        this.purchaseOffers = new HashMap();
        this.joinRequestKeeper = new RequestKeeper();
        this.isAttacked = false;
        this.isShielded = false;
        this.isShieldFreeEvent = false;
        this.isShieldDisableEvent = false;
        this.isArmored = false;
        this.isArmorDisableEvent = false;
        this.isTownWatchProtected = false;
        this.shieldEndTimeSeconds = 0;
        this.shieldNowTimeSeconds = 0;
        this.shieldStoreTimeSeconds = 0;
        this.armorTotalBlocks = 0;
        this.armorCurrentBlocks = 0;
        this.armorProgress = 0.0;
        this.defenders = new ArrayList();
        this.upgrades = new HashMap();
        this.disabledUpgrades = new HashMap();
        this.plots = new HashMap();
        this.townOptions = new HashMap();
        this.townOptionsOverride = new HashMap();
        this.initOptions();
        this.properties = new HashMap<KonPropertyFlag, Boolean>();
        this.initProperties();
        this.specialization = Villager.Profession.NONE;
    }

    public KonTown copy(KonTown copyTown) {
        copyTown.addPoints(this.getChunkPoints());
        copyTown.setMonument(this.monument);
        for (UUID id : this.residents.keySet()) {
            copyTown.addPlayerResident(Bukkit.getOfflinePlayer((UUID)id), this.residents.get(id), false);
        }
        copyTown.setLord(this.lord, false);
        copyTown.setJoinRequests(this.joinRequestKeeper);
        if (this.isShielded) {
            copyTown.activateShield(this.shieldEndTimeSeconds);
        }
        if (this.isArmored) {
            copyTown.activateArmor(this.armorCurrentBlocks);
        }
        for (KonPlot plot : this.getPlots()) {
            copyTown.putPlot(plot);
        }
        for (KonTownOption option : this.townOptions.keySet()) {
            copyTown.setTownOption(option, this.townOptions.get((Object)option));
        }
        copyTown.refreshOptionOverrides();
        for (KonPropertyFlag flag : this.properties.keySet()) {
            copyTown.setPropertyValue(flag, this.properties.get((Object)flag));
        }
        for (KonquestUpgrade upgrade : this.upgrades.keySet()) {
            copyTown.addUpgrade(upgrade, this.upgrades.get(upgrade));
        }
        copyTown.setSpecialization(this.specialization);
        return copyTown;
    }

    private void initOptions() {
        this.townOptions.clear();
        for (KonTownOption option : KonTownOption.values()) {
            this.townOptions.put(option, option.getDefaultValue());
            if (!option.equals((Object)KonTownOption.KINGDOM_RESIDENTS) || !this.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) continue;
            this.townOptions.put(option, true);
        }
        this.refreshOptionOverrides();
    }

    public void refreshOptionOverrides() {
        String sectionName;
        ConfigurationSection townSection;
        this.townOptionsOverride.clear();
        FileConfiguration townOptionsConfig = this.getKonquest().getConfigManager().getConfig("town-options");
        if (townOptionsConfig.get("town-options") == null) {
            return;
        }
        ConfigurationSection globalSection = townOptionsConfig.getConfigurationSection("town-options.global");
        if (globalSection != null) {
            for (String globalOptionName : globalSection.getKeys(false)) {
                KonTownOption globalOptionOverride = KonTownOption.getOption(globalOptionName);
                if (globalOptionOverride == null) continue;
                boolean optionValue = globalSection.getBoolean(globalOptionName);
                this.townOptionsOverride.put(globalOptionOverride, optionValue);
            }
        }
        if ((townSection = townOptionsConfig.getConfigurationSection("town-options." + (sectionName = this instanceof KonCapital ? this.getKingdom().getName() : this.getName()))) != null) {
            for (String townOptionName : townSection.getKeys(false)) {
                KonTownOption townOptionOverride = KonTownOption.getOption(townOptionName);
                if (townOptionOverride == null) continue;
                boolean optionValue = townSection.getBoolean(townOptionName);
                this.townOptionsOverride.put(townOptionOverride, optionValue);
            }
        }
    }

    public static List<KonPropertyFlag> getProperties() {
        ArrayList<KonPropertyFlag> result = new ArrayList<KonPropertyFlag>();
        result.add(KonPropertyFlag.CAPTURE);
        result.add(KonPropertyFlag.CLAIM);
        result.add(KonPropertyFlag.UNCLAIM);
        result.add(KonPropertyFlag.UPGRADE);
        result.add(KonPropertyFlag.PLOTS);
        result.add(KonPropertyFlag.SPECIALIZE);
        result.add(KonPropertyFlag.TRAVEL);
        result.add(KonPropertyFlag.PVP);
        result.add(KonPropertyFlag.PVE);
        result.add(KonPropertyFlag.BUILD);
        result.add(KonPropertyFlag.USE);
        result.add(KonPropertyFlag.CHEST);
        result.add(KonPropertyFlag.MOBS);
        result.add(KonPropertyFlag.PORTALS);
        result.add(KonPropertyFlag.JOIN);
        result.add(KonPropertyFlag.LEAVE);
        result.add(KonPropertyFlag.PROMOTE);
        result.add(KonPropertyFlag.DEMOTE);
        result.add(KonPropertyFlag.TRANSFER);
        result.add(KonPropertyFlag.SHOP);
        return result;
    }

    @Override
    public void initProperties() {
        this.properties.clear();
        for (KonPropertyFlag flag : KonTown.getProperties()) {
            this.properties.put(flag, this.getKonquest().getConfigManager().getConfig("properties").getBoolean("properties.towns." + flag.toString().toLowerCase()));
        }
    }

    public boolean isJoinable() {
        return this.getPropertyValue(KonPropertyFlag.JOIN);
    }

    public boolean isLeaveable() {
        return this.getPropertyValue(KonPropertyFlag.LEAVE);
    }

    public boolean isPromoteable() {
        return this.getPropertyValue(KonPropertyFlag.PROMOTE);
    }

    public boolean isDemoteable() {
        return this.getPropertyValue(KonPropertyFlag.DEMOTE);
    }

    public boolean isTransferable() {
        return this.getPropertyValue(KonPropertyFlag.TRANSFER);
    }

    @Override
    public boolean setPropertyValue(KonPropertyFlag property, boolean value) {
        boolean result = false;
        if (this.properties.containsKey((Object)property)) {
            this.properties.put(property, value);
            result = true;
        }
        return result;
    }

    @Override
    public boolean getPropertyValue(KonPropertyFlag property) {
        boolean result = false;
        if (this.properties.containsKey((Object)property)) {
            result = this.properties.get((Object)property);
        }
        return result;
    }

    @Override
    public boolean hasPropertyValue(KonPropertyFlag property) {
        return this.properties.containsKey((Object)property);
    }

    @Override
    public Map<KonPropertyFlag, Boolean> getAllProperties() {
        return new HashMap<KonPropertyFlag, Boolean>(this.properties);
    }

    public void setSpecialization(Villager.Profession newSpec) {
        this.specialization = newSpec;
    }

    @Override
    public Villager.Profession getSpecialization() {
        return this.specialization;
    }

    public String getSpecializationName() {
        return CompatibilityUtil.getProfessionName(this.specialization);
    }

    public void applyTradeDiscounts(KonPlayer player, Inventory inv) {
        Villager host;
        MerchantInventory merch;
        boolean isDiscountEnabled = this.getKonquest().getKingdomManager().getIsDiscountEnable();
        if (!isDiscountEnabled) {
            return;
        }
        if (inv != null && inv.getType().equals((Object)InventoryType.MERCHANT) && inv instanceof MerchantInventory && (merch = (MerchantInventory)inv).getHolder() != null && merch.getHolder() instanceof Villager && CompatibilityUtil.isProfessionEqual((host = (Villager)merch.getHolder()).getProfession(), this.getSpecialization())) {
            double discountPercent = this.getKonquest().getKingdomManager().getDiscountPercent();
            boolean isDiscountStack = this.getKonquest().getKingdomManager().getIsDiscountStack();
            if (discountPercent > 0.0) {
                double priceAdj = discountPercent / 100.0;
                boolean doNotification = false;
                try {
                    int amount = 0;
                    int discount = 0;
                    Merchant tradeHost = merch.getMerchant();
                    ArrayList<MerchantRecipe> tradeListDiscounted = new ArrayList<MerchantRecipe>();
                    for (MerchantRecipe trade : tradeHost.getRecipes()) {
                        ChatUtil.printDebug("Found trade for " + trade.getResult().getType().toString() + " with price mult " + trade.getPriceMultiplier() + ", special " + trade.getSpecialPrice() + ", uses " + trade.getUses() + ", max " + trade.getMaxUses());
                        List ingredientList = trade.getIngredients();
                        for (ItemStack ingredient : ingredientList) {
                            ChatUtil.printDebug("  Has ingredient " + ingredient.getType().toString() + ", amount: " + ingredient.getAmount());
                        }
                        if (!ingredientList.isEmpty()) {
                            amount = ((ItemStack)ingredientList.get(0)).getAmount();
                            discount = (int)((double)amount * priceAdj * -1.0);
                            if (isDiscountStack) {
                                discount += trade.getSpecialPrice();
                            }
                            trade.setSpecialPrice(discount);
                            ChatUtil.printDebug("  Applied special price " + discount);
                        }
                        tradeListDiscounted.add(trade);
                    }
                    tradeHost.setRecipes(tradeListDiscounted);
                    doNotification = true;
                }
                catch (NoSuchMethodError compatibility) {
                    ChatUtil.printDebug("Attempting to use version handler to apply trade discounts...");
                    if (this.getKonquest().isVersionHandlerEnabled()) {
                        this.getKonquest().getVersionHandler().applyTradeDiscount(priceAdj, isDiscountStack, merch);
                        doNotification = true;
                    }
                    ChatUtil.printDebug("Version handler is not available.");
                }
                if (doNotification) {
                    Konquest.playDiscountSound(player.getBukkitPlayer());
                    String discountStr = "" + discountPercent;
                    ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.COMMAND_KINGDOM_NOTICE_DISCOUNT.getMessage(this.getKingdom().getName(), discountStr));
                }
            }
        }
    }

    @Override
    public boolean addChunk(Point point) {
        boolean testResult = this.testChunk(point);
        if (testResult) {
            this.addPoint(point);
        }
        return testResult;
    }

    @Override
    public boolean testChunk(Point point) {
        int initRange;
        Point centerChunk = HelperUtil.toPoint(this.getCenterLoc());
        int maxChunkRange = this.getKonquest().getCore().getInt(CorePath.TOWNS_MAX_SIZE.getPath());
        if (maxChunkRange < 0) {
            maxChunkRange = 0;
        }
        if ((initRange = this.getKonquest().getCore().getInt(CorePath.TOWNS_INIT_RADIUS.getPath())) > 0 && maxChunkRange < initRange) {
            maxChunkRange = initRange;
        }
        if (maxChunkRange >= 1) {
            int distX = (int)Math.abs(point.getX() - centerChunk.getX());
            int distY = (int)Math.abs(point.getY() - centerChunk.getY());
            if (distX > maxChunkRange - 1 || distY > maxChunkRange - 1) {
                ChatUtil.printDebug("Failed to test chunk in territory " + this.getName() + ", too far");
                return false;
            }
        }
        return true;
    }

    @Override
    public int initClaim() {
        if (!this.getKingdom().isMonumentTemplateValid()) {
            return 7;
        }
        int flatness = this.getKonquest().getCore().getInt(CorePath.TOWNS_SETTLE_CHECK_FLATNESS.getPath(), 3);
        int monumentStatus = this.monument.initialize(this.getKingdom().getMonumentTemplate(), this.getCenterLoc(), flatness);
        if (monumentStatus != 0) {
            ChatUtil.printDebug("Town init failed: monument did not initialize correctly");
            return 10 + monumentStatus;
        }
        int config_min_y = this.getKonquest().getCore().getInt(CorePath.TOWNS_MIN_SETTLE_HEIGHT.getPath());
        int config_max_y = this.getKonquest().getCore().getInt(CorePath.TOWNS_MAX_SETTLE_HEIGHT.getPath());
        if (config_min_y < 0) {
            config_min_y = 0;
        }
        if (config_min_y != 0 && this.monument.getBaseY() < config_min_y) {
            ChatUtil.printDebug("Town init failed: " + this.monument.getBaseY() + " less than min limit " + config_min_y);
            return 2;
        }
        if (config_max_y > this.getWorld().getMaxHeight()) {
            config_max_y = this.getWorld().getMaxHeight();
        }
        if (config_max_y != 0 && this.monument.getBaseY() > config_max_y) {
            ChatUtil.printDebug("Town init failed: " + this.monument.getBaseY() + " greater than max limit " + config_max_y);
            return 2;
        }
        int world_min_y = this.getWorld().getMinHeight();
        int world_max_y = this.getWorld().getMaxHeight();
        if (this.monument.getBaseY() <= world_min_y) {
            ChatUtil.printDebug("Town init failed: " + this.monument.getBaseY() + " less than world min limit " + world_min_y);
            return 2;
        }
        if (this.monument.getBaseY() >= world_max_y) {
            ChatUtil.printDebug("Town init failed: " + this.monument.getBaseY() + " greater than world max limit " + world_max_y);
            return 2;
        }
        if (this.monument.getBaseY() + this.getKingdom().getMonumentTemplate().getHeight() + 1 >= this.getWorld().getMaxHeight()) {
            ChatUtil.printDebug("Town init failed: too high");
            return 2;
        }
        int countWaterBlocks = 0;
        int countAirBlocks = 0;
        int countContainers = 0;
        int baseDepth = this.getKonquest().getCore().getInt(CorePath.TOWNS_SETTLE_CHECKS_DEPTH.getPath(), 0);
        int yMin = 0;
        int yMax = this.monument.getBaseY();
        if (baseDepth > 0) {
            yMin = this.monument.getBaseY() - baseDepth;
        }
        if (yMin < this.getWorld().getMinHeight()) {
            yMin = this.getWorld().getMinHeight();
        }
        if (yMax > this.getWorld().getMaxHeight() - 1) {
            yMax = this.getWorld().getMaxHeight() - 1;
        }
        for (int x = 0; x <= 15; ++x) {
            for (int y = this.getWorld().getMinHeight(); y <= this.getWorld().getMaxHeight() - 1; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    Block currentBlock = this.getWorld().getChunkAt(this.getCenterLoc()).getBlock(x, y, z);
                    if (y < yMin || y > yMax) continue;
                    if (currentBlock.getType().equals((Object)Material.WATER)) {
                        ++countWaterBlocks;
                        continue;
                    }
                    if (currentBlock.getType().equals((Object)Material.AIR)) {
                        ++countAirBlocks;
                        continue;
                    }
                    if (!(currentBlock.getState() instanceof Container)) continue;
                    ++countContainers;
                }
            }
        }
        if (baseDepth > 0 && countAirBlocks > 2560) {
            ChatUtil.printDebug("Town init failed: too much air below monument");
            return 4;
        }
        if (countWaterBlocks > 2560) {
            ChatUtil.printDebug("Town init failed: too much water in the chunk");
            return 5;
        }
        if (baseDepth > 0 && countContainers > 0) {
            ChatUtil.printDebug("Town init failed: too many containers in the chunk");
            return 6;
        }
        int radius = this.getKonquest().getCore().getInt(CorePath.TOWNS_INIT_RADIUS.getPath());
        if (radius < 1) {
            radius = 1;
        }
        if (!this.addChunks(HelperUtil.getAreaPoints(this.getCenterLoc(), radius))) {
            ChatUtil.printDebug("Town init failed: problem adding some chunks");
            return 3;
        }
        if (!this.pasteMonumentFromTemplate(this.getKingdom().getMonumentTemplate())) {
            ChatUtil.printDebug("Town init failed: monument did not paste correctly");
            return 1;
        }
        this.monument.setIsValid(true);
        this.setSpawn(this.monument.getTravelPoint());
        return 0;
    }

    public boolean pasteMonumentFromTemplate(KonMonumentTemplate template) {
        int z;
        int x;
        if (template == null || !template.isValid()) {
            return false;
        }
        this.monument.setIsItemDropsDisabled(true);
        this.monument.setIsDamageDisabled(true);
        int topBlockX = Math.max(template.getCornerOne().getBlockX(), template.getCornerTwo().getBlockX());
        int topBlockY = Math.max(template.getCornerOne().getBlockY(), template.getCornerTwo().getBlockY());
        int topBlockZ = Math.max(template.getCornerOne().getBlockZ(), template.getCornerTwo().getBlockZ());
        int bottomBlockX = Math.min(template.getCornerOne().getBlockX(), template.getCornerTwo().getBlockX());
        int bottomBlockY = Math.min(template.getCornerOne().getBlockY(), template.getCornerTwo().getBlockY());
        int bottomBlockZ = Math.min(template.getCornerOne().getBlockZ(), template.getCornerTwo().getBlockZ());
        int monument_y = this.monument.getBaseY();
        int min_fill_y = this.getCenterLoc().getWorld().getMinHeight();
        Chunk fillChunk = this.getCenterLoc().getChunk();
        ChunkSnapshot fillChunkSnap = fillChunk.getChunkSnapshot(true, false, false);
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                int fill_y;
                for (fill_y = fillChunkSnap.getHighestBlockYAt(x, z); (fillChunk.getBlock(x, fill_y, z).isPassable() || !fillChunkSnap.getBlockType(x, fill_y, z).isOccluding()) && fill_y > fillChunk.getWorld().getMinHeight(); --fill_y) {
                }
                if ((x != 0 || z != 0) && fill_y >= min_fill_y) continue;
                min_fill_y = fill_y;
            }
        }
        if (--min_fill_y < this.getCenterLoc().getWorld().getMinHeight()) {
            min_fill_y = this.getCenterLoc().getWorld().getMinHeight();
        }
        ChatUtil.printDebug("Pasting monument (" + fillChunk.getX() + "," + fillChunk.getZ() + ") at base " + monument_y + " found minimum Y level: " + min_fill_y);
        if (min_fill_y < monument_y) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (int y = min_fill_y; y <= monument_y; ++y) {
                        fillChunk.getBlock(x, y, z).setType(Material.STONE);
                    }
                }
            }
        }
        int maxHeight = this.getKonquest().getSanctuaryManager().getTallestTemplateHeight();
        int monumentHeight = this.monument.getHeight();
        if (monumentHeight < maxHeight) {
            int startY = this.monument.getBaseY() + monumentHeight + 1;
            int endY = this.monument.getBaseY() + maxHeight;
            for (int x2 = 0; x2 < 16; ++x2) {
                for (int z2 = 0; z2 < 16; ++z2) {
                    for (int y = startY; y <= endY; ++y) {
                        Block currentBlock = this.getWorld().getChunkAt(this.getCenterLoc()).getBlock(x2, y, z2);
                        currentBlock.setType(Material.AIR);
                    }
                }
            }
        }
        World templateWorld = template.getCornerOne().getWorld();
        BlockPaster monumentPaster = new BlockPaster(fillChunk, templateWorld, bottomBlockY, this.monument.getBaseY(), bottomBlockY, topBlockX, topBlockZ, bottomBlockX, bottomBlockZ);
        for (int y = bottomBlockY; y <= topBlockY; ++y) {
            monumentPaster.setY(y);
            monumentPaster.startPaste();
        }
        this.monument.setIsItemDropsDisabled(false);
        this.monument.setIsDamageDisabled(false);
        return true;
    }

    public boolean removeMonumentBlocks() {
        if (!this.monument.isValid()) {
            ChatUtil.printDebug("Town remove monument failed: Monument is not valid");
            return false;
        }
        int minY = this.monument.getBaseY();
        int maxY = this.monument.getBaseY() + this.monument.getHeight();
        if (minY == 0 || maxY == 0) {
            ChatUtil.printDebug("Town remove monument failed: Base or Height value is 0");
            return false;
        }
        this.monument.setIsItemDropsDisabled(true);
        for (int x = 0; x <= 15; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    Block currentBlock = this.getWorld().getChunkAt(this.getCenterLoc()).getBlock(x, y, z);
                    if (y == minY) {
                        currentBlock.setType(Material.DIRT);
                        continue;
                    }
                    currentBlock.setType(Material.AIR);
                }
            }
        }
        this.monument.setIsItemDropsDisabled(false);
        return true;
    }

    public int countWaterInChunk() {
        int count = 0;
        for (int x = 0; x <= 15; ++x) {
            for (int y = this.getWorld().getMinHeight(); y <= this.getWorld().getMaxHeight() - 1; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    Block currentBlock = this.getWorld().getChunkAt(this.getCenterLoc()).getBlock(x, y, z);
                    if (!currentBlock.getType().equals((Object)Material.WATER)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public int countAirBelowMonument(int limit) {
        int count = 0;
        int yMin = 0;
        int yMax = this.monument.getBaseY();
        if (limit > 0) {
            yMin = this.monument.getBaseY() - limit;
        }
        if (yMin < this.getWorld().getMinHeight()) {
            yMin = this.getWorld().getMinHeight();
        }
        if (yMax > this.getWorld().getMaxHeight() - 1) {
            yMax = this.getWorld().getMaxHeight() - 1;
        }
        for (int x = 0; x <= 15; ++x) {
            for (int y = yMin; y <= yMax; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    Block currentBlock = this.getWorld().getChunkAt(this.getCenterLoc()).getBlock(x, y, z);
                    if (!currentBlock.getType().equals((Object)Material.AIR)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public boolean isLocInsideCenterChunk(Location loc) {
        Point centerPoint = HelperUtil.toPoint(this.getCenterLoc());
        Point testPoint = HelperUtil.toPoint(loc);
        return centerPoint.x == testPoint.x && centerPoint.y == testPoint.y;
    }

    public boolean isChunkCenter(Chunk chunk) {
        Point centerPoint = HelperUtil.toPoint(this.getCenterLoc());
        Point testPoint = HelperUtil.toPoint(chunk);
        return centerPoint.x == testPoint.x && centerPoint.y == testPoint.y;
    }

    public boolean isLocInsideMonumentProtectionArea(Location loc) {
        int bottomLevel;
        Point centerPoint = HelperUtil.toPoint(this.getCenterLoc());
        Point testPoint = HelperUtil.toPoint(loc);
        int baseDepth = this.getKonquest().getCore().getInt(CorePath.TOWNS_SETTLE_CHECKS_DEPTH.getPath(), 0);
        if (baseDepth < 0) {
            baseDepth = 0;
        }
        if ((bottomLevel = this.monument.getBaseY() - baseDepth) < this.getWorld().getMinHeight()) {
            baseDepth = this.getWorld().getMinHeight();
        }
        return centerPoint.x == testPoint.x && centerPoint.y == testPoint.y && loc.getBlockY() >= bottomLevel;
    }

    public int loadMonument(int base, KonMonumentTemplate template) {
        int status = 0;
        this.monument.setBaseY(base);
        if (template != null && template.isValid()) {
            this.monument.updateFromTemplate(template);
            this.monument.setIsValid(true);
        } else {
            status = 1;
        }
        return status;
    }

    public void updateMonumentFromTemplate() {
        if (this.getKingdom().isMonumentTemplateValid()) {
            this.monument.updateFromTemplate(this.getKingdom().getMonumentTemplate());
            this.monument.setIsValid(true);
            this.setSpawn(this.monument.getTravelPoint());
        } else {
            ChatUtil.printDebug("Failed to update monument from invalid template for town " + this.getName());
        }
    }

    public boolean reloadMonument() {
        if (!this.monument.isValid()) {
            ChatUtil.printDebug("Failed to reload invalid monument for town " + this.getName());
            return false;
        }
        if (!this.getKingdom().isMonumentTemplateValid()) {
            ChatUtil.printDebug("Failed to reload monument from invalid template for town " + this.getName());
            return false;
        }
        if (this.isAttacked) {
            ChatUtil.printDebug("Failed to reload monument for attacked town " + this.getName());
            return false;
        }
        this.monument.updateFromTemplate(this.getKingdom().getMonumentTemplate());
        this.pasteMonumentFromTemplate(this.getKingdom().getMonumentTemplate());
        this.setSpawn(this.monument.getTravelPoint());
        return true;
    }

    public void refreshMonument() {
        if (this.monument.isValid()) {
            this.removeMonumentBlocks();
            this.monument.clearCriticalHits();
            this.monument.updateFromTemplate(this.getKingdom().getMonumentTemplate());
            this.setSpawn(this.monument.getTravelPoint());
            Konquest.playTownSettleSound(this.getCenterLoc());
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getKonquest().getPlugin(), new Runnable(){

                @Override
                public void run() {
                    KonTown.this.pasteMonumentFromTemplate(KonTown.this.getKingdom().getMonumentTemplate());
                }
            }, 1L);
        } else {
            ChatUtil.printDebug("Failed to refresh monument from template for town " + this.getName());
        }
    }

    protected void setMonument(KonMonument monumentOverride) {
        this.monument = monumentOverride;
    }

    @Override
    public KonMonument getMonument() {
        return this.monument;
    }

    @Override
    public boolean isCaptureDisabled() {
        return this.isCaptureDisabled;
    }

    public void setIsCaptureDisabled(boolean val) {
        this.isCaptureDisabled = val;
        if (val) {
            int townCaptureTimeSeconds = this.getKonquest().getCore().getInt(CorePath.TOWNS_CAPTURE_COOLDOWN.getPath());
            this.captureTimer.stopTimer();
            this.captureTimer.setTime(townCaptureTimeSeconds);
            this.captureTimer.startTimer();
            ChatUtil.printDebug("Starting capture timer for " + townCaptureTimeSeconds + " seconds with taskID " + this.captureTimer.getTaskID());
            this.getKonquest().getMapHandler().drawLabelTerritory(this);
        } else {
            this.captureTimer.stopTimer();
        }
    }

    public boolean isRaidAlertDisabled() {
        return this.isRaidAlertDisabled;
    }

    public void setIsRaidAlertDisabled(boolean val) {
        this.isRaidAlertDisabled = val;
    }

    public boolean addPlayerTravelCooldown(UUID uuid) {
        if (this.playerTravelTimers.containsKey(uuid)) {
            return false;
        }
        int travelCooldownSeconds = this.getKonquest().getCore().getInt(CorePath.TOWNS_TRAVEL_COOLDOWN.getPath());
        Timer travelCooldownTimer = new Timer(this);
        travelCooldownTimer.stopTimer();
        travelCooldownTimer.setTime(travelCooldownSeconds);
        travelCooldownTimer.startTimer();
        String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
        this.playerTravelTimers.put(uuid, travelCooldownTimer);
        ChatUtil.printDebug("Starting player travel timer for " + travelCooldownSeconds + " seconds with taskID " + travelCooldownTimer.getTaskID() + " for player " + name);
        return true;
    }

    public boolean isPlayerTravelDisabled(UUID uuid) {
        return this.playerTravelTimers.containsKey(uuid);
    }

    public String getPlayerTravelCooldownString(UUID uuid) {
        String cooldownTime = "";
        if (this.playerTravelTimers.containsKey(uuid)) {
            cooldownTime = String.format("%02d:%02d", this.playerTravelTimers.get(uuid).getMinutes(), this.playerTravelTimers.get(uuid).getSeconds());
        }
        return cooldownTime;
    }

    public String getCaptureCooldownString() {
        return this.isCaptureDisabled ? String.format("%02d:%02d", this.captureTimer.getMinutes(), this.captureTimer.getSeconds()) : "00:00";
    }

    @Override
    public void onEndTimer(int taskID) {
        if (taskID == 0) {
            ChatUtil.printDebug("Town Timer ended with null taskID!");
        } else if (taskID == this.monumentTimer.getTaskID()) {
            ChatUtil.printDebug("Monument Timer ended with taskID: " + taskID);
            this.monument.clearCriticalHits();
            this.setAttacked(false, null);
            this.reloadMonument();
            this.updateBarTitle();
            this.getWorld().playSound(this.getCenterLoc(), Sound.BLOCK_ANVIL_USE, 1.0f, 0.8f);
            for (KonPlayer player : this.getKonquest().getPlayerManager().getPlayersInKingdom(this.getKingdom().getName())) {
                ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_SAFE.getMessage(this.getName()), ChatColor.GREEN);
            }
        } else if (taskID == this.captureTimer.getTaskID()) {
            ChatUtil.printDebug("Capture Timer ended with taskID: " + taskID);
            this.isCaptureDisabled = false;
            this.getKonquest().getMapHandler().drawLabelTerritory(this);
        } else if (taskID == this.raidAlertTimer.getTaskID()) {
            ChatUtil.printDebug("Raid Alert Timer ended with taskID: " + taskID);
            this.isRaidAlertDisabled = false;
        } else if (taskID == this.shieldTimer.getTaskID()) {
            Date now = new Date();
            this.shieldNowTimeSeconds = (int)(now.getTime() / 1000L);
            if (this.shieldEndTimeSeconds < this.shieldNowTimeSeconds) {
                this.deactivateShield();
            } else {
                this.updateBarTitle();
            }
        } else if (taskID == this.protectedWarmupTimer.getTaskID()) {
            ChatUtil.printDebug("Town Watch protection warmup Timer ended with taskID: " + taskID);
            this.isTownWatchProtected = true;
        } else {
            for (UUID uuid : this.playerTravelTimers.keySet()) {
                if (taskID != this.playerTravelTimers.get(uuid).getTaskID()) continue;
                String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                ChatUtil.printDebug("Travel Cooldown Timer ended for player: " + name);
                this.playerTravelTimers.remove(uuid);
                return;
            }
            ChatUtil.printDebug("Town Timer ended with unknown taskID: " + taskID);
        }
    }

    public Timer getMonumentTimer() {
        return this.monumentTimer;
    }

    public Timer getRaidAlertTimer() {
        return this.raidAlertTimer;
    }

    public void stopTimers() {
        this.monumentTimer.stopTimer();
        this.captureTimer.stopTimer();
        this.raidAlertTimer.stopTimer();
        this.shieldTimer.stopTimer();
        this.playerTravelTimers.clear();
    }

    @Override
    public void updateBarPlayers() {
        this.monumentBarFriendlies.removeAll();
        this.monumentBarWar.removeAll();
        this.monumentBarAlliance.removeAll();
        this.monumentBarTrade.removeAll();
        this.monumentBarPeace.removeAll();
        this.capitalSwapBar.removeAll();
        for (KonPlayer player : this.getKonquest().getPlayerManager().getPlayersOnline()) {
            Player bukkitPlayer = player.getBukkitPlayer();
            if (!this.isLocInside(bukkitPlayer.getLocation())) continue;
            KonquestRelationshipType role = this.getKonquest().getKingdomManager().getRelationRole(player.getKingdom(), this.getKingdom());
            switch (role) {
                case ENEMY: {
                    this.monumentBarWar.addPlayer(bukkitPlayer);
                    break;
                }
                case FRIENDLY: {
                    this.monumentBarFriendlies.addPlayer(bukkitPlayer);
                    break;
                }
                case ALLY: {
                    this.monumentBarAlliance.addPlayer(bukkitPlayer);
                    break;
                }
                case TRADE: {
                    this.monumentBarTrade.addPlayer(bukkitPlayer);
                    break;
                }
                case PEACEFUL: {
                    this.monumentBarPeace.addPlayer(bukkitPlayer);
                    break;
                }
            }
            this.capitalSwapBar.addPlayer(bukkitPlayer);
        }
    }

    @Override
    public void addBarPlayer(KonPlayer player) {
        KonquestRelationshipType role = this.getKonquest().getKingdomManager().getRelationRole(player.getKingdom(), this.getKingdom());
        switch (role) {
            case ENEMY: {
                this.monumentBarWar.addPlayer(player.getBukkitPlayer());
                break;
            }
            case FRIENDLY: {
                this.monumentBarFriendlies.addPlayer(player.getBukkitPlayer());
                break;
            }
            case ALLY: {
                this.monumentBarAlliance.addPlayer(player.getBukkitPlayer());
                break;
            }
            case TRADE: {
                this.monumentBarTrade.addPlayer(player.getBukkitPlayer());
                break;
            }
            case PEACEFUL: {
                this.monumentBarPeace.addPlayer(player.getBukkitPlayer());
                break;
            }
        }
        this.capitalSwapBar.addPlayer(player.getBukkitPlayer());
    }

    @Override
    public void removeBarPlayer(KonPlayer player) {
        this.monumentBarFriendlies.removePlayer(player.getBukkitPlayer());
        this.monumentBarWar.removePlayer(player.getBukkitPlayer());
        this.monumentBarAlliance.removePlayer(player.getBukkitPlayer());
        this.monumentBarTrade.removePlayer(player.getBukkitPlayer());
        this.monumentBarPeace.removePlayer(player.getBukkitPlayer());
        this.capitalSwapBar.removePlayer(player.getBukkitPlayer());
    }

    @Override
    public void removeAllBarPlayers() {
        this.monumentBarFriendlies.removeAll();
        this.monumentBarWar.removeAll();
        this.monumentBarAlliance.removeAll();
        this.monumentBarTrade.removeAll();
        this.monumentBarPeace.removeAll();
        this.capitalSwapBar.removeAll();
    }

    public void setBarProgress(double prog) {
        this.monumentBarFriendlies.setProgress(prog);
        this.monumentBarWar.setProgress(prog);
        this.monumentBarAlliance.setProgress(prog);
        this.monumentBarTrade.setProgress(prog);
        this.monumentBarPeace.setProgress(prog);
    }

    public void setAttacked(boolean val, KonPlayer attacker) {
        if (val) {
            if (!this.isAttacked) {
                this.isAttacked = true;
                if (attacker != null) {
                    this.updateGolemTargets(attacker, false);
                }
            }
            int monumentRegenTimeSeconds = this.getKonquest().getCore().getInt(CorePath.MONUMENTS_DAMAGE_REGEN.getPath());
            this.monumentTimer.stopTimer();
            this.monumentTimer.setTime(monumentRegenTimeSeconds);
            this.monumentTimer.startTimer();
        } else {
            this.isAttacked = false;
            this.defenders.clear();
        }
    }

    @Override
    public boolean isAttacked() {
        return this.isAttacked;
    }

    public boolean updateProtection(boolean force) {
        boolean isTownWatchValid;
        int upgradeLevel = this.getKonquest().getUpgradeManager().getTownUpgradeLevel(this, KonUpgrade.WATCH);
        boolean bl = isTownWatchValid = upgradeLevel > 0 && this.getNumResidentsOnline() < upgradeLevel;
        if (!isTownWatchValid) {
            this.isTownWatchProtected = false;
            this.protectedWarmupTimer.stopTimer();
        } else if (!this.isTownWatchProtected) {
            int offlineProtectedWarmupSeconds = this.getKonquest().getCore().getInt(CorePath.KINGDOMS_NO_ENEMY_EDIT_OFFLINE_WARMUP.getPath(), 0);
            if (force || offlineProtectedWarmupSeconds <= 0) {
                ChatUtil.printDebug("Town Watch protection enabled without warmup in " + this.getName());
                this.isTownWatchProtected = true;
                this.protectedWarmupTimer.stopTimer();
                return true;
            }
            if (this.protectedWarmupTimer.getTime() == -1) {
                ChatUtil.printDebug("Starting town watch protection warmup timer for " + offlineProtectedWarmupSeconds + " seconds: " + this.getName());
                this.protectedWarmupTimer.stopTimer();
                this.protectedWarmupTimer.setTime(offlineProtectedWarmupSeconds);
                this.protectedWarmupTimer.startTimer();
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateBarTitle() {
        String separator = " - ";
        int remainingSeconds = 0;
        String armor = MessagePath.LABEL_ARMOR.getMessage(new Object[0]);
        String shield = MessagePath.LABEL_SHIELD.getMessage(new Object[0]);
        String critical = MessagePath.LABEL_CRITICAL_HITS.getMessage(new Object[0]);
        if (this.isShielded() && this.isArmored()) {
            remainingSeconds = this.isShieldFreeEvent ? -1 : this.getRemainingShieldTimeSeconds();
            this.monumentBarFriendlies.setTitle(Konquest.friendColor2 + this.getName() + separator + this.armorCurrentBlocks + " " + armor + " | " + shield + " " + HelperUtil.getTimeFormat(remainingSeconds, Konquest.friendColor2));
            this.monumentBarWar.setTitle(Konquest.enemyColor2 + this.getName() + separator + this.armorCurrentBlocks + " " + armor + " | " + shield + " " + HelperUtil.getTimeFormat(remainingSeconds, Konquest.enemyColor2));
            this.monumentBarAlliance.setTitle(Konquest.alliedColor2 + this.getName() + separator + this.armorCurrentBlocks + " " + armor + " | " + shield + " " + HelperUtil.getTimeFormat(remainingSeconds, Konquest.alliedColor2));
            this.monumentBarTrade.setTitle(Konquest.tradeColor2 + this.getName() + separator + this.armorCurrentBlocks + " " + armor + " | " + shield + " " + HelperUtil.getTimeFormat(remainingSeconds, Konquest.tradeColor2));
            this.monumentBarPeace.setTitle(Konquest.peacefulColor2 + this.getName() + separator + this.armorCurrentBlocks + " " + armor + " | " + shield + " " + HelperUtil.getTimeFormat(remainingSeconds, Konquest.peacefulColor2));
        } else if (this.isShielded()) {
            remainingSeconds = this.isShieldFreeEvent ? -1 : this.getRemainingShieldTimeSeconds();
            this.monumentBarFriendlies.setTitle(Konquest.friendColor2 + this.getName() + separator + shield + " " + HelperUtil.getTimeFormat(remainingSeconds, Konquest.friendColor2));
            this.monumentBarWar.setTitle(Konquest.enemyColor2 + this.getName() + separator + shield + " " + HelperUtil.getTimeFormat(remainingSeconds, Konquest.enemyColor2));
            this.monumentBarAlliance.setTitle(Konquest.alliedColor2 + this.getName() + separator + shield + " " + HelperUtil.getTimeFormat(remainingSeconds, Konquest.alliedColor2));
            this.monumentBarTrade.setTitle(Konquest.tradeColor2 + this.getName() + separator + shield + " " + HelperUtil.getTimeFormat(remainingSeconds, Konquest.tradeColor2));
            this.monumentBarPeace.setTitle(Konquest.peacefulColor2 + this.getName() + separator + shield + " " + HelperUtil.getTimeFormat(remainingSeconds, Konquest.peacefulColor2));
        } else if (this.isArmored()) {
            this.monumentBarFriendlies.setTitle(Konquest.friendColor2 + this.getName() + separator + this.armorCurrentBlocks + " " + armor);
            this.monumentBarWar.setTitle(Konquest.enemyColor2 + this.getName() + separator + this.armorCurrentBlocks + " " + armor);
            this.monumentBarAlliance.setTitle(Konquest.alliedColor2 + this.getName() + separator + this.armorCurrentBlocks + " " + armor);
            this.monumentBarTrade.setTitle(Konquest.tradeColor2 + this.getName() + separator + this.armorCurrentBlocks + " " + armor);
            this.monumentBarPeace.setTitle(Konquest.peacefulColor2 + this.getName() + separator + this.armorCurrentBlocks + " " + armor);
        } else if (this.isAttacked) {
            this.monumentBarFriendlies.setTitle(Konquest.friendColor2 + this.getName() + separator + critical);
            this.monumentBarWar.setTitle(Konquest.enemyColor2 + this.getName() + separator + critical);
            this.monumentBarAlliance.setTitle(Konquest.alliedColor2 + this.getName() + separator + critical);
            this.monumentBarTrade.setTitle(Konquest.tradeColor2 + this.getName() + separator + critical);
            this.monumentBarPeace.setTitle(Konquest.peacefulColor2 + this.getName() + separator + critical);
        } else {
            this.monumentBarFriendlies.setTitle(Konquest.friendColor2 + this.getName());
            this.monumentBarWar.setTitle(Konquest.enemyColor2 + this.getName());
            this.monumentBarAlliance.setTitle(Konquest.alliedColor2 + this.getName());
            this.monumentBarTrade.setTitle(Konquest.tradeColor2 + this.getName());
            this.monumentBarPeace.setTitle(Konquest.peacefulColor2 + this.getName());
        }
        if (this.isShielded() || this.isArmored()) {
            this.setAllBarStyle(BarStyle.SEGMENTED_10);
            this.setBarProgress(this.armorProgress);
        } else if (this.isAttacked) {
            this.setAllBarStyle(BarStyle.SOLID);
            int maxCriticalhits = this.getKonquest().getKingdomManager().getMaxCriticalHits();
            double progress = (double)(maxCriticalhits - this.getMonument().getCriticalHits()) / (double)maxCriticalhits;
            this.setBarProgress(progress);
        } else {
            this.setAllBarStyle(BarStyle.SOLID);
            this.setBarProgress(1.0);
        }
    }

    private void setAllBarStyle(BarStyle style) {
        this.monumentBarFriendlies.setStyle(style);
        this.monumentBarWar.setStyle(style);
        this.monumentBarAlliance.setStyle(style);
        this.monumentBarTrade.setStyle(style);
        this.monumentBarPeace.setStyle(style);
    }

    public void updateCapitalSwapBar(double progress, boolean isCapitalNotTown, String countdown) {
        this.capitalSwapBar.setProgress(progress);
        if (progress > 0.0) {
            this.capitalSwapBar.setVisible(true);
            Object titleCount = "";
            if (!countdown.isEmpty()) {
                titleCount = String.valueOf(ChatColor.RESET) + " " + countdown;
            }
            if (isCapitalNotTown) {
                this.capitalSwapBar.setTitle(String.valueOf(ChatColor.GOLD) + MessagePath.LABEL_CHANGING_CAPITAL.getMessage(new Object[0]) + (String)titleCount);
            } else {
                this.capitalSwapBar.setTitle(String.valueOf(ChatColor.GOLD) + MessagePath.LABEL_CHANGING_TOWN.getMessage(new Object[0]) + (String)titleCount);
            }
        } else {
            this.capitalSwapBar.setVisible(false);
            this.capitalSwapBar.setTitle("");
        }
    }

    public boolean addDefender(Player bukkitPlayer) {
        boolean result = false;
        if (!this.defenders.contains(bukkitPlayer.getUniqueId())) {
            this.defenders.add(bukkitPlayer.getUniqueId());
            result = true;
        }
        return result;
    }

    public void applyGlow(Player bukkitPlayer) {
        boolean isGlowEnabled = this.getKonquest().getCore().getBoolean(CorePath.TOWNS_ENEMY_GLOW.getPath(), true);
        if (isGlowEnabled) {
            bukkitPlayer.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 100, 1));
        }
    }

    public void sendRaidAlert(KonPlayer attacker) {
        boolean isPerm = attacker.getBukkitPlayer().hasPermission("konquest.raid.entry");
        if (!this.isRaidAlertDisabled() && isPerm) {
            for (KonPlayer player : this.getKonquest().getPlayerManager().getPlayersInKingdom(this.getKingdom().getName())) {
                if (player.isAdminBypassActive() || player.getBukkitPlayer().getGameMode().equals((Object)GameMode.SPECTATOR)) continue;
                ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), MessagePath.PROTECTION_NOTICE_RAID.getMessage(this.getName(), this.getTravelName()), ChatColor.DARK_RED);
                ChatUtil.sendKonPriorityTitle(player, String.valueOf(ChatColor.DARK_RED) + MessagePath.PROTECTION_NOTICE_RAID_ALERT.getMessage(new Object[0]), String.valueOf(ChatColor.DARK_RED) + this.getName(), 60, 1, 10);
            }
            int raidAlertTimeSeconds = this.getKonquest().getCore().getInt(CorePath.TOWNS_RAID_ALERT_COOLDOWN.getPath());
            ChatUtil.printDebug("Starting raid alert timer for " + raidAlertTimeSeconds + " seconds in town " + this.getName());
            Timer raidAlertTimer = this.getRaidAlertTimer();
            this.setIsRaidAlertDisabled(true);
            raidAlertTimer.stopTimer();
            raidAlertTimer.setTime(raidAlertTimeSeconds);
            raidAlertTimer.startTimer();
            if (this.isAttacked) {
                KonquestTownRaidEvent invokeEvent = new KonquestTownRaidEvent(this.getKonquest(), this, attacker);
                Konquest.callKonquestEvent(invokeEvent);
            }
        }
    }

    public void updateGolemTargets(KonPlayer triggerPlayer, boolean useTriggerPlayerAsTarget) {
        boolean isPlayerInOtherKingdom;
        if (!this.isAttacked() && !this.isGolemOffensive()) {
            return;
        }
        if (!this.getKingdom().getPropertyValue(KonPropertyFlag.GOLEMS)) {
            return;
        }
        boolean isTriggerPlayerEnemy = this.getKonquest().getKingdomManager().isPlayerEnemy(triggerPlayer, this.getKingdom());
        boolean isGolemAttackEnemies = this.getKonquest().getCore().getBoolean(CorePath.KINGDOMS_GOLEM_ATTACK_ENEMIES.getPath());
        boolean isAdminBypassDisabled = !triggerPlayer.isAdminBypassActive();
        boolean bl = isPlayerInOtherKingdom = !triggerPlayer.getKingdom().equals(this.getKingdom());
        if (!(isGolemAttackEnemies && isAdminBypassDisabled && isPlayerInOtherKingdom && isTriggerPlayerEnemy)) {
            return;
        }
        int SEARCH_HEIGHT = 64;
        int CENTER_SEARCH_RADIUS = 192;
        int PLAYER_SEARCH_RADIUS = 128;
        int GOLEM_TARGET_RADIUS = 32;
        Location searchTownLoc = this.getCenterLoc();
        Location searchPlayerLoc = triggerPlayer.getBukkitPlayer().getLocation();
        HashSet nearbyGolems = new HashSet(this.getWorld().getNearbyEntities(searchTownLoc, (double)CENTER_SEARCH_RADIUS, (double)SEARCH_HEIGHT, (double)CENTER_SEARCH_RADIUS, e -> e.getType() == EntityType.IRON_GOLEM));
        nearbyGolems.addAll(this.getWorld().getNearbyEntities(searchPlayerLoc, (double)PLAYER_SEARCH_RADIUS, (double)SEARCH_HEIGHT, (double)PLAYER_SEARCH_RADIUS, e -> e.getType() == EntityType.IRON_GOLEM));
        for (Entity e2 : nearbyGolems) {
            KonPlayer previousTargetPlayer;
            IronGolem golem = (IronGolem)e2;
            if (!this.isLocInside(golem.getLocation()) && this.getKonquest().getTerritoryManager().isChunkClaimed(golem.getLocation())) continue;
            golem.setPlayerCreated(true);
            boolean isNearbyPlayer = false;
            double minDistance = 99.0;
            KonPlayer nearestPlayer = null;
            for (Entity p : golem.getNearbyEntities((double)GOLEM_TARGET_RADIUS, (double)GOLEM_TARGET_RADIUS, (double)GOLEM_TARGET_RADIUS)) {
                double distance;
                KonPlayer nearbyPlayer;
                if (!(p instanceof Player) || (nearbyPlayer = this.getKonquest().getPlayerManager().getPlayer((Player)p)) == null || nearbyPlayer.isAdminBypassActive() || !this.getKonquest().getKingdomManager().isPlayerEnemy(nearbyPlayer, this.getKingdom()) || !this.isLocInside(p.getLocation()) || !useTriggerPlayerAsTarget && nearbyPlayer.equals(triggerPlayer) || !((distance = golem.getLocation().distance(p.getLocation())) < minDistance)) continue;
                minDistance = distance;
                isNearbyPlayer = true;
                nearestPlayer = nearbyPlayer;
            }
            LivingEntity currentTarget = golem.getTarget();
            if (currentTarget instanceof Player && (previousTargetPlayer = this.getKonquest().getPlayerManager().getPlayer((Player)currentTarget)) != null) {
                previousTargetPlayer.removeMobAttacker((Mob)golem);
            }
            if (isNearbyPlayer) {
                golem.setTarget((LivingEntity)nearestPlayer.getBukkitPlayer());
                nearestPlayer.addMobAttacker((Mob)golem);
                continue;
            }
            if (!useTriggerPlayerAsTarget) continue;
            golem.setTarget((LivingEntity)triggerPlayer.getBukkitPlayer());
            triggerPlayer.addMobAttacker((Mob)golem);
        }
    }

    public boolean isTownOptionOverridden(KonTownOption option) {
        return this.townOptionsOverride.containsKey((Object)option);
    }

    public boolean setTownOption(KonTownOption option, boolean value) {
        if (this.townOptions.containsKey((Object)option)) {
            if (this.townOptionsOverride.containsKey((Object)option)) {
                return false;
            }
            this.townOptions.put(option, value);
            return true;
        }
        return false;
    }

    public boolean getTownOption(KonTownOption option) {
        if (this.townOptions.containsKey((Object)option)) {
            return this.townOptionsOverride.containsKey((Object)option) ? this.townOptionsOverride.get((Object)option) : this.townOptions.get((Object)option);
        }
        return false;
    }

    public void setIsOpen(boolean val) {
        this.setTownOption(KonTownOption.OPEN, val);
    }

    @Override
    public boolean isOpen() {
        return this.getTownOption(KonTownOption.OPEN);
    }

    public void setIsAlliedBuildingAllowed(boolean val) {
        this.setTownOption(KonTownOption.ALLIED_BUILDING, val);
    }

    public boolean isAlliedBuildingAllowed() {
        return this.getTownOption(KonTownOption.ALLIED_BUILDING);
    }

    public void setIsFriendlyRedstoneAllowed(boolean val) {
        this.setTownOption(KonTownOption.FRIENDLY_REDSTONE, val);
    }

    public boolean isFriendlyRedstoneAllowed() {
        return this.getTownOption(KonTownOption.FRIENDLY_REDSTONE);
    }

    public void setIsEnemyRedstoneAllowed(boolean val) {
        this.setTownOption(KonTownOption.ENEMY_REDSTONE, val);
    }

    @Override
    public boolean isEnemyRedstoneAllowed() {
        return this.getTownOption(KonTownOption.ENEMY_REDSTONE);
    }

    public void setIsPlotOnly(boolean val) {
        this.setTownOption(KonTownOption.PLOTS_ONLY, val);
    }

    @Override
    public boolean isPlotOnly() {
        return this.getTownOption(KonTownOption.PLOTS_ONLY);
    }

    public void setIsGolemOffensive(boolean val) {
        this.setTownOption(KonTownOption.GOLEM_OFFENSE, val);
    }

    public boolean isGolemOffensive() {
        return this.getTownOption(KonTownOption.GOLEM_OFFENSE);
    }

    public boolean canClaimLordship(KonPlayer player) {
        boolean result = false;
        if (!this.isLordValid() && player.getKingdom().equals(this.getKingdom())) {
            if (this.isOpen()) {
                result = true;
            } else if (this.getPlayerResidents().isEmpty()) {
                result = true;
            } else if (this.isPlayerResident(player.getOfflineBukkitPlayer())) {
                result = true;
            }
        }
        return result;
    }

    public void purgeResidents() {
        this.lord = null;
        this.residents.clear();
        this.joinRequestKeeper.clearRequests();
    }

    public void setPlayerLord(OfflinePlayer player) {
        this.setLord(player.getUniqueId());
    }

    public void setLord(UUID id) {
        this.setLord(id, true);
    }

    public void setLord(UUID id, boolean doUpdates) {
        this.lord = id;
        this.residents.put(id, true);
        if (doUpdates) {
            this.getKonquest().getUpgradeManager().updateTownDisabledUpgrades(this);
            this.getKonquest().getMapHandler().drawLabelTerritory(this);
        }
    }

    @Override
    public boolean isLord(UUID id) {
        boolean status = false;
        if (this.lord != null) {
            status = id.equals(this.lord);
        }
        return status;
    }

    @Override
    public boolean isPlayerLord(OfflinePlayer player) {
        return this.isLord(player.getUniqueId());
    }

    public boolean setPlayerKnight(OfflinePlayer player, boolean val) {
        boolean status = true;
        UUID playerUUID = player.getUniqueId();
        if (this.residents.containsKey(playerUUID) && !this.isLord(playerUUID)) {
            this.residents.put(playerUUID, val);
        } else {
            status = false;
        }
        return status;
    }

    @Override
    public boolean isPlayerKnight(OfflinePlayer player) {
        boolean status = true;
        UUID playerUUID = player.getUniqueId();
        status = this.residents.containsKey(playerUUID) || this.isLord(playerUUID) ? this.residents.get(playerUUID) : false;
        return status;
    }

    public boolean addPlayerResident(OfflinePlayer player, boolean isElite) {
        return this.addPlayerResident(player, isElite, true);
    }

    public boolean addPlayerResident(OfflinePlayer player, boolean isElite, boolean doUpdates) {
        boolean status = false;
        UUID playerUUID = player.getUniqueId();
        if (!this.residents.containsKey(playerUUID)) {
            this.residents.put(playerUUID, isElite);
            if (doUpdates) {
                this.getKonquest().getUpgradeManager().updateTownDisabledUpgrades(this);
                this.getKonquest().getMapHandler().drawLabelTerritory(this);
            }
            status = true;
        }
        return status;
    }

    public boolean removePlayerResident(OfflinePlayer player) {
        boolean status = false;
        UUID playerUUID = player.getUniqueId();
        if (this.residents.containsKey(playerUUID)) {
            this.residents.remove(playerUUID);
            if (this.isPlayerLord(player)) {
                this.lord = null;
            }
            this.getKonquest().getUpgradeManager().updateTownDisabledUpgrades(this);
            this.getKonquest().getMapHandler().drawLabelTerritory(this);
            if (this.residents.isEmpty()) {
                this.clearShieldsArmors();
            }
            for (KonPlot plot : this.getPlots()) {
                plot.removeUser(player);
            }
            status = true;
        }
        return status;
    }

    @Override
    public boolean isPlayerResident(OfflinePlayer player) {
        return this.residents.containsKey(player.getUniqueId());
    }

    @Override
    public boolean isLordValid() {
        return this.lord != null;
    }

    @Override
    public OfflinePlayer getPlayerLord() {
        if (this.lord != null) {
            return Bukkit.getOfflinePlayer((UUID)this.lord);
        }
        return null;
    }

    @Override
    public UUID getLord() {
        return this.lord;
    }

    @Override
    public ArrayList<OfflinePlayer> getPlayerKnights() {
        ArrayList<OfflinePlayer> eliteList = new ArrayList<OfflinePlayer>();
        for (UUID id : this.residents.keySet()) {
            if (id == null || !this.residents.get(id).booleanValue()) continue;
            eliteList.add(Bukkit.getOfflinePlayer((UUID)id));
        }
        return eliteList;
    }

    public ArrayList<OfflinePlayer> getPlayerKnightsOnly() {
        ArrayList<OfflinePlayer> eliteList = new ArrayList<OfflinePlayer>();
        for (UUID id : this.residents.keySet()) {
            if (id == null || !this.residents.get(id).booleanValue() || this.isLord(id)) continue;
            eliteList.add(Bukkit.getOfflinePlayer((UUID)id));
        }
        return eliteList;
    }

    @Override
    public ArrayList<OfflinePlayer> getPlayerResidents() {
        ArrayList<OfflinePlayer> residentList = new ArrayList<OfflinePlayer>();
        for (UUID id : this.residents.keySet()) {
            if (id == null) continue;
            residentList.add(Bukkit.getOfflinePlayer((UUID)id));
        }
        return residentList;
    }

    public ArrayList<OfflinePlayer> getPlayerResidentsOnly() {
        ArrayList<OfflinePlayer> residentList = new ArrayList<OfflinePlayer>();
        for (UUID id : this.residents.keySet()) {
            if (id == null || this.residents.get(id).booleanValue()) continue;
            residentList.add(Bukkit.getOfflinePlayer((UUID)id));
        }
        return residentList;
    }

    public String getPlayerRoleName(KonOfflinePlayer offlinePlayer) {
        return this.getPlayerRoleName(offlinePlayer.getOfflineBukkitPlayer());
    }

    public String getPlayerRoleName(OfflinePlayer offlinePlayer) {
        String result = "";
        if (this.isLord(offlinePlayer.getUniqueId())) {
            result = MessagePath.RELATIONSHIP_ROLE_LORD.getMessage(new Object[0]);
        } else if (this.isPlayerKnight(offlinePlayer)) {
            result = MessagePath.RELATIONSHIP_ROLE_KNIGHT.getMessage(new Object[0]);
        } else if (this.isPlayerResident(offlinePlayer)) {
            result = MessagePath.RELATIONSHIP_ROLE_RESIDENT.getMessage(new Object[0]);
        }
        return result;
    }

    public int getNumLand() {
        return this.getChunkList().size();
    }

    public int getNumResidents() {
        return this.residents.size();
    }

    public int getNumResidentsOnline() {
        int result = 0;
        for (UUID id : this.residents.keySet()) {
            if (!this.getKonquest().getPlayerManager().isOnlinePlayer(Bukkit.getPlayer((UUID)id))) continue;
            ++result;
        }
        return result;
    }

    public Map<KonquestUpgrade, Integer> getUpgrades() {
        HashMap<KonquestUpgrade, Integer> result = new HashMap<KonquestUpgrade, Integer>(this.upgrades);
        return result;
    }

    public void addUpgrade(KonquestUpgrade upgrade, int level) {
        this.upgrades.put(upgrade, level);
    }

    @Override
    public boolean hasUpgrade(KonquestUpgrade upgrade) {
        return this.upgrades.containsKey(upgrade);
    }

    public void clearUpgrades() {
        this.upgrades.clear();
    }

    public int getUpgradeLevel(KonquestUpgrade upgrade) {
        int result = 0;
        if (this.upgrades.containsKey(upgrade)) {
            result = this.disabledUpgrades.containsKey(upgrade) ? this.disabledUpgrades.get(upgrade).intValue() : this.upgrades.get(upgrade).intValue();
        }
        return result;
    }

    public int getRawUpgradeLevel(KonUpgrade upgrade) {
        int result = 0;
        if (this.upgrades.containsKey(upgrade)) {
            result = this.upgrades.get(upgrade);
        }
        return result;
    }

    public void disableUpgrade(KonUpgrade upgrade, int newLevel) {
        this.disabledUpgrades.put(upgrade, newLevel);
    }

    public boolean allowUpgrade(KonUpgrade upgrade) {
        boolean result = false;
        if (this.disabledUpgrades.containsKey(upgrade)) {
            this.disabledUpgrades.remove(upgrade);
            result = true;
        }
        return result;
    }

    @Override
    public boolean isUpgradeDisabled(KonquestUpgrade upgrade) {
        return this.disabledUpgrades.containsKey(upgrade);
    }

    protected void setJoinRequests(RequestKeeper requestOverride) {
        this.joinRequestKeeper = requestOverride;
    }

    public List<OfflinePlayer> getJoinRequests() {
        return this.joinRequestKeeper.getJoinRequests();
    }

    public List<OfflinePlayer> getJoinInvites() {
        return this.joinRequestKeeper.getJoinInvites();
    }

    public boolean addJoinRequest(UUID id, Boolean type) {
        return this.joinRequestKeeper.addJoinRequest(id, type);
    }

    public boolean isJoinRequestValid(UUID id) {
        return this.joinRequestKeeper.isJoinRequestValid(id);
    }

    public boolean isJoinInviteValid(UUID id) {
        return this.joinRequestKeeper.isJoinInviteValid(id);
    }

    public void removeJoinRequest(UUID id) {
        this.joinRequestKeeper.removeJoinRequest(id);
    }

    @Override
    public boolean isTownWatchProtected() {
        boolean isGlobalEventNoProtection = this.getKonquest().getGlobalEventManager().isEffectValid(KonGlobalEventEffect.NO_PROTECTION);
        return this.isTownWatchProtected && !isGlobalEventNoProtection;
    }

    @Override
    public boolean isShielded() {
        return this.isShielded(false);
    }

    public boolean isShielded(boolean ignoreEvents) {
        if (ignoreEvents) {
            return this.isShielded;
        }
        return this.isShieldFreeEvent || this.isShielded && !this.isShieldDisableEvent;
    }

    @Override
    public boolean isArmored() {
        return this.isArmored(false);
    }

    public boolean isArmored(boolean ignoreEvents) {
        if (ignoreEvents) {
            return this.isArmored;
        }
        return this.isArmored && !this.isArmorDisableEvent;
    }

    public void activateShield(int val) {
        if (this.isShielded) {
            this.shieldEndTimeSeconds = val;
        } else {
            this.isShielded = true;
            this.shieldEndTimeSeconds = val;
            Date now = new Date();
            this.shieldNowTimeSeconds = (int)(now.getTime() / 1000L);
            this.shieldTimer.stopTimer();
            this.shieldTimer.setTime(0);
            this.shieldTimer.startLoopTimer();
        }
        this.updateBarTitle();
    }

    public void deactivateShield() {
        if (this.isShielded) {
            this.playDeactivateSound();
        }
        this.isShielded = false;
        this.shieldTimer.stopTimer();
        this.updateBarTitle();
    }

    private void restoreShieldTime() {
        if (this.shieldStoreTimeSeconds > 0) {
            Date now = new Date();
            this.shieldNowTimeSeconds = (int)(now.getTime() / 1000L);
            this.shieldEndTimeSeconds = this.shieldNowTimeSeconds + this.shieldStoreTimeSeconds;
            this.shieldStoreTimeSeconds = 0;
        }
    }

    public void enableShieldFreeEvent(boolean isEventEnable) {
        if (this.isShieldDisableEvent) {
            return;
        }
        boolean wasEventEnabled = this.isShieldFreeEvent;
        if (!wasEventEnabled && isEventEnable) {
            if (this.isShielded) {
                this.shieldStoreTimeSeconds = this.getRemainingShieldTimeSeconds();
            }
            this.playActivateSound();
        } else if (wasEventEnabled && !isEventEnable) {
            this.restoreShieldTime();
        }
        this.isShieldFreeEvent = isEventEnable;
        this.updateBarTitle();
    }

    public void enableShieldDisableEvent(boolean isEventEnable) {
        if (this.isShieldFreeEvent) {
            return;
        }
        boolean wasEventEnabled = this.isShieldDisableEvent;
        if (!wasEventEnabled && isEventEnable) {
            if (this.isShielded) {
                this.shieldStoreTimeSeconds = this.getRemainingShieldTimeSeconds();
            }
            this.playDeactivateSound();
        } else if (wasEventEnabled && !isEventEnable) {
            this.restoreShieldTime();
        }
        this.isShieldDisableEvent = isEventEnable;
        this.updateBarTitle();
    }

    public void enableArmorDisableEvent(boolean isEventEnable) {
        this.isArmorDisableEvent = isEventEnable;
        this.updateBarTitle();
    }

    public void activateArmor(int val) {
        if (!this.isArmored) {
            this.isArmored = true;
        }
        this.armorTotalBlocks = this.armorCurrentBlocks = val;
        this.armorProgress = 1.0;
        this.updateBarTitle();
    }

    public void deactivateArmor() {
        if (this.isArmored) {
            this.playDeactivateSound();
        }
        this.isArmored = false;
        this.armorCurrentBlocks = 0;
        this.armorTotalBlocks = 0;
        this.armorProgress = 0.0;
        this.updateBarTitle();
    }

    public void clearShieldsArmors() {
        this.deactivateShield();
        this.deactivateArmor();
    }

    public boolean damageArmor(int damage) {
        boolean result = false;
        if (this.isArmored) {
            this.armorCurrentBlocks -= damage;
            result = true;
            if (this.armorCurrentBlocks <= 0) {
                this.deactivateArmor();
            } else {
                this.armorProgress = (double)this.armorCurrentBlocks / (double)this.armorTotalBlocks;
                this.updateBarTitle();
            }
        }
        return result;
    }

    public int getShieldEndTime() {
        return this.getShieldEndTime(false);
    }

    public int getShieldEndTime(boolean ignoreEvents) {
        if (ignoreEvents) {
            this.restoreShieldTime();
        }
        return this.shieldEndTimeSeconds;
    }

    public int getArmorBlocks() {
        return this.armorCurrentBlocks;
    }

    public int getRemainingShieldTimeSeconds() {
        int result = 0;
        if (this.isShielded && this.shieldEndTimeSeconds > this.shieldNowTimeSeconds) {
            result = this.shieldEndTimeSeconds - this.shieldNowTimeSeconds;
        }
        return result;
    }

    private void playDeactivateSound() {
        this.getWorld().playSound(this.getCenterLoc(), Sound.BLOCK_GLASS_BREAK, 3.0f, 0.3f);
    }

    private void playActivateSound() {
        this.getWorld().playSound(this.getCenterLoc(), Sound.BLOCK_BEACON_ACTIVATE, 3.0f, 0.3f);
    }

    public void putPlot(KonPlot plot) {
        if (plot == null) {
            ChatUtil.printDebug("Failed to set null plot!");
            return;
        }
        for (Point p : plot.getPoints()) {
            this.plots.put(p, plot);
        }
    }

    public void removePlot(KonPlot plot) {
        if (plot == null) {
            ChatUtil.printDebug("Failed to remove null plot!");
            return;
        }
        for (Point p : plot.getPoints()) {
            this.plots.remove(p);
        }
    }

    @Override
    public boolean hasPlot(Location loc) {
        return this.hasPlot(HelperUtil.toPoint(loc), loc.getWorld());
    }

    public boolean hasPlot(Point p, World w) {
        boolean result = false;
        if (this.getChunkList().containsKey(p) && w.equals((Object)this.getWorld())) {
            result = this.plots.containsKey(p);
        }
        return result;
    }

    @Override
    @Nullable
    public KonPlot getPlot(Location loc) {
        return this.getPlot(HelperUtil.toPoint(loc), loc.getWorld());
    }

    @Nullable
    public KonPlot getPlot(Point p, World w) {
        KonPlot result = null;
        if (this.getChunkList().containsKey(p) && w.equals((Object)this.getWorld())) {
            result = this.plots.get(p);
        }
        return result;
    }

    public List<KonPlot> getPlots() {
        ArrayList<KonPlot> result = new ArrayList<KonPlot>();
        for (KonPlot plot : this.plots.values()) {
            if (result.contains(plot)) continue;
            result.add(plot);
        }
        return result;
    }

    public void clearPlots() {
        this.plots.clear();
    }

    @Override
    public KonquestTerritoryType getTerritoryType() {
        return KonquestTerritoryType.TOWN;
    }

    public void addPurchaseOffer(UUID id, double amount) {
        if (this.getTerritoryType().equals((Object)KonquestTerritoryType.CAPITAL)) {
            return;
        }
        if (this.getKingdom().isMember(id)) {
            return;
        }
        if (amount < 1.0) {
            return;
        }
        this.purchaseOffers.put(id, amount);
    }

    public List<UUID> getPurchaseOffers() {
        return new ArrayList<UUID>(this.purchaseOffers.keySet());
    }

    public int getNumPurchaseOffers() {
        return this.purchaseOffers.size();
    }

    public boolean hasPurchaseOffers() {
        return !this.purchaseOffers.isEmpty();
    }

    public double getPurchaseOfferAmount(UUID id) {
        if (this.purchaseOffers.containsKey(id)) {
            return this.purchaseOffers.get(id);
        }
        return -1.0;
    }

    public void removePurchaseOffer(UUID id) {
        this.purchaseOffers.remove(id);
    }

    public void clearPurchaseOffers() {
        this.purchaseOffers.clear();
    }
}

