/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.nms;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.github.rumsfield.konquest.nms.VersionHandler;
import com.github.rumsfield.konquest.utility.ChatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.scoreboard.Team;

public class Handler_1_18_R1
implements VersionHandler {
    @Override
    public void applyTradeDiscount(double discountPercent, boolean isStack, MerchantInventory merchantInventory) {
        Merchant tradeHost = merchantInventory.getMerchant();
        ArrayList<MerchantRecipe> tradeListDiscounted = new ArrayList<MerchantRecipe>();
        for (MerchantRecipe trade : tradeHost.getRecipes()) {
            List ingredientList = trade.getIngredients();
            if (!ingredientList.isEmpty()) {
                int amount = ((ItemStack)ingredientList.get(0)).getAmount();
                int discount = (int)((double)amount * discountPercent * -1.0);
                if (isStack) {
                    discount += trade.getSpecialPrice();
                }
                trade.setSpecialPrice(discount);
                ChatUtil.printDebug("  Applied 1.18.x special price " + discount);
            }
            tradeListDiscounted.add(trade);
        }
        tradeHost.setRecipes(tradeListDiscounted);
    }

    @Override
    public boolean sendPlayerTeamPacket(Player player, List<String> teamNames, Team team) {
        boolean fieldNameSuccess = false;
        boolean fieldModeSuccess = false;
        boolean fieldPlayersSuccess = false;
        try {
            PacketContainer teamPacket = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
            teamPacket.getStrings().write(0, (Object)team.getName());
            fieldNameSuccess = true;
            teamPacket.getIntegers().write(0, (Object)3);
            fieldModeSuccess = true;
            teamPacket.getSpecificModifier(Collection.class).write(0, teamNames);
            fieldPlayersSuccess = true;
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, teamPacket);
            return true;
        }
        catch (Exception e) {
            ChatUtil.printDebug("Failed to create team packet for player " + player.getName() + ", field status is " + fieldNameSuccess + "," + fieldModeSuccess + "," + fieldPlayersSuccess + ": " + e.getMessage());
            return false;
        }
    }
}

