/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.shop;

import com.Acrobot.ChestShop.ChestShop;
import com.ghostchu.quickshop.api.QuickShopAPI;
import com.ghostchu.quickshop.api.shop.Shop;
import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.api.model.KonquestTerritoryType;
import com.github.rumsfield.konquest.model.KonCamp;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.model.KonPropertyFlag;
import com.github.rumsfield.konquest.model.KonPropertyFlagHolder;
import com.github.rumsfield.konquest.model.KonSanctuary;
import com.github.rumsfield.konquest.model.KonTerritory;
import com.github.rumsfield.konquest.model.KonTown;
import com.github.rumsfield.konquest.shop.ChestShopFinder;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.MessagePath;
import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ShopHandler {
    private final Konquest konquest;

    public ShopHandler(Konquest konquest) {
        this.konquest = konquest;
    }

    private void notifyAdminBypass(Player player) {
        if (player.hasPermission("konquest.admin.bypass")) {
            ChatUtil.sendNotice((CommandSender)player, MessagePath.PROTECTION_NOTICE_IGNORE.getMessage(new Object[0]));
        }
    }

    public void deleteShopsInPoints(Collection<Point> points, World world) {
        ChestShop chestshop;
        QuickShopAPI quickshop;
        if (points.isEmpty() || world == null) {
            return;
        }
        if (this.konquest.getIntegrationManager().getQuickShop().isEnabled() && (quickshop = this.konquest.getIntegrationManager().getQuickShop().getAPI()) != null) {
            HashMap<String, Integer> removedShops = new HashMap<String, Integer>();
            for (Point point : points) {
                int chunkX = point.x;
                int chunkZ = point.y;
                Map shopList = quickshop.getShopManager().getShops(world.getName(), chunkX, chunkZ);
                if (shopList == null) continue;
                for (Map.Entry entry : shopList.entrySet()) {
                    UUID ownerID = ((Shop)entry.getValue()).getOwner().getUniqueId();
                    assert (ownerID != null);
                    OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)ownerID);
                    quickshop.getShopManager().deleteShop((Shop)entry.getValue());
                    String ownerName = owner.getName();
                    if (removedShops.containsKey(ownerName)) {
                        int previousNum = (Integer)removedShops.get(ownerName);
                        removedShops.put(ownerName, previousNum + 1);
                        continue;
                    }
                    removedShops.put(ownerName, 1);
                }
            }
            for (String name : removedShops.keySet()) {
                ChatUtil.printDebug("Deleted " + String.valueOf(removedShops.get(name)) + " QuickShop chest(s) owned by " + name);
            }
        }
        if (this.konquest.getIntegrationManager().getChestShop().isEnabled() && (chestshop = this.konquest.getIntegrationManager().getChestShop().getAPI()) != null) {
            int totalRemovedShops = 0;
            for (Point point : points) {
                List<Sign> signShops = ChestShopFinder.findShopSigns(world, point.x, point.y);
                totalRemovedShops += signShops.size();
                for (Sign shop : signShops) {
                    shop.getBlock().breakNaturally();
                }
            }
            ChatUtil.printDebug("Deleted " + totalRemovedShops + " ChestShop chest(s)");
        }
    }

    public boolean onShopUse(Location shopLoc, Player bukkitPlayer) {
        KonPropertyFlagHolder holder;
        if (this.konquest.isWorldIgnored(shopLoc)) {
            return true;
        }
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
        if (player == null) {
            return true;
        }
        boolean isShopClaimed = this.konquest.getTerritoryManager().isChunkClaimed(shopLoc);
        if (!isShopClaimed) {
            return true;
        }
        KonTerritory territory = this.konquest.getTerritoryManager().getChunkTerritory(shopLoc);
        assert (territory != null);
        boolean isRelationAllowed = this.konquest.getKingdomManager().isPlayerFriendly(player, territory.getKingdom()) || this.konquest.getKingdomManager().isPlayerTrade(player, territory.getKingdom()) || this.konquest.getKingdomManager().isPlayerAlly(player, territory.getKingdom()) || territory.getTerritoryType().equals((Object)KonquestTerritoryType.SANCTUARY);
        boolean isPropertyAllowed = true;
        if (territory instanceof KonPropertyFlagHolder && (holder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.SHOP)) {
            isPropertyAllowed = holder.getPropertyValue(KonPropertyFlag.SHOP);
        }
        if (!player.isAdminBypassActive() && !isRelationAllowed) {
            this.notifyAdminBypass(bukkitPlayer);
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.SHOP_ERROR_USE_RELATION.getMessage(new Object[0]));
            return false;
        }
        if (!player.isAdminBypassActive() && !isPropertyAllowed) {
            this.notifyAdminBypass(bukkitPlayer);
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.SHOP_ERROR_USE_DISABLED.getMessage(new Object[0]));
            return false;
        }
        return true;
    }

    public boolean onShopCreate(Location shopLoc, Player bukkitPlayer) {
        KonTown town;
        KonPropertyFlagHolder holder;
        if (this.konquest.isWorldIgnored(shopLoc)) {
            return true;
        }
        KonPlayer player = this.konquest.getPlayerManager().getPlayer(bukkitPlayer);
        if (player == null) {
            return true;
        }
        boolean isShopClaimed = this.konquest.getTerritoryManager().isChunkClaimed(shopLoc);
        if (!isShopClaimed) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.SHOP_ERROR_CREATE_WILD.getMessage(new Object[0]));
            return false;
        }
        KonTerritory territory = this.konquest.getTerritoryManager().getChunkTerritory(shopLoc);
        assert (territory != null);
        boolean isPropertyAllowed = true;
        if (territory instanceof KonPropertyFlagHolder && (holder = (KonPropertyFlagHolder)((Object)territory)).hasPropertyValue(KonPropertyFlag.SHOP)) {
            isPropertyAllowed = holder.getPropertyValue(KonPropertyFlag.SHOP);
        }
        if (territory instanceof KonSanctuary) {
            KonSanctuary sanctuary = (KonSanctuary)territory;
            if (sanctuary.isLocInsideTemplate(shopLoc)) {
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.SHOP_ERROR_CREATE_MONUMENT.getMessage(new Object[0]));
                return false;
            }
        } else if (territory instanceof KonTown && (town = (KonTown)territory).isLocInsideMonumentProtectionArea(shopLoc)) {
            ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.SHOP_ERROR_CREATE_MONUMENT.getMessage(new Object[0]));
            return false;
        }
        if (!player.isAdminBypassActive()) {
            if (!isPropertyAllowed) {
                this.notifyAdminBypass(bukkitPlayer);
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.SHOP_ERROR_CREATE_FAIL.getMessage(new Object[0]));
                return false;
            }
            if (territory instanceof KonTown) {
                town = (KonTown)territory;
                if (!this.konquest.getKingdomManager().isPlayerFriendly(player, town.getKingdom())) {
                    this.notifyAdminBypass(bukkitPlayer);
                    ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.SHOP_ERROR_CREATE_TOWN.getMessage(new Object[0]));
                    return false;
                }
            } else if (territory instanceof KonCamp && !((KonCamp)territory).isPlayerOwner((OfflinePlayer)bukkitPlayer)) {
                this.notifyAdminBypass(bukkitPlayer);
                ChatUtil.sendError((CommandSender)bukkitPlayer, MessagePath.SHOP_ERROR_CREATE_CAMP.getMessage(new Object[0]));
                return false;
            }
        }
        return true;
    }
}

