/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.utility;

import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Beacon;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Snow;
import org.bukkit.potion.PotionEffect;

public class BlockPaster {
    private final Chunk pasteChunk;
    private final World templateWorld;
    private int y;
    private final int y_offset;
    private final int bottomBlockY;
    private final int topBlockX;
    private final int topBlockZ;
    private final int bottomBlockX;
    private final int bottomBlockZ;

    public BlockPaster(Chunk pasteChunk, World templateWorld, int y, int y_offset, int bottomBlockY, int topBlockX, int topBlockZ, int bottomBlockX, int bottomBlockZ) {
        this.pasteChunk = pasteChunk;
        this.templateWorld = templateWorld;
        this.y = y;
        this.y_offset = y_offset;
        this.bottomBlockY = bottomBlockY;
        this.topBlockX = topBlockX;
        this.topBlockZ = topBlockZ;
        this.bottomBlockX = bottomBlockX;
        this.bottomBlockZ = bottomBlockZ;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void startPaste() {
        for (int x = this.bottomBlockX; x <= this.topBlockX; ++x) {
            for (int z = this.bottomBlockZ; z <= this.topBlockZ; ++z) {
                Block templateBlock = this.templateWorld.getBlockAt(x, this.y, z);
                Block monumentBlock = this.pasteChunk.getBlock(x - this.bottomBlockX, this.y - this.bottomBlockY + this.y_offset, z - this.bottomBlockZ);
                if (!monumentBlock.getBlockData().matches(templateBlock.getBlockData())) {
                    if (templateBlock.getBlockData() instanceof Bisected) {
                        monumentBlock.setType(templateBlock.getType(), false);
                    } else {
                        monumentBlock.setType(templateBlock.getType());
                    }
                    monumentBlock.setBlockData(templateBlock.getBlockData().clone());
                    BlockState templateState = templateBlock.getState();
                    BlockState monumentState = monumentBlock.getState();
                    if (templateState instanceof Sign && monumentState instanceof Sign) {
                        Sign templateStateSign = (Sign)templateState;
                        Sign monumentStateSign = (Sign)monumentState;
                        monumentStateSign.setEditable(templateStateSign.isEditable());
                        monumentStateSign.setGlowingText(templateStateSign.isGlowingText());
                        monumentStateSign.setColor(templateStateSign.getColor());
                        String[] lines = templateStateSign.getLines();
                        for (int i = 0; i < lines.length; ++i) {
                            try {
                                monumentStateSign.setLine(i, lines[i]);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    } else if (templateState instanceof Beacon && monumentState instanceof Beacon) {
                        PotionEffect secondaryEffect;
                        Beacon templateStateBeacon = (Beacon)templateState;
                        Beacon monumentStateBeacon = (Beacon)monumentState;
                        PotionEffect primaryEffect = templateStateBeacon.getPrimaryEffect();
                        if (primaryEffect != null) {
                            monumentStateBeacon.setPrimaryEffect(primaryEffect.getType());
                        }
                        if ((secondaryEffect = templateStateBeacon.getSecondaryEffect()) != null) {
                            monumentStateBeacon.setSecondaryEffect(secondaryEffect.getType());
                        }
                    } else if (templateState instanceof Banner && monumentState instanceof Banner) {
                        Banner templateStateBanner = (Banner)templateState;
                        Banner monumentStateBanner = (Banner)monumentState;
                        monumentStateBanner.setBaseColor(templateStateBanner.getBaseColor());
                        monumentStateBanner.setPatterns(templateStateBanner.getPatterns());
                    }
                    monumentState.update(true, false);
                }
                if (!(monumentBlock.getBlockData() instanceof Snow)) continue;
                monumentBlock.setType(Material.AIR);
            }
        }
    }
}

