/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.utility;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.model.KonPlayer;
import com.github.rumsfield.konquest.utility.ColorRGB;
import com.github.rumsfield.konquest.utility.CorePath;
import com.github.rumsfield.konquest.utility.MessagePath;
import com.github.rumsfield.konquest.utility.Timer;
import java.math.BigInteger;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.boss.BarColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatUtil {
    private static final ChatColor adminBroadcastColor = ChatColor.GOLD;
    private static final ChatColor broadcastColor = ChatColor.LIGHT_PURPLE;
    private static final ChatColor noticeColor = ChatColor.GRAY;
    private static final ChatColor errorColor = ChatColor.RED;
    private static final ChatColor alertColor = ChatColor.GOLD;

    public static String parseHex(String message) {
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String hexCode = message.substring(matcher.start(), matcher.end());
            String replaceSharp = hexCode.replace('#', 'x');
            char[] ch = replaceSharp.toCharArray();
            StringBuilder builder = new StringBuilder();
            for (char c : ch) {
                builder.append("&").append(c);
            }
            message = message.replace(hexCode, builder.toString());
            matcher = pattern.matcher(message);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static ChatColor parseColorCode(String input) {
        ChatColor result = null;
        try {
            result = ChatColor.valueOf((String)input);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String parseFormat(String base, String prefix, String suffix, String kingdom, String rank, String title, String name, String primaryColor, String secondaryColor, String kingdomWebColor) {
        String message = base;
        message = prefix.isEmpty() ? message.replaceAll("%PREFIX%\\s*", "") : message.replace("%PREFIX%", prefix);
        message = suffix.isEmpty() ? message.replaceAll("%SUFFIX%\\s*", "") : message.replace("%SUFFIX%", suffix);
        message = kingdom.isEmpty() ? message.replaceAll("%KINGDOM%\\s*", "") : message.replace("%KINGDOM%", kingdom);
        message = rank.isEmpty() ? message.replaceAll("%RANK%\\s*", "") : message.replace("%RANK%", rank);
        message = title.isEmpty() ? message.replaceAll("%TITLE%\\s*", "") : message.replace("%TITLE%", title);
        message = name.isEmpty() ? message.replaceAll("%NAME%\\s*", "") : message.replace("%NAME%", name);
        message = message.replace("%C1%", primaryColor);
        message = message.replace("%C2%", secondaryColor);
        message = message.replace("%CW%", kingdomWebColor);
        return message;
    }

    public static Color lookupColor(ChatColor reference) {
        Color result = Color.WHITE;
        switch (reference) {
            case BLACK: {
                result = Color.fromRGB((int)0);
                break;
            }
            case DARK_BLUE: {
                result = Color.fromRGB((int)170);
                break;
            }
            case DARK_GREEN: {
                result = Color.fromRGB((int)43520);
                break;
            }
            case DARK_AQUA: {
                result = Color.fromRGB((int)43690);
                break;
            }
            case DARK_RED: {
                result = Color.fromRGB((int)0xAA0000);
                break;
            }
            case DARK_PURPLE: {
                result = Color.fromRGB((int)0xAA00AA);
                break;
            }
            case GOLD: {
                result = Color.fromRGB((int)0xFFAA00);
                break;
            }
            case GRAY: {
                result = Color.fromRGB((int)0xAAAAAA);
                break;
            }
            case DARK_GRAY: {
                result = Color.fromRGB((int)0x555555);
                break;
            }
            case BLUE: {
                result = Color.fromRGB((int)0x5555FF);
                break;
            }
            case GREEN: {
                result = Color.fromRGB((int)0x55FF55);
                break;
            }
            case AQUA: {
                result = Color.fromRGB((int)0x55FFFF);
                break;
            }
            case RED: {
                result = Color.fromRGB((int)0xFF5555);
                break;
            }
            case LIGHT_PURPLE: {
                result = Color.fromRGB((int)0xFF55FF);
                break;
            }
            case YELLOW: {
                result = Color.fromRGB((int)0xFFFF55);
                break;
            }
            case WHITE: {
                result = Color.fromRGB((int)0xFFFFFF);
                break;
            }
        }
        return result;
    }

    public static Color lookupColor(String reference) {
        return ChatUtil.lookupColor(ChatUtil.lookupChatColor(reference));
    }

    public static BarColor mapBarColor(ChatColor reference) {
        BarColor result = BarColor.WHITE;
        switch (reference) {
            case GOLD: 
            case YELLOW: {
                result = BarColor.YELLOW;
                break;
            }
            case DARK_RED: 
            case RED: {
                result = BarColor.RED;
                break;
            }
            case DARK_BLUE: 
            case DARK_AQUA: 
            case BLUE: 
            case AQUA: {
                result = BarColor.BLUE;
                break;
            }
            case DARK_GREEN: 
            case GREEN: {
                result = BarColor.GREEN;
                break;
            }
            case BLACK: 
            case DARK_PURPLE: {
                result = BarColor.PURPLE;
                break;
            }
            case LIGHT_PURPLE: {
                result = BarColor.PINK;
                break;
            }
        }
        return result;
    }

    public static BarColor mapBarColor(String reference) {
        return ChatUtil.mapBarColor(ChatUtil.lookupChatColor(reference));
    }

    public static ChatColor lookupChatColor(String colorStr) {
        ChatColor result = ChatColor.getByChar((char)colorStr.charAt(colorStr.length() - 1));
        if (result == null) {
            String hexVal = String.format("%040x", new BigInteger(1, colorStr.getBytes()));
            ChatUtil.printDebug("Failed to lookup ChatColor \"" + hexVal + "\"");
            return ChatColor.RESET;
        }
        return result;
    }

    public static int lookupColorRGB(String colorStr) {
        ColorRGB namedColor = ColorRGB.fromName(colorStr);
        if (namedColor != null) {
            return namedColor.getColor().asRGB();
        }
        if (colorStr.matches("#[a-fA-F0-9]{6}")) {
            try {
                return Integer.decode(colorStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static String reverseLookupColorRGB(int hexVal) {
        ColorRGB hexColor = ColorRGB.fromColor(Color.fromRGB((int)hexVal));
        if (hexColor != null) {
            return hexColor.getName();
        }
        return "#" + Integer.toHexString(hexVal);
    }

    public static String boolean2enable(boolean val) {
        return val ? String.valueOf(ChatColor.DARK_GREEN) + "Enabled" : String.valueOf(ChatColor.DARK_RED) + "Disabled";
    }

    public static String boolean2status(boolean val) {
        return val ? String.valueOf(ChatColor.DARK_GREEN) + "Success" : String.valueOf(ChatColor.DARK_RED) + "Fail";
    }

    public static void printDebug(String message) {
        ChatUtil.printDebug(message, false);
    }

    public static void printDebug(String message, boolean showStack) {
        if (Konquest.getInstance().getCore().getBoolean(CorePath.DEBUG.getPath())) {
            Bukkit.getServer().getConsoleSender().sendMessage("[Konquest DEBUG] " + message);
            if (showStack) {
                ChatUtil.showStackTrace();
            }
        }
    }

    public static void printConsole(String message) {
        Bukkit.getServer().getConsoleSender().sendMessage("[Konquest] " + message);
    }

    public static void printConsoleAlert(String message) {
        Bukkit.getServer().getConsoleSender().sendMessage(String.valueOf(alertColor) + "[Konquest] " + message);
    }

    public static void printConsoleError(String message) {
        Bukkit.getLogger().severe("[Konquest] " + message);
    }

    public static void printConsoleWarning(String message) {
        Bukkit.getLogger().warning("[Konquest] " + message);
    }

    public static void sendNotice(KonPlayer player, String message) {
        ChatUtil.sendNotice((CommandSender)player.getBukkitPlayer(), message);
    }

    public static void sendNotice(CommandSender sender, String message) {
        ChatUtil.sendNotice(sender, message, noticeColor);
    }

    public static void sendNotice(CommandSender sender, String message, ChatColor color) {
        String notice = Konquest.getChatTag() + String.valueOf(color) + message;
        sender.sendMessage(notice);
    }

    public static void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(message);
    }

    public static void sendMessage(CommandSender sender, String message, ChatColor color) {
        String notice = String.valueOf(color) + message;
        sender.sendMessage(notice);
    }

    public static void sendError(KonPlayer player, String message) {
        ChatUtil.sendError((CommandSender)player.getBukkitPlayer(), message);
    }

    public static void sendError(CommandSender sender, String message) {
        String error = Konquest.getChatTag() + String.valueOf(errorColor) + message;
        sender.sendMessage(error);
    }

    public static void sendBroadcast(String message) {
        String notice = Konquest.getChatTag() + String.valueOf(broadcastColor) + message;
        Bukkit.broadcastMessage((String)notice);
    }

    public static void sendAdminBroadcast(String message) {
        String notice = Konquest.getChatTag() + String.valueOf(adminBroadcastColor) + message;
        Bukkit.broadcast((String)notice, (String)"konquest.command.admin.*");
    }

    public static void sendCommaMessage(CommandSender sender, List<String> values) {
        ChatUtil.sendCommaMessage(sender, values, noticeColor);
    }

    public static void sendCommaMessage(CommandSender sender, List<String> values, ChatColor color) {
        StringBuilder message = new StringBuilder();
        ListIterator<String> listIter = values.listIterator();
        while (listIter.hasNext()) {
            String currentValue = listIter.next();
            message.append(currentValue);
            if (!listIter.hasNext()) continue;
            message.append(", ");
        }
        String notice = String.valueOf(color) + String.valueOf(message);
        sender.sendMessage(notice);
    }

    public static void sendKonTitle(KonPlayer player, String title, String subtitle) {
        if (title.isEmpty()) {
            title = " ";
        }
        if (!player.isAdminBypassActive() && !player.isPriorityTitleDisplay()) {
            player.getBukkitPlayer().sendTitle(title, subtitle, 10, 40, 10);
        }
    }

    public static void sendKonTitle(KonPlayer player, String title, String subtitle, int duration) {
        if (title.isEmpty()) {
            title = " ";
        }
        if (!player.isAdminBypassActive() && !player.isPriorityTitleDisplay()) {
            player.getBukkitPlayer().sendTitle(title, subtitle, 10, duration, 10);
        }
    }

    public static void sendKonPriorityTitle(KonPlayer player, String title, String subtitle, int durationTicks, int fadeInTicks, int fadeOutTicks) {
        if (title.isEmpty()) {
            title = " ";
        }
        if (!player.isAdminBypassActive() && !player.isPriorityTitleDisplay()) {
            int totalDuration = (durationTicks + fadeInTicks + fadeOutTicks) / 20;
            if (totalDuration < 1) {
                totalDuration = 1;
            }
            player.setIsPriorityTitleDisplay(true);
            Timer priorityTitleDisplayTimer = player.getPriorityTitleDisplayTimer();
            priorityTitleDisplayTimer.stopTimer();
            priorityTitleDisplayTimer.setTime(totalDuration);
            priorityTitleDisplayTimer.startTimer();
            player.getBukkitPlayer().sendTitle(title, subtitle, fadeInTicks, durationTicks, fadeOutTicks);
        }
    }

    public static void sendConstantTitle(Player player, String title, String subtitle) {
        if (title.isEmpty()) {
            title = " ";
        }
        player.sendTitle(title, subtitle, 1, 9999999, 1);
    }

    public static void resetTitle(Player player) {
        player.resetTitle();
        player.sendTitle("", "", 1, 1, 1);
    }

    public static void sendKonBlockedProtectionTitle(KonPlayer player) {
        ChatUtil.printDebug("Blocked Protection by player " + player.getBukkitPlayer().getName(), true);
        ChatUtil.sendKonPriorityTitle(player, "", String.valueOf(Konquest.blockedProtectionColor) + MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]), 1, 10, 10);
    }

    public static void sendKonBlockedFlagTitle(KonPlayer player) {
        ChatUtil.printDebug("Blocked Flag by player " + player.getBukkitPlayer().getName(), true);
        ChatUtil.sendKonPriorityTitle(player, "", String.valueOf(Konquest.blockedFlagColor) + MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]), 1, 10, 10);
    }

    public static void sendKonBlockedShieldTitle(KonPlayer player) {
        ChatUtil.printDebug("Blocked Shield by player " + player.getBukkitPlayer().getName(), true);
        ChatUtil.sendKonPriorityTitle(player, "", String.valueOf(Konquest.blockedShieldColor) + MessagePath.PROTECTION_ERROR_BLOCKED.getMessage(new Object[0]), 1, 10, 10);
    }

    public static void showStackTrace() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            String traceStr = element.toString();
            if (!traceStr.contains("Konquest")) continue;
            Bukkit.getServer().getConsoleSender().sendMessage(element.toString());
        }
    }
}

