/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.utility;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.Version;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CompatibilityUtil {
    private static final HashMap<Villager.Profession, Material> professionMaterial = new HashMap();
    private static final HashMap<String, String> potionTypeAlternates;
    public static Version apiVersion;

    public static boolean runBIT() {
        boolean pass = true;
        int errorCode = 0;
        for (Enchantment enchant : Enchantment.values()) {
            Object enchantComp;
            String apiName = enchant.getName();
            if (EnchantComp.getFromName(apiName) == null || (enchantComp = CompatibilityUtil.getEnchantment(apiName)) != null) continue;
            pass = false;
            errorCode |= 1;
        }
        PotionEffectType type = CompatibilityUtil.getMiningFatigue();
        if (type == null) {
            pass = false;
            errorCode |= 2;
        }
        Particle dust = CompatibilityUtil.getParticle("dust");
        Particle spell = CompatibilityUtil.getParticle("spell");
        if (dust.equals((Object)Particle.FLAME) || spell.equals((Object)Particle.FLAME)) {
            pass = false;
            errorCode |= 4;
        }
        EntityType item = CompatibilityUtil.getEntityType("item");
        EntityType potion = CompatibilityUtil.getEntityType("potion");
        if (item.equals((Object)EntityType.EGG) || potion.equals((Object)EntityType.EGG)) {
            pass = false;
            errorCode |= 8;
        }
        for (Villager.Profession profession : CompatibilityUtil.getProfessions()) {
            Material professionMaterial = CompatibilityUtil.getProfessionMaterial(profession);
            if (!professionMaterial.equals((Object)Material.EMERALD)) continue;
            pass = false;
            errorCode |= 0x10;
        }
        Attribute maxHealth = CompatibilityUtil.getAttribute("health");
        Attribute movementSpeed = CompatibilityUtil.getAttribute("speed");
        Attribute attackDamage = CompatibilityUtil.getAttribute("damage");
        if (maxHealth == null || movementSpeed == null || attackDamage == null) {
            pass = false;
            errorCode |= 0x20;
        }
        if (pass) {
            ChatUtil.printConsoleAlert("Successfully validated API compatibility");
        } else {
            ChatUtil.printConsoleError("Failed to validate some API compatibilities, report this as a bug to the plugin author! Error " + errorCode);
        }
        return pass;
    }

    private static Version getApiVersion() {
        Version bukkitVersion;
        String versionNum;
        String bukkitVersionName = Bukkit.getServer().getBukkitVersion();
        try {
            versionNum = bukkitVersionName.split("-")[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ChatUtil.printConsoleError("Failed to determine server version: " + bukkitVersionName);
            return null;
        }
        try {
            bukkitVersion = new Version(versionNum);
        }
        catch (IllegalArgumentException ex) {
            ChatUtil.printConsoleError("Failed to resolve valid API version: " + bukkitVersionName + ", " + versionNum);
            ChatUtil.printConsoleError(ex.getMessage());
            return null;
        }
        return bukkitVersion;
    }

    private static PotionType lookupPotionType(PotionType type, boolean isExtended, boolean isUpgraded) {
        switch (type.toString()) {
            case "FIRE_RESISTANCE": {
                if (!isExtended) break;
                return PotionType.LONG_FIRE_RESISTANCE;
            }
            case "INVISIBILITY": {
                if (!isExtended) break;
                return PotionType.LONG_INVISIBILITY;
            }
            case "LEAPING": 
            case "JUMP": {
                if (isExtended) {
                    return PotionType.LONG_LEAPING;
                }
                if (!isUpgraded) break;
                return PotionType.STRONG_LEAPING;
            }
            case "NIGHT_VISION": {
                if (!isExtended) break;
                return PotionType.LONG_NIGHT_VISION;
            }
            case "POISON": {
                if (isExtended) {
                    return PotionType.LONG_POISON;
                }
                if (!isUpgraded) break;
                return PotionType.STRONG_POISON;
            }
            case "REGENERATION": 
            case "REGEN": {
                if (isExtended) {
                    return PotionType.LONG_REGENERATION;
                }
                if (!isUpgraded) break;
                return PotionType.STRONG_REGENERATION;
            }
            case "SLOW_FALLING": {
                if (!isExtended) break;
                return PotionType.LONG_SLOW_FALLING;
            }
            case "SLOWNESS": 
            case "SPEED": {
                if (isExtended) {
                    return PotionType.LONG_SLOWNESS;
                }
                if (!isUpgraded) break;
                return PotionType.STRONG_SLOWNESS;
            }
            case "STRENGTH": {
                if (isExtended) {
                    return PotionType.LONG_STRENGTH;
                }
                if (!isUpgraded) break;
                return PotionType.STRONG_STRENGTH;
            }
            case "SWIFTNESS": {
                if (isExtended) {
                    return PotionType.LONG_SWIFTNESS;
                }
                if (!isUpgraded) break;
                return PotionType.STRONG_SWIFTNESS;
            }
            case "TURTLE_MASTER": {
                if (isExtended) {
                    return PotionType.LONG_TURTLE_MASTER;
                }
                if (!isUpgraded) break;
                return PotionType.STRONG_TURTLE_MASTER;
            }
            case "WATER_BREATHING": {
                if (!isExtended) break;
                return PotionType.LONG_WATER_BREATHING;
            }
            case "WEAKNESS": {
                if (!isExtended) break;
                return PotionType.LONG_WEAKNESS;
            }
            case "HARMING": 
            case "INSTANT_DAMAGE": {
                if (!isUpgraded) break;
                return PotionType.STRONG_HARMING;
            }
            case "HEALING": 
            case "INSTANT_HEAL": {
                if (!isUpgraded) break;
                return PotionType.STRONG_HEALING;
            }
        }
        return type;
    }

    public static PotionEffectType getMiningFatigue() {
        PotionEffectType result;
        block6: {
            try {
                try {
                    result = (PotionEffectType)Registry.EFFECT.get(NamespacedKey.minecraft((String)"mining_fatigue"));
                }
                catch (IllegalArgumentException exception) {
                    result = null;
                }
                if (result != null) break block6;
                ChatUtil.printConsoleError("Failed to get Mining Fatigue PotionEffectType using Registry for Bukkit version " + Bukkit.getVersion());
                ChatUtil.printConsole("Valid NamespacedKeys for Potion Effects are:");
                for (PotionEffectType effect : Registry.EFFECT) {
                    ChatUtil.printConsole(effect.getKey().toString());
                }
            }
            catch (NoSuchFieldError ignored) {
                ChatUtil.printDebug("Could not use Registry to get Mining Fatigue effect, trying name lookup...");
                result = PotionEffectType.getByName((String)"SLOW_DIGGING");
                if (result != null) break block6;
                ChatUtil.printConsoleError("Failed to get Mining Fatigue PotionEffectType using getByName for Bukkit version " + Bukkit.getVersion());
                ChatUtil.printConsole("Valid Names for Potion Effects are:");
                for (PotionEffectType effect : PotionEffectType.values()) {
                    ChatUtil.printConsole(effect.getName());
                }
            }
        }
        return result;
    }

    public static Attribute getAttribute(String name) {
        Attribute result;
        AttributeComp key = AttributeComp.MAX_HEALTH;
        switch (name.toLowerCase()) {
            case "health": {
                key = AttributeComp.MAX_HEALTH;
                break;
            }
            case "speed": {
                key = AttributeComp.MOVEMENT_SPEED;
                break;
            }
            case "damage": {
                key = AttributeComp.ATTACK_DAMAGE;
                break;
            }
        }
        String tryKey1 = "";
        String tryKey2 = "";
        try {
            NamespacedKey firstKey = NamespacedKey.minecraft((String)key.namespace1);
            tryKey1 = firstKey.toString();
            result = (Attribute)Registry.ATTRIBUTE.get(firstKey);
        }
        catch (IllegalArgumentException ignore1) {
            result = null;
        }
        if (result == null) {
            try {
                NamespacedKey secondKey = NamespacedKey.minecraft((String)key.namespace2);
                tryKey2 = secondKey.toString();
                result = (Attribute)Registry.ATTRIBUTE.get(secondKey);
            }
            catch (IllegalArgumentException ignore2) {
                result = null;
            }
        }
        if (result == null) {
            ChatUtil.printConsoleError("Failed to get Attribute using Registry key \"" + String.valueOf((Object)key) + "\" for Bukkit version " + Bukkit.getVersion());
            ChatUtil.printConsole("Tried these namespace keys: \"" + tryKey1 + "\", \"" + tryKey2 + "\"");
            ChatUtil.printConsole("Valid NamespacedKeys for Attributes are:");
            try {
                for (Object attribute : Registry.ATTRIBUTE) {
                    Method getKey = attribute.getClass().getMethod("getKey", new Class[0]);
                    getKey.setAccessible(true);
                    NamespacedKey attributeNamespacedKey = (NamespacedKey)getKey.invoke(attribute, new Object[0]);
                    ChatUtil.printConsole(attributeNamespacedKey.toString());
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Enchantment getEnchantment(String name) {
        Enchantment result;
        String enchantNamespace;
        EnchantComp enchant = EnchantComp.getFromName(name);
        if (enchant == null) {
            ChatUtil.printConsoleError("Failed to find enchantment from name, \"" + name + "\", make sure the name matches a known enchantment from the Spigot API.");
            return null;
        }
        if (apiVersion.compareTo(new Version("1.18.2")) <= 0) {
            enchantNamespace = enchant.namespace1;
            if (enchantNamespace.isEmpty()) {
                ChatUtil.printConsoleError("Failed to match enchantment \"" + name + "\" to versions 1.16.5 - 1.18.2. Enchantment does not exist.");
                return null;
            }
        } else if (apiVersion.compareTo(new Version("1.20.4")) <= 0) {
            enchantNamespace = enchant.namespace2;
            if (enchantNamespace.isEmpty()) {
                ChatUtil.printConsoleError("Failed to match enchantment \"" + name + "\" to versions 1.19.4 - 1.20.4. Enchantment does not exist.");
                return null;
            }
        } else {
            enchantNamespace = enchant.namespace3;
            if (enchantNamespace.isEmpty()) {
                ChatUtil.printConsoleError("Failed to match enchantment \"" + name + "\" to versions 1.20.6 or later. Enchantment does not exist.");
                return null;
            }
        }
        try {
            result = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)enchantNamespace));
        }
        catch (IllegalArgumentException exception) {
            result = null;
        }
        if (result == null) {
            ChatUtil.printConsoleError("Failed to get Enchantment using minecraft namespace \"" + enchantNamespace + "\" for Bukkit version " + Bukkit.getVersion());
            ChatUtil.printConsole("Valid NamespacedKeys for Enchantments are:");
            for (Enchantment enchantment : Registry.ENCHANTMENT) {
                ChatUtil.printConsole(enchantment.getKey().toString());
            }
        }
        return result;
    }

    public static Particle getParticle(String type) {
        try {
            if (apiVersion.compareTo(new Version("1.20.4")) <= 0) {
                if (type.equals("dust")) {
                    return Particle.valueOf((String)"REDSTONE");
                }
                if (type.equals("spell")) {
                    return Particle.valueOf((String)"SPELL_MOB_AMBIENT");
                }
            } else {
                if (type.equals("dust")) {
                    return Particle.valueOf((String)"DUST");
                }
                if (type.equals("spell")) {
                    return Particle.valueOf((String)"ENTITY_EFFECT");
                }
            }
        }
        catch (IllegalArgumentException exception) {
            ChatUtil.printConsoleError("Failed to get Particle for Bukkit version " + Bukkit.getVersion());
        }
        return Particle.FLAME;
    }

    public static EntityType getEntityType(String type) {
        try {
            if (apiVersion.compareTo(new Version("1.20.4")) <= 0) {
                if (type.equals("item")) {
                    return EntityType.valueOf((String)"DROPPED_ITEM");
                }
                if (type.equals("potion")) {
                    return EntityType.valueOf((String)"SPLASH_POTION");
                }
            } else {
                if (type.equals("item")) {
                    return EntityType.valueOf((String)"ITEM");
                }
                if (type.equals("potion")) {
                    return EntityType.valueOf((String)"POTION");
                }
            }
        }
        catch (IllegalArgumentException exception) {
            ChatUtil.printConsoleError("Failed to get Entity Type for Bukkit version " + Bukkit.getVersion());
        }
        return EntityType.EGG;
    }

    public static PotionMeta setPotionMeta(PotionMeta meta, String potionName, boolean isExtended, boolean isUpgraded) {
        PotionType potionType;
        block12: {
            potionType = null;
            try {
                potionType = PotionType.valueOf((String)potionName);
            }
            catch (IllegalArgumentException ignored1) {
                if (!potionTypeAlternates.containsKey(potionName)) break block12;
                String alternateName = potionTypeAlternates.get(potionName);
                try {
                    potionType = PotionType.valueOf((String)alternateName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (potionType == null) {
            ChatUtil.printConsoleError("Invalid loot potion \"" + potionName + "\" given in loot.yml config file, skipping this potion. Accepted potion types are as follows.");
            for (PotionType type : PotionType.values()) {
                ChatUtil.printConsole(type.toString());
            }
            return meta;
        }
        if (isExtended && !potionType.isExtendable()) {
            ChatUtil.printConsoleWarning("Invalid loot potion \"" + potionName + "\" with extended: true. This potion cannot be extended, ignoring extended modifier.");
        }
        if (isUpgraded && !potionType.isUpgradeable()) {
            ChatUtil.printConsoleWarning("Invalid loot potion \"" + potionName + "\" with upgraded: true. This potion cannot be upgraded, ignoring upgraded modifier.");
        }
        boolean isExtendedValid = potionType.isExtendable() && isExtended;
        boolean isUpgradedValid = potionType.isUpgradeable() && isUpgraded;
        try {
            meta.setBasePotionType(CompatibilityUtil.lookupPotionType(potionType, isExtendedValid, isUpgradedValid));
        }
        catch (NoSuchFieldError | NoSuchMethodError ignored) {
            try {
                meta.setBasePotionData(new PotionData(potionType, isExtended, isUpgraded));
            }
            catch (IllegalArgumentException e) {
                meta.setBasePotionData(new PotionData(potionType, false, false));
                ChatUtil.printConsoleError("Invalid options extended=" + isExtended + ", upgraded=" + isUpgraded + " for potion " + potionType.name() + " in loot.yml");
            }
        }
        return meta;
    }

    public static void playerSpawnEffect(Player target, Location loc, Color color) {
        if (apiVersion.compareTo(new Version("1.20.4")) <= 0) {
            double red = (double)color.getRed() / 255.0;
            double green = (double)color.getGreen() / 255.0;
            double blue = (double)color.getBlue() / 255.0;
            target.spawnParticle(CompatibilityUtil.getParticle("spell"), loc, 0, red, green, blue, 1.0);
        } else {
            target.spawnParticle(CompatibilityUtil.getParticle("spell"), loc, 1, 0.0, 0.0, 0.0, (Object)color);
        }
    }

    public static ItemStack buildItem(Material mat, String name, List<String> loreList) {
        return CompatibilityUtil.buildItem(mat, name, loreList, false, null);
    }

    public static ItemStack buildItem(Material mat, String name, List<String> loreList, boolean hasProtection) {
        return CompatibilityUtil.buildItem(mat, name, loreList, hasProtection, null);
    }

    public static ItemStack buildItem(Material mat, String name, List<String> loreList, boolean hasProtection, OfflinePlayer playerHead) {
        Enchantment protectionEnchant;
        ItemStack item = playerHead == null && mat != null ? new ItemStack(mat) : (playerHead != null ? Konquest.getInstance().getPlayerHead(playerHead) : new ItemStack(Material.DIRT));
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.addAttributeModifier(CompatibilityUtil.getAttribute("damage"), new AttributeModifier("foo", 0.0, AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        for (ItemFlag flag : ItemFlag.values()) {
            if (flag.toString().equalsIgnoreCase("HIDE_LORE")) continue;
            meta.addItemFlags(new ItemFlag[]{flag});
        }
        if (hasProtection && (protectionEnchant = CompatibilityUtil.getEnchantment("protection_environmental")) != null) {
            meta.addEnchant(protectionEnchant, 1, true);
        }
        meta.setDisplayName(name);
        meta.setLore(loreList);
        item.setItemMeta(meta);
        return item;
    }

    public static void applyHealthModifier(Player player, double modAmount, String modName, NamespacedKey modKey) {
        boolean isModActive = false;
        Attribute maxHealth = CompatibilityUtil.getAttribute("health");
        if (maxHealth == null) {
            return;
        }
        AttributeInstance playerHealthAtt = player.getAttribute(maxHealth);
        assert (playerHealthAtt != null);
        for (AttributeModifier mod : playerHealthAtt.getModifiers()) {
            ChatUtil.printDebug("Checking health mod: " + mod.getName());
            if (mod.getName().matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")) {
                ChatUtil.printDebug("  Found bad mod, removing!");
                playerHealthAtt.removeModifier(mod);
                continue;
            }
            if (apiVersion.compareTo(new Version("1.20.6")) <= 0) {
                if (!mod.getName().equals(modName)) continue;
                isModActive = true;
                break;
            }
            if (!mod.getKey().equals((Object)modKey)) continue;
            isModActive = true;
            break;
        }
        double baseHealth = playerHealthAtt.getBaseValue();
        if (!isModActive) {
            AttributeModifier modification = apiVersion.compareTo(new Version("1.20.6")) <= 0 ? new AttributeModifier(modName, modAmount, AttributeModifier.Operation.ADD_NUMBER) : new AttributeModifier(modKey, modAmount, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
            playerHealthAtt.addModifier(modification);
            ChatUtil.printDebug("Applied max health attribute modifier " + modAmount + " to player " + player.getName() + " with base health " + baseHealth);
        } else {
            ChatUtil.printDebug("Skipped existing max health attribute modifier on player " + player.getName() + " with base health " + baseHealth);
        }
    }

    public static void removeHealthModifier(Player player, String modName, NamespacedKey modKey) {
        Attribute maxHealth = CompatibilityUtil.getAttribute("health");
        if (maxHealth == null) {
            return;
        }
        AttributeInstance playerHealthAtt = player.getAttribute(maxHealth);
        assert (playerHealthAtt != null);
        for (AttributeModifier mod : playerHealthAtt.getModifiers()) {
            ChatUtil.printDebug("Checking health mod: " + mod.getName());
            if (mod.getName().matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$")) {
                ChatUtil.printDebug("  Found bad mod, removing!");
                playerHealthAtt.removeModifier(mod);
                continue;
            }
            if (apiVersion.compareTo(new Version("1.20.6")) <= 0) {
                if (!mod.getName().equals(modName)) continue;
                playerHealthAtt.removeModifier(mod);
                ChatUtil.printDebug("Removed max health attribute modifier by name for player " + player.getName());
                continue;
            }
            if (!mod.getKey().equals((Object)modKey)) continue;
            playerHealthAtt.removeModifier(mod);
            ChatUtil.printDebug("Removed max health attribute modifier by namespace key for player " + player.getName());
        }
    }

    public static ArrayList<Villager.Profession> getProfessions() {
        ArrayList<Villager.Profession> result = new ArrayList<Villager.Profession>();
        try {
            for (Villager.Profession profession : Registry.VILLAGER_PROFESSION) {
                result.add(profession);
            }
        }
        catch (NoSuchFieldError ignored) {
            try {
                result.addAll(Arrays.asList(Villager.Profession.values()));
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                // empty catch block
            }
        }
        return result;
    }

    public static Material getProfessionMaterial(Villager.Profession profession) {
        if (professionMaterial.containsKey(profession)) {
            return professionMaterial.get(profession);
        }
        return Material.EMERALD;
    }

    public static Inventory getTopInventory(InventoryEvent event) {
        try {
            InventoryView view = event.getView();
            Method getTopInventory = view.getClass().getMethod("getTopInventory", new Class[0]);
            getTopInventory.setAccessible(true);
            return (Inventory)getTopInventory.invoke((Object)view, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Villager.Profession getProfessionFromName(String name) {
        try {
            for (Villager.Profession profession : CompatibilityUtil.getProfessions()) {
                Method getName = profession.getClass().getMethod("name", new Class[0]);
                getName.setAccessible(true);
                String professionName = (String)getName.invoke((Object)profession, new Object[0]);
                if (!professionName.equalsIgnoreCase(name)) continue;
                return profession;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static String getProfessionName(Villager.Profession profession) {
        try {
            Villager.Profession prof = profession;
            Method getName = prof.getClass().getMethod("name", new Class[0]);
            getName.setAccessible(true);
            return (String)getName.invoke((Object)prof, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isProfessionEqual(Villager.Profession thisProfession, Villager.Profession thatProfession) {
        try {
            Villager.Profession thisProf = thisProfession;
            Villager.Profession thatProf = thatProfession;
            Method isEqual = thisProf.getClass().getMethod("equals", Object.class);
            isEqual.setAccessible(true);
            return (Boolean)isEqual.invoke((Object)thisProf, thatProf);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        professionMaterial.put(Villager.Profession.ARMORER, Material.BLAST_FURNACE);
        professionMaterial.put(Villager.Profession.BUTCHER, Material.SMOKER);
        professionMaterial.put(Villager.Profession.CARTOGRAPHER, Material.CARTOGRAPHY_TABLE);
        professionMaterial.put(Villager.Profession.CLERIC, Material.BREWING_STAND);
        professionMaterial.put(Villager.Profession.FARMER, Material.COMPOSTER);
        professionMaterial.put(Villager.Profession.FISHERMAN, Material.BARREL);
        professionMaterial.put(Villager.Profession.FLETCHER, Material.FLETCHING_TABLE);
        professionMaterial.put(Villager.Profession.LEATHERWORKER, Material.CAULDRON);
        professionMaterial.put(Villager.Profession.LIBRARIAN, Material.LECTERN);
        professionMaterial.put(Villager.Profession.MASON, Material.STONECUTTER);
        professionMaterial.put(Villager.Profession.NITWIT, Material.PUFFERFISH_BUCKET);
        professionMaterial.put(Villager.Profession.NONE, Material.BUCKET);
        professionMaterial.put(Villager.Profession.SHEPHERD, Material.LOOM);
        professionMaterial.put(Villager.Profession.TOOLSMITH, Material.SMITHING_TABLE);
        professionMaterial.put(Villager.Profession.WEAPONSMITH, Material.GRINDSTONE);
        potionTypeAlternates = new HashMap();
        potionTypeAlternates.put("INSTANT_DAMAGE", "HARMING");
        potionTypeAlternates.put("INSTANT_HEAL", "HEALING");
        potionTypeAlternates.put("JUMP", "LEAPING");
        potionTypeAlternates.put("REGEN", "REGENERATION");
        potionTypeAlternates.put("SPEED", "SWIFTNESS");
        potionTypeAlternates.put("HARMING", "INSTANT_DAMAGE");
        potionTypeAlternates.put("HEALING", "INSTANT_HEAL");
        potionTypeAlternates.put("LEAPING", "JUMP");
        potionTypeAlternates.put("REGENERATION", "REGEN");
        potionTypeAlternates.put("SWIFTNESS", "SPEED");
        apiVersion = CompatibilityUtil.getApiVersion();
    }

    private static enum EnchantComp {
        BINDING_CURSE("binding_curse", "binding_curse", "binding_curse"),
        CHANNELING("channeling", "channeling", "channeling"),
        DEPTH_STRIDER("depth_strider", "depth_strider", "depth_strider"),
        FIRE_ASPECT("fire_aspect", "fire_aspect", "fire_aspect"),
        FROST_WALKER("frost_walker", "frost_walker", "frost_walker"),
        IMPALING("impaling", "impaling", "impaling"),
        KNOCKBACK("knockback", "knockback", "knockback"),
        LOYALTY("loyalty", "loyalty", "loyalty"),
        LURE("lure", "lure", "lure"),
        MENDING("mending", "mending", "mending"),
        MULTISHOT("multishot", "multishot", "multishot"),
        PIERCING("piercing", "piercing", "piercing"),
        QUICK_CHARGE("quick_charge", "quick_charge", "quick_charge"),
        RIPTIDE("riptide", "riptide", "riptide"),
        SILK_TOUCH("silk_touch", "silk_touch", "silk_touch"),
        SOUL_SPEED("soul_speed", "soul_speed", "soul_speed"),
        SWEEPING_EDGE("sweeping", "sweeping", "sweeping_edge"),
        THORNS("thorns", "thorns", "thorns"),
        VANISHING_CURSE("vanishing_curse", "vanishing_curse", "vanishing_curse"),
        SWIFT_SNEAK("", "swift_sneak", "swift_sneak"),
        WATER_WORKER("aqua_affinity", "aqua_affinity", "aqua_affinity"),
        DAMAGE_ARTHROPODS("bane_of_arthropods", "bane_of_arthropods", "bane_of_arthropods"),
        PROTECTION_EXPLOSIONS("blast_protection", "blast_protection", "blast_protection"),
        DIG_SPEED("efficiency", "efficiency", "efficiency"),
        PROTECTION_FALL("feather_falling", "feather_falling", "feather_falling"),
        PROTECTION_FIRE("fire_protection", "fire_protection", "fire_protection"),
        ARROW_FIRE("flame", "flame", "flame"),
        LOOT_BONUS_BLOCKS("fortune", "fortune", "fortune"),
        ARROW_INFINITE("infinity", "infinity", "infinity"),
        LOOT_BONUS_MOBS("looting", "looting", "looting"),
        LUCK("luck_of_the_sea", "luck_of_the_sea", "luck_of_the_sea"),
        ARROW_DAMAGE("power", "power", "power"),
        PROTECTION_PROJECTILE("projectile_protection", "projectile_protection", "projectile_protection"),
        PROTECTION_ENVIRONMENTAL("protection", "protection", "protection"),
        ARROW_KNOCKBACK("punch", "punch", "punch"),
        OXYGEN("respiration", "respiration", "respiration"),
        DAMAGE_ALL("sharpness", "sharpness", "sharpness"),
        DAMAGE_UNDEAD("smite", "smite", "smite"),
        DURABILITY("unbreaking", "unbreaking", "unbreaking"),
        AQUA_AFFINITY("aqua_affinity", "aqua_affinity", "aqua_affinity"),
        BANE_OF_ARTHROPODS("bane_of_arthropods", "bane_of_arthropods", "bane_of_arthropods"),
        BLAST_PROTECTION("blast_protection", "blast_protection", "blast_protection"),
        EFFICIENCY("efficiency", "efficiency", "efficiency"),
        FEATHER_FALLING("feather_falling", "feather_falling", "feather_falling"),
        FIRE_PROTECTION("fire_protection", "fire_protection", "fire_protection"),
        FLAME("flame", "flame", "flame"),
        FORTUNE("fortune", "fortune", "fortune"),
        INFINITY("infinity", "infinity", "infinity"),
        LOOTING("looting", "looting", "looting"),
        LUCK_OF_THE_SEA("luck_of_the_sea", "luck_of_the_sea", "luck_of_the_sea"),
        POWER("power", "power", "power"),
        PROJECTILE_PROTECTION("projectile_protection", "projectile_protection", "projectile_protection"),
        PROTECTION("protection", "protection", "protection"),
        PUNCH("punch", "punch", "punch"),
        RESPIRATION("respiration", "respiration", "respiration"),
        SHARPNESS("sharpness", "sharpness", "sharpness"),
        SMITE("smite", "smite", "smite"),
        UNBREAKING("unbreaking", "unbreaking", "unbreaking"),
        BREACH("", "", "breach"),
        DENSITY("", "", "density"),
        WIND_BURST("", "", "wind_burst");

        public final String namespace1;
        public final String namespace2;
        public final String namespace3;

        private EnchantComp(String namespace1, String namespace2, String namespace3) {
            this.namespace1 = namespace1;
            this.namespace2 = namespace2;
            this.namespace3 = namespace3;
        }

        public static EnchantComp getFromName(String name) {
            for (EnchantComp enchant : EnchantComp.values()) {
                if (!enchant.toString().equalsIgnoreCase(name)) continue;
                return enchant;
            }
            return null;
        }
    }

    private static enum AttributeComp {
        MAX_HEALTH("generic.max_health", "max_health"),
        MOVEMENT_SPEED("generic.movement_speed", "movement_speed"),
        ATTACK_DAMAGE("generic.attack_damage", "attack_damage");

        public final String namespace1;
        public final String namespace2;

        private AttributeComp(String namespace1, String namespace2) {
            this.namespace1 = namespace1;
            this.namespace2 = namespace2;
        }
    }
}

