/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.utility;

import java.awt.Point;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class HelperUtil {
    public static ArrayList<Chunk> getAreaChunks(Location loc, int radius) {
        ArrayList<Chunk> areaChunks = new ArrayList<Chunk>();
        if (loc.getWorld() == null) {
            return areaChunks;
        }
        areaChunks.add(loc.getChunk());
        int curX = loc.getChunk().getX();
        int curZ = loc.getChunk().getZ();
        if (radius > 0) {
            int min = (radius - 1) * -1;
            int max = radius - 1;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x == 0 && z == 0) continue;
                    areaChunks.add(loc.getWorld().getChunkAt(curX + x, curZ + z));
                }
            }
        }
        return areaChunks;
    }

    public static ArrayList<Point> getAreaPoints(Location loc, int radius) {
        ArrayList<Point> areaPoints = new ArrayList<Point>();
        Point center = HelperUtil.toPoint(loc);
        areaPoints.add(center);
        if (radius > 0) {
            int min = (radius - 1) * -1;
            int max = radius - 1;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x == 0 && z == 0) continue;
                    areaPoints.add(new Point(center.x + x, center.y + z));
                }
            }
        }
        return areaPoints;
    }

    public static ArrayList<Chunk> getSurroundingChunks(Location loc, int radius) {
        ArrayList<Chunk> areaChunks = new ArrayList<Chunk>();
        if (loc.getWorld() == null) {
            return areaChunks;
        }
        int curX = loc.getChunk().getX();
        int curZ = loc.getChunk().getZ();
        if (radius > 0) {
            int min = (radius - 1) * -1;
            int max = radius - 1;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x == 0 && z == 0) continue;
                    areaChunks.add(loc.getWorld().getChunkAt(curX + x, curZ + z));
                }
            }
        }
        return areaChunks;
    }

    public static ArrayList<Point> getBorderPoints(Location loc, int radius) {
        ArrayList<Point> areaPoints = new ArrayList<Point>();
        Point center = HelperUtil.toPoint(loc);
        if (radius > 0) {
            int min = (radius - 1) * -1;
            int max = radius - 1;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x != min && z != min && x != max && z != max) continue;
                    areaPoints.add(new Point(center.x + x, center.y + z));
                }
            }
        }
        return areaPoints;
    }

    public static ArrayList<Point> getSidePoints(Location loc) {
        ArrayList<Point> sidePoints = new ArrayList<Point>();
        Point center = HelperUtil.toPoint(loc);
        int[] coordLUTX = new int[]{0, 1, 0, -1};
        int[] coordLUTZ = new int[]{1, 0, -1, 0};
        for (int i = 0; i < 4; ++i) {
            sidePoints.add(new Point(center.x + coordLUTX[i], center.y + coordLUTZ[i]));
        }
        return sidePoints;
    }

    public static Point toPoint(Location loc) {
        return new Point((int)Math.floor((double)loc.getBlockX() / 16.0), (int)Math.floor((double)loc.getBlockZ() / 16.0));
    }

    public static Point toPoint(Chunk chunk) {
        return new Point(chunk.getX(), chunk.getZ());
    }

    public static int chunkDistance(Location loc1, Location loc2) {
        if (loc1.getWorld() == null) {
            return -1;
        }
        if (loc1.getWorld().getName().equals(loc2.getWorld().getName())) {
            int loc1X = (int)Math.floor((double)loc1.getBlockX() / 16.0);
            int loc1Z = (int)Math.floor((double)loc1.getBlockZ() / 16.0);
            int loc2X = (int)Math.floor((double)loc2.getBlockX() / 16.0);
            int loc2Z = (int)Math.floor((double)loc2.getBlockZ() / 16.0);
            return Math.max(Math.abs(loc1X - loc2X), Math.abs(loc1Z - loc2Z));
        }
        return -1;
    }

    public static String formatPointsToString(Collection<Point> points) {
        StringBuilder result = new StringBuilder();
        for (Point point : points) {
            int x = (int)point.getX();
            int y = (int)point.getY();
            result.append(x).append(",").append(y).append(".");
        }
        return result.toString();
    }

    public static ArrayList<Point> formatStringToPoints(String coords) {
        String[] coord_list;
        ArrayList<Point> points = new ArrayList<Point>();
        for (String coord : coord_list = coords.split("\\.")) {
            if (coord.equals("")) continue;
            String[] coord_pair = coord.split(",");
            int x = Integer.parseInt(coord_pair[0]);
            int z = Integer.parseInt(coord_pair[1]);
            points.add(new Point(x, z));
        }
        return points;
    }

    public static String formatLocationsToString(Collection<Location> locs) {
        StringBuilder result = new StringBuilder();
        for (Location loc : locs) {
            int x = loc.getBlockX();
            int y = loc.getBlockY();
            int z = loc.getBlockZ();
            result.append(x).append(",").append(y).append(",").append(z).append(".");
        }
        return result.toString();
    }

    public static ArrayList<Location> formatStringToLocations(String coords, World world) {
        String[] coord_list;
        ArrayList<Location> locations = new ArrayList<Location>();
        for (String coord : coord_list = coords.split("\\.")) {
            if (coord.equals("")) continue;
            String[] coord_pair = coord.split(",");
            int x = Integer.parseInt(coord_pair[0]);
            int y = Integer.parseInt(coord_pair[1]);
            int z = Integer.parseInt(coord_pair[2]);
            locations.add(new Location(world, (double)x, (double)y, (double)z));
        }
        return locations;
    }

    public static UUID idFromString(String id) {
        UUID result = null;
        try {
            result = UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<String> stringPaginate(String sentence) {
        ArrayList<String> result = new ArrayList<String>();
        String[] words = sentence.split(" ");
        StringBuilder line = new StringBuilder();
        int MAX_LINE_LENGTH = 50;
        for (int i = 0; i < words.length; ++i) {
            String test = String.valueOf(line) + words[i];
            if (i == words.length - 1) {
                if (test.length() > MAX_LINE_LENGTH) {
                    result.add(line.toString().trim());
                    result.add(words[i].trim());
                    continue;
                }
                result.add(test.trim());
                continue;
            }
            if (test.length() > MAX_LINE_LENGTH) {
                result.add(line.toString().trim());
                line = new StringBuilder(words[i] + " ");
                continue;
            }
            line.append(words[i]).append(" ");
        }
        return result;
    }

    public static List<String> stringPaginate(String sentence, String format) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> lines = HelperUtil.stringPaginate(sentence);
        for (String line : lines) {
            result.add(format + line);
        }
        return result;
    }

    public static List<String> stringPaginate(String sentence, ChatColor format) {
        String formatStr = String.valueOf(format);
        return HelperUtil.stringPaginate(sentence, formatStr);
    }

    public static String getTimeFormat(int valSeconds, ChatColor color) {
        return HelperUtil.getTimeFormat(valSeconds, String.valueOf(color));
    }

    public static String getTimeFormat(int valSeconds, String color) {
        String result;
        Object numColor;
        Object nColor;
        if (color != null && !color.isEmpty()) {
            nColor = String.valueOf(ChatColor.GRAY);
            numColor = color;
            if (valSeconds <= 30) {
                numColor = String.valueOf(ChatColor.DARK_RED);
            }
        } else {
            nColor = "";
            numColor = "";
        }
        if (valSeconds < 0) {
            return color + "\u221e";
        }
        int days = valSeconds / 86400;
        int hours = valSeconds % 86400 / 3600;
        int minutes = valSeconds % 3600 / 60;
        int seconds = valSeconds % 60;
        if (days != 0) {
            String format = (String)numColor + "%03d" + (String)nColor + "D:" + (String)numColor + "%02d" + (String)nColor + "H:" + (String)numColor + "%02d" + (String)nColor + "M:" + (String)numColor + "%02d" + (String)nColor + "S";
            result = String.format(format, days, hours, minutes, seconds);
        } else if (hours != 0) {
            String format = (String)numColor + "%02d" + (String)nColor + "H:" + (String)numColor + "%02d" + (String)nColor + "M:" + (String)numColor + "%02d" + (String)nColor + "S";
            result = String.format(format, hours, minutes, seconds);
        } else if (minutes != 0) {
            String format = (String)numColor + "%02d" + (String)nColor + "M:" + (String)numColor + "%02d" + (String)nColor + "S";
            result = String.format(format, minutes, seconds);
        } else {
            String format = (String)numColor + "%02d" + (String)nColor + "S";
            result = String.format(format, seconds);
        }
        return result;
    }

    public static String formatCommaSeparatedList(List<String> values) {
        StringBuilder message = new StringBuilder();
        ListIterator<String> listIter = values.listIterator();
        while (listIter.hasNext()) {
            String currentValue = listIter.next();
            message.append(currentValue);
            if (!listIter.hasNext()) continue;
            message.append(", ");
        }
        return message.toString();
    }

    public static String getLastSeenFormat(OfflinePlayer offlineBukkitPlayer) {
        Date date = new Date();
        if (!offlineBukkitPlayer.isOnline()) {
            date = new Date(offlineBukkitPlayer.getLastPlayed());
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm");
        return formatter.format(date);
    }
}

