/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.utility;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.utility.ChatUtil;
import com.github.rumsfield.konquest.utility.CorePath;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.scheduler.BukkitRunnable;

public class RandomWildLocationSearchTask
extends BukkitRunnable {
    private final World world;
    private final Consumer<Location> locationFoundCallback;
    private int triesCount;
    private int numWater;
    private final Iterator<Point> wildIterator;

    public RandomWildLocationSearchTask(Konquest konquest, World world, Consumer<Location> locationFoundCallback) {
        this.world = world;
        this.locationFoundCallback = locationFoundCallback;
        this.triesCount = 0;
        this.numWater = 0;
        int radius = konquest.getCore().getInt(CorePath.TRAVEL_WILD_RADIUS.getPath(), 500);
        radius = Math.max(radius, 16);
        int offsetX = konquest.getCore().getInt(CorePath.TRAVEL_WILD_CENTER_X.getPath(), 0);
        int offsetZ = konquest.getCore().getInt(CorePath.TRAVEL_WILD_CENTER_Z.getPath(), 0);
        int pMinX = (-1 * radius + offsetX) / 16;
        int pMaxX = (radius + 1 + offsetX) / 16;
        int pMinZ = (-1 * radius + offsetZ) / 16;
        int pMaxZ = (radius + 1 + offsetZ) / 16;
        ArrayList<Point> searchPoints = new ArrayList<Point>();
        for (int x = pMinX; x < pMaxX; ++x) {
            for (int z = pMinZ; z < pMaxZ; ++z) {
                Point searchPoint = new Point(x, z);
                if (konquest.getTerritoryManager().isChunkClaimed(searchPoint, world)) continue;
                searchPoints.add(searchPoint);
            }
        }
        Collections.shuffle(searchPoints);
        this.wildIterator = searchPoints.iterator();
        ChatUtil.printDebug("Starting wild location search task with " + searchPoints.size() + " wild chunks.");
    }

    public void run() {
        int randBlockZ;
        int locZ;
        ChatUtil.printDebug("Running wild location search, try " + this.triesCount);
        int MAX_TRIES = 100;
        if (this.triesCount > MAX_TRIES || !this.wildIterator.hasNext()) {
            ChatUtil.printDebug("Failed to get a random wilderness location. Water attempts: " + this.numWater + "; Wild chunks remain: " + this.wildIterator.hasNext());
            this.locationFoundCallback.accept(null);
            this.cancel();
            return;
        }
        Point wildPoint = this.wildIterator.next();
        int randBlockX = ThreadLocalRandom.current().nextInt(0, 16);
        int locX = wildPoint.x * 16 + randBlockX;
        Block wildBlock = this.world.getHighestBlockAt(locX, locZ = wildPoint.y * 16 + (randBlockZ = ThreadLocalRandom.current().nextInt(0, 16)));
        if (!wildBlock.getType().isSolid()) {
            ++this.numWater;
            ++this.triesCount;
            return;
        }
        int locY = wildBlock.getY() + 2;
        Location wildLoc = new Location(this.world, (double)locX, (double)locY, (double)locZ);
        ChatUtil.printDebug("Got wilderness location " + wildLoc.getX() + "," + wildLoc.getY() + "," + wildLoc.getZ() + ". Water attempts: " + this.numWater);
        this.locationFoundCallback.accept(wildLoc);
        this.cancel();
    }
}

