/*
 * Decompiled with CFR 0.152.
 */
package com.github.rumsfield.konquest.utility;

import com.github.rumsfield.konquest.Konquest;
import com.github.rumsfield.konquest.utility.Timeable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class Timer {
    private final BukkitScheduler scheduler;
    private Runnable task;
    private int taskID;
    private int time;
    private int looptime;
    private final Timeable timekeeper;
    private boolean isRunning;

    public Timer(Timeable timekeeper) {
        this.timekeeper = timekeeper;
        this.time = -1;
        this.looptime = -1;
        this.taskID = 0;
        this.scheduler = Bukkit.getScheduler();
        this.isRunning = false;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
        this.looptime = time;
    }

    public int getSeconds() {
        return this.time % 60;
    }

    public int getMinutes() {
        return this.time / 60;
    }

    public int getTaskID() {
        return this.taskID;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void startTimer() {
        if (this.taskID != 0 && this.time > -1) {
            Bukkit.getLogger().severe("Warning: Attempted to start Timer when one has already been started. Cancelling...");
            return;
        }
        this.task = () -> {
            --this.time;
            if (this.time <= -1) {
                this.timekeeper.onEndTimer(this.taskID);
                this.stopTimer();
            }
        };
        this.taskID = this.scheduler.scheduleSyncRepeatingTask((Plugin)Konquest.getInstance().getPlugin(), this.task, 0L, 20L);
        this.isRunning = true;
    }

    public void startLoopTimer() {
        if (this.taskID != 0 && this.time > -1) {
            Bukkit.getLogger().severe("Warning: Attempted to start Timer when one has already been started. Cancelling...");
            return;
        }
        this.task = () -> {
            --this.time;
            if (this.time <= -1) {
                this.timekeeper.onEndTimer(this.taskID);
                this.time = this.looptime;
            }
        };
        this.taskID = this.scheduler.scheduleSyncRepeatingTask((Plugin)Konquest.getInstance().getPlugin(), this.task, 0L, 20L);
        this.isRunning = true;
    }

    public void startLoopTimer(int ticks) {
        if (this.taskID != 0 && this.time > -1) {
            Bukkit.getLogger().severe("Warning: Attempted to start Timer when one has already been started. Cancelling...");
            return;
        }
        this.task = () -> {
            --this.time;
            if (this.time <= -1) {
                this.timekeeper.onEndTimer(this.taskID);
                this.time = this.looptime;
            }
        };
        this.taskID = this.scheduler.scheduleSyncRepeatingTask((Plugin)Konquest.getInstance().getPlugin(), this.task, 0L, (long)ticks);
        this.isRunning = true;
    }

    public void stopTimer() {
        this.time = -1;
        this.looptime = -1;
        this.scheduler.cancelTask(this.taskID);
        this.taskID = 0;
        this.isRunning = false;
    }
}

