/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kotori316.fluidtank.DebugLogging;
import java.time.Duration;
import java.util.function.Supplier;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class FluidTankCommon {
    public static final String modId = "fluidtank";
    public static final Logger LOGGER = LoggerFactory.getLogger(FluidTankCommon.class);
    public static final Marker INITIALIZATION = MarkerFactory.getMarker((String)"Initialization");
    public static final Marker MARKER_CONNECTION = MarkerFactory.getMarker((String)"Connection");
    public static final Marker MARKER_TANK = MarkerFactory.getMarker((String)"Tank");
    public static final Marker MARKER_FLUID_LIKE = MarkerFactory.getMarker((String)"FluidLike");
    public static final Marker MARKER_INGREDIENT = MarkerFactory.getMarker((String)"IU_Ingredient");
    private static final double d = 0.0625;
    public static final VoxelShape TANK_SHAPE = Shapes.create((AABB)new AABB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875));
    private static final Cache<String, String> knownKeys = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();

    public static void logOnceInMinute(String key, Supplier<String> message, @Nullable Supplier<? extends Throwable> error) {
        if (knownKeys.getIfPresent((Object)key) == null) {
            knownKeys.put((Object)key, (Object)key);
            String msg = "[" + key + "] " + message.get();
            if (error == null) {
                LOGGER.warn(msg);
                DebugLogging.LOGGER().fatal(msg);
            } else {
                LOGGER.error(msg, error.get());
                DebugLogging.LOGGER().fatal(msg, error.get());
            }
        }
    }
}

