/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.cat;

import com.kotori316.fluidtank.cat.BlockChestAsTank$;
import com.kotori316.fluidtank.cat.PlatformChestAsTankAccess;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import java.io.Serializable;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import scala.Function1;
import scala.jdk.javaapi.CollectionConverters$;
import scala.runtime.function.JProcedure1;

public abstract class BlockChestAsTank
extends Block
implements EntityBlock {
    public static String NAME() {
        return BlockChestAsTank$.MODULE$.NAME();
    }

    public BlockChestAsTank() {
        super(BlockBehaviour.Properties.of().strength(0.7f).pushReaction(PushReaction.BLOCK).forceSolidOn().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fluidtank", (String)"chest_as_tank"))));
        this.registerDefaultState((BlockState)this.getStateDefinition().any().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getClickedFace().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return PlatformChestAsTankAccess.getInstance().createCATEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.isCrouching()) {
            if (!level.isClientSide()) {
                List<GenericAmount<FluidLike>> fluids = PlatformChestAsTankAccess.getInstance().getCATFluids(level, pos);
                if (fluids.isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"chat.fluidtank.cat_empty"), false);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"chat.fluidtank.cat_fluid"), false);
                }
                CollectionConverters$.MODULE$.asScala(fluids).foreach((Function1)(JProcedure1 & Serializable)f -> {
                    MutableComponent message = Component.literal((String)"[").append((Component)PlatformFluidAccess.getInstance().getDisplayName((GenericAmount<FluidLike>)f).copy().withStyle(ChatFormatting.AQUA)).append("]").append(" " + GenericUnit$.MODULE$.asDisplay$extension(f.amount()) + " mB");
                    player.displayClientMessage((Component)message, false);
                });
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (PlatformFluidAccess.getInstance().isFluidContainer(stack)) {
            if (!level.isClientSide()) {
                return this.transferFluid(level, pos, player, hand, stack);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public abstract InteractionResult transferFluid(Level var1, BlockPos var2, Player var3, InteractionHand var4, ItemStack var5);
}

