/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.contents;

import cats.Foldable;
import cats.Functor;
import cats.Invariant$;
import cats.Monad;
import cats.MonoidK;
import cats.data.Chain;
import cats.data.IndexedReaderWriterStateT;
import cats.implicits$;
import com.kotori316.fluidtank.contents.CreativeTank;
import com.kotori316.fluidtank.contents.DefaultTransferEnv$;
import com.kotori316.fluidtank.contents.FluidTransferLog;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Operations$;
import com.kotori316.fluidtank.contents.Reversible;
import com.kotori316.fluidtank.contents.TransferEnv;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple3;
import scala.math.BigInt;
import scala.math.Ordering;

public abstract class TanksHandler<T, ListType> {
    private final boolean limitOneFluid;
    private final MonoidK<ListType> monoidK;
    private final Monad<ListType> monad;
    private final Foldable<ListType> f;
    private final Reversible<ListType> reversible;
    private ListType tanks;

    public TanksHandler(boolean limitOneFluid, MonoidK<ListType> monoidK, Monad<ListType> monad, Foldable<ListType> f, Reversible<ListType> reversible) {
        this.limitOneFluid = limitOneFluid;
        this.monoidK = monoidK;
        this.monad = monad;
        this.f = f;
        this.reversible = reversible;
        this.tanks = monoidK.empty();
    }

    public ListType tanks() {
        return this.tanks;
    }

    public void tanks_$eq(ListType x$1) {
        this.tanks = x$1;
    }

    public boolean hasCreative() {
        return implicits$.MODULE$.toUnorderedFoldableOps(this.tanks(), this.f).exists((Function1 & Serializable)_$2 -> _$2 instanceof CreativeTank);
    }

    private GenericAmount<T> action(IndexedReaderWriterStateT<Object, TransferEnv, Chain<FluidTransferLog>, GenericAmount<T>, GenericAmount<T>, ListType> op, GenericAmount<T> resource, boolean execute) {
        Tuple3 tuple3 = (Tuple3)op.run((Object)DefaultTransferEnv$.MODULE$, resource, (Monad)Invariant$.MODULE$.catsInstancesForId());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Tuple3 $1$ = tuple3;
        Tuple3 tuple32 = $1$;
        Chain log = (Chain)tuple32._1();
        GenericAmount left = (GenericAmount)tuple32._2();
        Object newTanks = tuple32._3();
        GenericAmount<T> moved = resource.operatorMinus(left);
        if (execute) {
            this.updateTanks(newTanks);
        }
        this.outputLog((Chain<FluidTransferLog>)log, execute);
        return moved;
    }

    public void outputLog(Chain<FluidTransferLog> logs, boolean execute) {
    }

    public void updateTanks(ListType newTanks) {
        this.tanks_$eq(newTanks);
    }

    public BigInt getSumOfCapacity() {
        Object object = Ordering.Implicits$.MODULE$.infixOrderingOps(implicits$.MODULE$.toFoldableOps(this.tanks(), this.f).foldMap((Function1 & Serializable)_$3 -> new GenericUnit(_$3.capacity()), GenericUnit$.MODULE$.groupGenericUnit()), GenericUnit$.MODULE$.orderingGenericUnit()).min((Object)new GenericUnit(GenericUnit$.MODULE$.CREATIVE_TANK()));
        if (object == null) {
            return null;
        }
        return ((GenericUnit)object).value();
    }

    public GenericAmount<T> fill(GenericAmount<T> resource, boolean execute) {
        if (this.limitOneFluid && implicits$.MODULE$.toUnorderedFoldableOps(this.tanks(), this.f).exists((Function1 & Serializable)t -> t.hasContent() && !resource.contentEqual(t.content()))) {
            return resource.createEmpty();
        }
        IndexedReaderWriterStateT op = this.hasCreative() ? Operations$.MODULE$.opList(this.tanks(), (Function1 & Serializable)tank -> Operations$.MODULE$.fillCreativeOp(tank), this.monad, this.f, this.monoidK) : (resource.isGaseous() ? Operations$.MODULE$.fillList(this.reversible.reverse(this.tanks()), this.monad, this.f, this.monoidK).map((Function1 & Serializable)seq -> this.reversible.reverse(seq), (Functor)Invariant$.MODULE$.catsInstancesForId()) : Operations$.MODULE$.fillList(this.tanks(), this.monad, this.f, this.monoidK));
        return this.action(op, resource, execute);
    }

    public GenericAmount<T> drain(GenericAmount<T> resource, boolean execute) {
        IndexedReaderWriterStateT op = this.hasCreative() ? Operations$.MODULE$.opList(this.tanks(), (Function1 & Serializable)tank -> Operations$.MODULE$.drainCreativeOp(tank), this.monad, this.f, this.monoidK) : (resource.isGaseous() ? Operations$.MODULE$.drainList(this.tanks(), this.monad, this.f, this.monoidK) : Operations$.MODULE$.drainList(this.reversible.reverse(this.tanks()), this.monad, this.f, this.monoidK).map((Function1 & Serializable)seq -> this.reversible.reverse(seq), (Functor)Invariant$.MODULE$.catsInstancesForId()));
        return this.action(op, resource, execute);
    }

    public GenericAmount<T> set(GenericAmount<T> resource) {
        this.tanks_$eq(this.monad.map(this.tanks(), (Function1 & Serializable)tank -> tank.copy(tank.content().createEmpty(), tank.copy$default$2())));
        return this.fill(resource, true);
    }
}

