/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fluids;

import com.kotori316.fluidtank.contents.GenericAccess;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.FluidLike$;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.PotionType;
import com.kotori316.fluidtank.fluids.package$;
import java.io.Serializable;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.VisibleForTesting;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.BigInt;
import scala.runtime.ModuleSerializationProxy;

public final class FluidAmountUtil$
implements Serializable {
    private static final GenericAmount<FluidLike> EMPTY;
    private static final GenericAmount<FluidLike> BUCKET_WATER;
    private static final GenericAmount<FluidLike> BUCKET_LAVA;
    public static final FluidAmountUtil$ MODULE$;

    private FluidAmountUtil$() {
    }

    static {
        MODULE$ = new FluidAmountUtil$();
        EMPTY = MODULE$.from(Fluids.EMPTY, GenericUnit$.MODULE$.ZERO());
        BUCKET_WATER = MODULE$.from((Fluid)Fluids.WATER, GenericUnit$.MODULE$.ONE_BUCKET());
        BUCKET_LAVA = MODULE$.from((Fluid)Fluids.LAVA, GenericUnit$.MODULE$.ONE_BUCKET());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FluidAmountUtil$.class);
    }

    public final GenericAmount<FluidLike> EMPTY() {
        return EMPTY;
    }

    public final GenericAmount<FluidLike> BUCKET_WATER() {
        return BUCKET_WATER;
    }

    public final GenericAmount<FluidLike> BUCKET_LAVA() {
        return BUCKET_LAVA;
    }

    public GenericAmount<FluidLike> from(Fluid fluid, BigInt genericUnit, Option<DataComponentPatch> componentPatch) {
        return this.from((FluidLike)FluidLike$.MODULE$.of(fluid), genericUnit, componentPatch);
    }

    public GenericAmount<FluidLike> from(Fluid fluid, BigInt genericUnit) {
        return this.from(fluid, genericUnit, (Option<DataComponentPatch>)Option$.MODULE$.empty());
    }

    public GenericAmount<FluidLike> from(FluidLike fluidLike, BigInt genericUnit, Option<DataComponentPatch> componentPatch) {
        return ((GenericAccess)Predef$.MODULE$.implicitly(package$.MODULE$.fluidAccess())).newInstance(fluidLike, genericUnit, componentPatch);
    }

    public GenericAmount<FluidLike> from(FluidLike fluidLike, BigInt genericUnit, DataComponentPatch componentPatch) {
        return this.from(fluidLike, genericUnit, (Option<DataComponentPatch>)Option$.MODULE$.apply((Object)componentPatch));
    }

    @VisibleForTesting
    public GenericAmount<FluidLike> from(PotionType potionType, Holder<Potion> potion, BigInt genericUnit) {
        DataComponentPatch componentMap = PotionContents.createItemStack((Item)Items.POTION, potion).getComponentsPatch();
        return this.from((FluidLike)FluidLike$.MODULE$.of(potionType), genericUnit, componentMap);
    }

    @VisibleForTesting
    public GenericAmount<FluidLike> fromItem(ItemStack stack) {
        Item item = stack.getItem();
        Item item2 = Items.WATER_BUCKET;
        Item item3 = item;
        if (!(item2 != null ? !item2.equals(item3) : item3 != null)) {
            return this.BUCKET_WATER();
        }
        Item item4 = Items.LAVA_BUCKET;
        Item item5 = item;
        if (!(item4 != null ? !item4.equals(item5) : item5 != null)) {
            return this.BUCKET_LAVA();
        }
        return PlatformFluidAccess.getInstance().getFluidContained(stack);
    }

    public GenericAmount<FluidLike> fromTag(CompoundTag tag) {
        return ((GenericAccess)Predef$.MODULE$.implicitly(package$.MODULE$.fluidAccess())).read(tag);
    }

    public GenericAccess<FluidLike> access() {
        return (GenericAccess)Predef$.MODULE$.implicitly(package$.MODULE$.fluidAccess());
    }

    public Optional<DataComponentPatch> getComponentPatch(GenericAmount<FluidLike> amount) {
        Option option = OptionConverters$.MODULE$.RichOption(amount.componentPatch());
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }
}

