/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fluids;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccessHolder;
import com.kotori316.fluidtank.fluids.TransferFluid;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlatformFluidAccess {
    @NotNull
    public static PlatformFluidAccess getInstance() {
        return PlatformFluidAccessHolder.platformFluidAccess;
    }

    public static void setInstance(@NotNull PlatformFluidAccess access) {
        PlatformFluidAccessHolder.platformFluidAccess = access;
    }

    public boolean isGaseous(Fluid var1);

    @NotNull
    public Fluid getBucketContent(BucketItem var1);

    @NotNull
    public GenericAmount<FluidLike> getFluidContained(ItemStack var1);

    public boolean isFluidContainer(ItemStack var1);

    public Component getDisplayName(GenericAmount<FluidLike> var1);

    @NotNull
    public TransferStack fillItem(GenericAmount<FluidLike> var1, ItemStack var2, Player var3, InteractionHand var4, boolean var5);

    @NotNull
    public TransferStack drainItem(GenericAmount<FluidLike> var1, ItemStack var2, Player var3, InteractionHand var4, boolean var5);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <TRANSACTION extends AutoCloseable> TransferStack moveItemInTransaction(ItemStack stack, Player player, boolean execute, TransferStack result, Supplier<TRANSACTION> startTransaction, Consumer<TRANSACTION> transactionCommit, ToLongBiFunction<ItemStack, TRANSACTION> exchange) {
        if (!result.moved().nonEmpty()) return result;
        try (AutoCloseable transaction = (AutoCloseable)startTransaction.get();){
            long exchanged = exchange.applyAsLong(result.toReplace(), transaction);
            if (exchanged != 1L) return new TransferStack(FluidAmountUtil.EMPTY(), stack, false);
            if (execute && TransferFluid.shouldMoveItem(player)) {
                transactionCommit.accept(transaction);
            }
            TransferStack transferStack = result.setShouldMove(false);
            return transferStack;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public SoundEvent getEmptySound(GenericAmount<FluidLike> var1);

    @Nullable
    public SoundEvent getFillSound(GenericAmount<FluidLike> var1);

    public record TransferStack(GenericAmount<FluidLike> moved, ItemStack toReplace, boolean shouldMove) {
        public TransferStack(GenericAmount<FluidLike> moved, ItemStack toReplace) {
            this(moved, toReplace, true);
        }

        public TransferStack setShouldMove(boolean shouldMove) {
            return new TransferStack(this.moved, this.toReplace, shouldMove);
        }
    }
}

