/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.fluids;

import com.kotori316.fluidtank.FluidTankCommon;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.potions.PotionFluidHandler;
import java.lang.reflect.Field;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PlatformFluidAccessHolder {
    @NotNull
    static PlatformFluidAccess platformFluidAccess = new Default();

    PlatformFluidAccessHolder() {
    }

    @ApiStatus.Internal
    private static final class Default
    implements PlatformFluidAccess {
        private Default() {
        }

        @Override
        public boolean isGaseous(Fluid fluid) {
            return false;
        }

        @Override
        public Fluid getBucketContent(BucketItem bucketItem) {
            try {
                Field field = BucketItem.class.getDeclaredField("content");
                field.setAccessible(true);
                return (Fluid)field.get(bucketItem);
            }
            catch (ReflectiveOperationException e) {
                FluidTankCommon.LOGGER.error("Got error in getting fluid content of %s. Are you in production?".formatted(bucketItem), (Throwable)e);
                return Fluids.EMPTY;
            }
        }

        @Override
        @NotNull
        public GenericAmount<FluidLike> getFluidContained(ItemStack stack) {
            PotionFluidHandler potionHandler = PotionFluidHandler.apply(stack);
            if (potionHandler.isValidHandler()) {
                return potionHandler.getContent();
            }
            Item item = stack.getItem();
            if (item instanceof BucketItem) {
                Default access = this;
                BucketItem bucketItem = (BucketItem)item;
                Fluid fluid = access.getBucketContent(bucketItem);
                if (Fluids.EMPTY.equals(fluid)) {
                    return FluidAmountUtil.EMPTY();
                }
                return FluidAmountUtil.from(fluid, GenericUnit.ONE_BUCKET());
            }
            return FluidAmountUtil.EMPTY();
        }

        @Override
        public boolean isFluidContainer(ItemStack stack) {
            return stack.getItem() instanceof BucketItem || PotionFluidHandler.apply(stack).isValidHandler();
        }

        @Override
        public Component getDisplayName(GenericAmount<FluidLike> amount) {
            return Component.literal((String)FluidAmountUtil.access().asString(amount.content()));
        }

        @Override
        public PlatformFluidAccess.TransferStack fillItem(GenericAmount<FluidLike> toFill, ItemStack fluidContainer, Player player, InteractionHand hand, boolean execute) {
            FluidLike filledItem;
            FluidLike fluidLike = toFill.content();
            if (fluidLike instanceof VanillaFluid) {
                VanillaFluid vanillaFluid = (VanillaFluid)fluidLike;
                if (fluidContainer.getItem() == Items.BUCKET && toFill.hasOneBucket()) {
                    filledItem = vanillaFluid.fluid().getBucket().getDefaultInstance();
                    GenericAmount<FluidLike> filledAmount = toFill.setAmount(GenericUnit.ONE_BUCKET());
                    return new PlatformFluidAccess.TransferStack(filledAmount, (ItemStack)filledItem);
                }
                return new PlatformFluidAccess.TransferStack(FluidAmountUtil.EMPTY(), fluidContainer, false);
            }
            filledItem = toFill.content();
            if (filledItem instanceof VanillaPotion) {
                VanillaPotion vanillaPotion = (VanillaPotion)filledItem;
                PotionFluidHandler handler = PotionFluidHandler.apply(fluidContainer);
                return handler.fill(toFill, vanillaPotion);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public PlatformFluidAccess.TransferStack drainItem(GenericAmount<FluidLike> toDrain, ItemStack fluidContainer, Player player, InteractionHand hand, boolean execute) {
            GenericAmount<FluidLike> content = this.getFluidContained(fluidContainer);
            if (toDrain.content() instanceof VanillaFluid) {
                if (!(toDrain.hasOneBucket() && content.hasOneBottle() && toDrain.contentEqual(content))) {
                    return new PlatformFluidAccess.TransferStack(FluidAmountUtil.EMPTY(), fluidContainer, false);
                }
                ItemStack drainedItem = Items.BUCKET.getDefaultInstance();
                GenericAmount<FluidLike> drainedAmount = toDrain.setAmount(GenericUnit.ONE_BUCKET());
                return new PlatformFluidAccess.TransferStack(drainedAmount, drainedItem);
            }
            FluidLike drainedItem = toDrain.content();
            if (drainedItem instanceof VanillaPotion) {
                VanillaPotion v = (VanillaPotion)drainedItem;
                PotionFluidHandler handler = PotionFluidHandler.apply(fluidContainer);
                return handler.drain(toDrain, v);
            }
            throw new AssertionError();
        }

        @Override
        public SoundEvent getEmptySound(GenericAmount<FluidLike> fluid) {
            return FluidLike.asFluid(fluid.content(), (Fluid)Fluids.WATER).is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        }

        @Override
        @Nullable
        public SoundEvent getFillSound(GenericAmount<FluidLike> fluid) {
            return FluidLike.asFluid(fluid.content(), (Fluid)Fluids.WATER).getPickupSound().orElse(null);
        }
    }
}

