/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.item;

import com.google.gson.JsonElement;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.item.PlatformItemAccessHolder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.TagValueOutput;
import org.jetbrains.annotations.NotNull;

public interface PlatformItemAccess {
    public static PlatformItemAccess getInstance() {
        return PlatformItemAccessHolder.access;
    }

    public static void setInstance(PlatformItemAccess access) {
        PlatformItemAccessHolder.access = access;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack var1);

    public Codec<Ingredient> ingredientCodec();

    public DataComponentType<Tank<FluidLike>> fluidTankComponentType();

    public static void setTileTag(@NotNull ItemStack stack, @NotNull TagValueOutput tagValueOutput, @NotNull BlockEntityType<?> blockEntityType) {
        BlockItem.setBlockEntityData((ItemStack)stack, blockEntityType, (TagValueOutput)tagValueOutput);
    }

    public static String convertIngredientToString(Ingredient ingredient) {
        return "[%s]".formatted(PlatformItemAccess.getInstance().ingredientToJson(ingredient));
    }

    default public JsonElement ingredientToJson(Ingredient ingredient) {
        return (JsonElement)this.ingredientCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ingredient).getOrThrow();
    }
}

