/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge;

import com.kotori316.fluidtank.DebugLogging;
import com.kotori316.fluidtank.FluidTankCommon;
import com.kotori316.fluidtank.PlatformAccess;
import com.kotori316.fluidtank.cat.BlockChestAsTank;
import com.kotori316.fluidtank.cat.ItemChestAsTank;
import com.kotori316.fluidtank.config.PlatformConfigAccess;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.neoforge.NeoForgePlatformAccess;
import com.kotori316.fluidtank.neoforge.SideProxy;
import com.kotori316.fluidtank.neoforge.cat.BlockChestAsTankNeoForge;
import com.kotori316.fluidtank.neoforge.cat.EntityChestAsTank;
import com.kotori316.fluidtank.neoforge.config.NeoForgePlatformConfigAccess;
import com.kotori316.fluidtank.neoforge.integration.ae2.AE2FluidTankIntegration;
import com.kotori316.fluidtank.neoforge.integration.top.FluidTankTopPlugin;
import com.kotori316.fluidtank.neoforge.message.PacketHandler;
import com.kotori316.fluidtank.neoforge.reservoir.ItemReservoirNeoForge;
import com.kotori316.fluidtank.neoforge.tank.BlockCreativeTankNeoForge;
import com.kotori316.fluidtank.neoforge.tank.BlockTankNeoForge;
import com.kotori316.fluidtank.neoforge.tank.BlockVoidTankNeoForge;
import com.kotori316.fluidtank.neoforge.tank.ItemBlockTankNeoForge;
import com.kotori316.fluidtank.neoforge.tank.TileCreativeTankNeoForge;
import com.kotori316.fluidtank.neoforge.tank.TileTankNeoForge;
import com.kotori316.fluidtank.neoforge.tank.TileVoidTankNeoForge;
import com.kotori316.fluidtank.recipe.TierRecipe;
import com.kotori316.fluidtank.reservoir.ItemReservoir;
import com.kotori316.fluidtank.tank.BlockTank;
import com.kotori316.fluidtank.tank.ItemBlockTank;
import com.kotori316.fluidtank.tank.TankLootFunction;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileCreativeTank;
import com.kotori316.fluidtank.tank.TileTank;
import com.kotori316.fluidtank.tank.TileVoidTank;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod(value="fluidtank")
public final class FluidTank {
    public static final SideProxy proxy = SideProxy.get();
    private static final DeferredRegister.Blocks BLOCK_REGISTER = DeferredRegister.createBlocks((String)"fluidtank");
    private static final DeferredRegister.Items ITEM_REGISTER = DeferredRegister.createItems((String)"fluidtank");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"fluidtank");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"fluidtank");
    private static final DeferredRegister<IngredientType<?>> INGREDIENT_REGISTER = DeferredRegister.create((Registry)NeoForgeRegistries.INGREDIENT_TYPES, (String)"fluidtank");
    private static final DeferredRegister<CreativeModeTab> CREATIVE_TAB_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (String)"fluidtank");
    private static final DeferredRegister<LootItemFunctionType<?>> LOOT_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.LOOT_FUNCTION_TYPE, (String)"fluidtank");
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"fluidtank");
    public static final List<DeferredRegister<?>> REGISTER_LIST = List.of(BLOCK_REGISTER, ITEM_REGISTER, BLOCK_ENTITY_REGISTER, RECIPE_REGISTER, INGREDIENT_REGISTER, CREATIVE_TAB_REGISTER, LOOT_TYPE_REGISTER, DATA_COMPONENT_TYPE_REGISTER);
    public static final Map<Tier, DeferredBlock<BlockTankNeoForge>> TANK_MAP = Stream.of(Tier.values()).filter(Tier::isNormalTankTier).collect(Collectors.toMap(Function.identity(), t -> BLOCK_REGISTER.register(t.getBlockName(), () -> new BlockTankNeoForge((Tier)((Object)t)))));
    public static final DeferredBlock<BlockCreativeTankNeoForge> BLOCK_CREATIVE_TANK = BLOCK_REGISTER.register(Tier.CREATIVE.getBlockName(), BlockCreativeTankNeoForge::new);
    public static final DeferredBlock<BlockVoidTankNeoForge> BLOCK_VOID_TANK = BLOCK_REGISTER.register(Tier.VOID.getBlockName(), BlockVoidTankNeoForge::new);
    public static final Map<Tier, DeferredItem<ItemBlockTank>> TANK_ITEM_MAP = Stream.concat(TANK_MAP.entrySet().stream(), Stream.of(Map.entry(Tier.CREATIVE, BLOCK_CREATIVE_TANK), Map.entry(Tier.VOID, BLOCK_VOID_TANK))).collect(Collectors.toMap(Map.Entry::getKey, e -> ITEM_REGISTER.register(((Tier)((Object)((Object)e.getKey()))).getBlockName(), () -> ((BlockTank)((Object)((Object)((Object)((DeferredBlock)e.getValue()).get())))).itemBlock())));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileTankNeoForge>> TILE_TANK_TYPE = BLOCK_ENTITY_REGISTER.register(TileTank.class.getSimpleName().toLowerCase(Locale.ROOT), () -> new BlockEntityType(TileTankNeoForge::new, (Block[])TANK_MAP.values().stream().map(DeferredHolder::get).toArray(BlockTank[]::new)));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileCreativeTankNeoForge>> TILE_CREATIVE_TANK_TYPE = BLOCK_ENTITY_REGISTER.register(TileCreativeTank.class.getSimpleName().toLowerCase(Locale.ROOT), () -> new BlockEntityType(TileCreativeTankNeoForge::new, new Block[]{(Block)BLOCK_CREATIVE_TANK.get()}));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TileVoidTankNeoForge>> TILE_VOID_TANK_TYPE = BLOCK_ENTITY_REGISTER.register(TileVoidTank.class.getSimpleName().toLowerCase(Locale.ROOT), () -> new BlockEntityType(TileVoidTankNeoForge::new, new Block[]{(Block)BLOCK_VOID_TANK.get()}));
    public static final DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<TankLootFunction>> TANK_LOOT_FUNCTION = LOOT_TYPE_REGISTER.register("content_tank", () -> new LootItemFunctionType(TankLootFunction.CODEC));
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> TIER_RECIPE = RECIPE_REGISTER.register(TierRecipe.Serializer.LOCATION.getPath(), () -> TierRecipe.SERIALIZER);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> CREATIVE_TAB = CREATIVE_TAB_REGISTER.register("tab", () -> {
        CreativeModeTab.Builder b = CreativeModeTab.builder();
        FluidTank.createTab(b);
        return b.build();
    });
    public static final DeferredBlock<BlockChestAsTank> BLOCK_CAT = BLOCK_REGISTER.register(BlockChestAsTank.NAME(), BlockChestAsTankNeoForge::new);
    public static final DeferredItem<BlockItem> ITEM_CAT = ITEM_REGISTER.register(BlockChestAsTank.NAME(), () -> new ItemChestAsTank((Block)BLOCK_CAT.get()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<EntityChestAsTank>> TILE_CAT = BLOCK_ENTITY_REGISTER.register(BlockChestAsTank.NAME(), () -> new BlockEntityType(EntityChestAsTank::new, new Block[]{(Block)BLOCK_CAT.get()}));
    public static final Map<Tier, DeferredItem<ItemReservoirNeoForge>> RESERVOIR_MAP = Stream.of(Tier.WOOD, Tier.STONE, Tier.IRON).collect(Collectors.toMap(Function.identity(), t -> ITEM_REGISTER.register("reservoir_" + t.name().toLowerCase(Locale.ROOT), () -> new ItemReservoirNeoForge((Tier)((Object)t)))));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Tank<FluidLike>>> FLUID_TANK_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("fluid_tank_component", () -> DataComponentType.builder().persistent(Tank.codec(FluidAmountUtil.access())).build());

    public FluidTank(IEventBus modBus, ModContainer container) {
        FluidTankCommon.LOGGER.info(FluidTankCommon.INITIALIZATION, "Initialize {} with {}", (Object)container.getModId(), (Object)container.getClass().getName());
        NeoForgeMod.enableMilkFluid();
        REGISTER_LIST.forEach(r -> r.register(modBus));
        PlatformAccess.setInstance(new NeoForgePlatformAccess());
        FluidTank.setupConfig(modBus, container);
        modBus.register((Object)this);
        modBus.register((Object)proxy);
        modBus.addListener(FluidTank::registerCapabilities);
        AE2FluidTankIntegration.onAPIAvailable(modBus);
        FluidTankTopPlugin.sendIMC();
        NeoForge.EVENT_BUS.addListener(FluidTank::onServerStart);
        FluidTankCommon.LOGGER.info(FluidTankCommon.INITIALIZATION, "Initialize finished {}", (Object)container.getModId());
    }

    private static void setupConfig(IEventBus modBus, ModContainer container) {
        NeoForgePlatformConfigAccess config = new NeoForgePlatformConfigAccess();
        modBus.register((Object)config);
        ModConfigSpec.Builder builder = config.setupConfig();
        PlatformConfigAccess.setInstance(config);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build());
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void setupPacket(RegisterPayloadHandlersEvent event) {
        PacketHandler.init(event);
    }

    private static void createTab(CreativeModeTab.Builder builder) {
        builder.icon(() -> new ItemStack((ItemLike)TANK_MAP.get((Object)Tier.WOOD).get()));
        builder.title((Component)Component.translatable((String)"itemGroup.fluidtank"));
        builder.displayItems((parameters, output) -> {
            TANK_ITEM_MAP.values().stream().map(DeferredHolder::get).sorted(Comparator.comparing(i -> i.blockTank().tier())).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
            output.accept((ItemLike)ITEM_CAT.get());
            RESERVOIR_MAP.values().stream().map(DeferredHolder::get).sorted(Comparator.comparing(ItemReservoir::tier)).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        });
    }

    static void onServerStart(ServerStartedEvent event) {
        FluidTankCommon.LOGGER.info(FluidTankCommon.INITIALIZATION, "OnServerStart {}, {}", (Object)"fluidtank", (Object)event.getServer().getMotd());
        DebugLogging.initialLog(event.getServer());
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)TILE_TANK_TYPE.get(), TileTankNeoForge::getCapability);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)TILE_CREATIVE_TANK_TYPE.get(), TileCreativeTankNeoForge::getCapability);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)TILE_VOID_TANK_TYPE.get(), TileVoidTankNeoForge::getCapability);
        event.registerBlockEntity(Capabilities.Fluid.BLOCK, (BlockEntityType)TILE_CAT.get(), EntityChestAsTank::getCapability);
        event.registerItem(Capabilities.Fluid.ITEM, ItemBlockTankNeoForge::initCapabilities, (ItemLike[])TANK_MAP.values().stream().map(DeferredBlock::asItem).toArray(Item[]::new));
        event.registerItem(Capabilities.Fluid.ITEM, ItemReservoirNeoForge::initCapabilities, (ItemLike[])RESERVOIR_MAP.values().stream().map(DeferredItem::asItem).toArray(Item[]::new));
    }
}

