/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge;

import com.google.gson.JsonElement;
import com.kotori316.fluidtank.PlatformAccess;
import com.kotori316.fluidtank.PlatformBaseAccess;
import com.kotori316.fluidtank.cat.BlockChestAsTank;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.TransferFluid;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.neoforge.FluidTank;
import com.kotori316.fluidtank.neoforge.cat.EntityChestAsTank;
import com.kotori316.fluidtank.neoforge.fluid.NeoForgeConverter;
import com.kotori316.fluidtank.neoforge.integration.neoforge.SingleBucketResourceHandler;
import com.kotori316.fluidtank.potions.PotionFluidHandler;
import com.kotori316.fluidtank.reservoir.ItemReservoir;
import com.kotori316.fluidtank.tank.BlockTank;
import com.kotori316.fluidtank.tank.TankLootFunction;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileTank;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NeoForgePlatformAccess
implements PlatformAccess {
    NeoForgePlatformAccess() {
    }

    @Override
    public boolean isGaseous(Fluid fluid) {
        return fluid.getFluidType().isLighterThanAir();
    }

    @Override
    @NotNull
    public Fluid getBucketContent(BucketItem bucketItem) {
        return bucketItem.content;
    }

    @Override
    @NotNull
    public GenericAmount<FluidLike> getFluidContained(ItemStack stack) {
        PotionFluidHandler potionHandler = PotionFluidHandler.apply(stack);
        if (potionHandler.isValidHandler()) {
            return potionHandler.getContent();
        }
        return Optional.ofNullable(NeoForgePlatformAccess.getFluidHandler(ItemAccess.forStack((ItemStack)stack))).map(r -> NeoForgeConverter.toAmount((FluidResource)r.getResource(0), r.getAmountAsLong(0))).orElse(FluidAmountUtil.EMPTY());
    }

    @Override
    public boolean isFluidContainer(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return NeoForgePlatformAccess.getFluidHandler(ItemAccess.forStack((ItemStack)stack)) != null || PotionFluidHandler.apply(stack).isValidHandler();
    }

    @Override
    public Component getDisplayName(GenericAmount<FluidLike> amount) {
        if (amount.content() instanceof VanillaFluid) {
            return NeoForgeConverter.toStack(amount).getHoverName();
        }
        FluidLike fluidLike = amount.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion = (VanillaPotion)fluidLike;
            return vanillaPotion.getVanillaPotionName(amount.componentPatch());
        }
        throw new AssertionError();
    }

    @Override
    @NotNull
    public PlatformFluidAccess.TransferStack fillItem(GenericAmount<FluidLike> toFill, ItemStack fluidContainer, Player player, InteractionHand hand, boolean execute) {
        int filled;
        ItemAccess itemAccess = ItemAccess.forPlayerInteraction((Player)player, (InteractionHand)hand);
        FluidLike fluidLike = toFill.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion = (VanillaPotion)fluidLike;
            PotionFluidHandler potionHandler = PotionFluidHandler.apply(fluidContainer);
            PlatformFluidAccess.TransferStack result = potionHandler.fill(toFill, vanillaPotion);
            return NeoForgePlatformAccess.moveItem(fluidContainer, player, execute, result, itemAccess);
        }
        ResourceHandler<FluidResource> fluidHandler = NeoForgePlatformAccess.getFluidHandler(itemAccess);
        if (fluidHandler == null) {
            return new PlatformFluidAccess.TransferStack(FluidAmountUtil.EMPTY(), fluidContainer, false);
        }
        try (Transaction transaction = Transaction.openRoot();){
            filled = fluidHandler.insert((Resource)NeoForgeConverter.toVariant(toFill), NeoForgeConverter.forgeAmount(toFill), (TransactionContext)transaction);
            if (execute && TransferFluid.shouldMoveItem(player)) {
                transaction.commit();
            }
        }
        return new PlatformFluidAccess.TransferStack(toFill.setAmount(GenericUnit.fromForge(filled)), itemAccess.getResource().toStack(itemAccess.getAmount()), false);
    }

    @Override
    @NotNull
    public PlatformFluidAccess.TransferStack drainItem(GenericAmount<FluidLike> toDrain, ItemStack fluidContainer, Player player, InteractionHand hand, boolean execute) {
        int drained;
        ItemAccess itemAccess = ItemAccess.forPlayerInteraction((Player)player, (InteractionHand)hand);
        FluidLike fluidLike = toDrain.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion v = (VanillaPotion)fluidLike;
            PotionFluidHandler potionHandler = PotionFluidHandler.apply(fluidContainer);
            PlatformFluidAccess.TransferStack result = potionHandler.drain(toDrain, v);
            return NeoForgePlatformAccess.moveItem(fluidContainer, player, execute, result, itemAccess);
        }
        ResourceHandler<FluidResource> fluidHandler = NeoForgePlatformAccess.getFluidHandler(itemAccess);
        if (fluidHandler == null) {
            return new PlatformFluidAccess.TransferStack(FluidAmountUtil.EMPTY(), fluidContainer, false);
        }
        try (Transaction transaction = Transaction.openRoot();){
            drained = fluidHandler.extract((Resource)NeoForgeConverter.toVariant(toDrain), NeoForgeConverter.forgeAmount(toDrain), (TransactionContext)transaction);
            if (execute && TransferFluid.shouldMoveItem(player)) {
                transaction.commit();
            }
        }
        return new PlatformFluidAccess.TransferStack(toDrain.setAmount(GenericUnit.fromForge(drained)), itemAccess.getResource().toStack(itemAccess.getAmount()), false);
    }

    @NotNull
    private static PlatformFluidAccess.TransferStack moveItem(ItemStack stack, Player player, boolean execute, PlatformFluidAccess.TransferStack result, ItemAccess context) {
        return PlatformFluidAccess.moveItemInTransaction(stack, player, execute, result, Transaction::openRoot, Transaction::commit, (itemStack, transaction) -> context.exchange(ItemResource.of((ItemStack)itemStack), 1, (TransactionContext)transaction));
    }

    @Nullable
    public static ResourceHandler<FluidResource> getFluidHandler(ItemAccess access) {
        ItemResource item = access.getResource();
        if (item.is((Object)Items.BUCKET) || item.is((Object)Items.MILK_BUCKET) || item.getItem() instanceof BucketItem) {
            return new SingleBucketResourceHandler(access);
        }
        return (ResourceHandler)access.getCapability(Capabilities.Fluid.ITEM);
    }

    @Override
    @Nullable
    public SoundEvent getEmptySound(GenericAmount<FluidLike> fluid) {
        return FluidLike.asFluid(fluid.content(), (Fluid)Fluids.WATER).getFluidType().getSound(NeoForgeConverter.toStack(fluid), SoundActions.BUCKET_EMPTY);
    }

    @Override
    @Nullable
    public SoundEvent getFillSound(GenericAmount<FluidLike> fluid) {
        return FluidLike.asFluid(fluid.content(), (Fluid)Fluids.WATER).getFluidType().getSound(NeoForgeConverter.toStack(fluid), SoundActions.BUCKET_FILL);
    }

    @Override
    public BlockEntityType<? extends TileTank> getNormalType() {
        return (BlockEntityType)FluidTank.TILE_TANK_TYPE.get();
    }

    @Override
    public BlockEntityType<? extends TileTank> getCreativeType() {
        return (BlockEntityType)FluidTank.TILE_CREATIVE_TANK_TYPE.get();
    }

    @Override
    public BlockEntityType<? extends TileTank> getVoidType() {
        return (BlockEntityType)FluidTank.TILE_VOID_TANK_TYPE.get();
    }

    @Override
    public LootItemFunctionType<TankLootFunction> getTankLoot() {
        return (LootItemFunctionType)FluidTank.TANK_LOOT_FUNCTION.get();
    }

    @Override
    public Map<Tier, Supplier<? extends BlockTank>> getTankBlockMap() {
        return Stream.concat(FluidTank.TANK_MAP.entrySet().stream(), Stream.of(Map.entry(Tier.CREATIVE, FluidTank.BLOCK_CREATIVE_TANK), Map.entry(Tier.VOID, FluidTank.BLOCK_VOID_TANK))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<Tier, ? extends Supplier<? extends ItemReservoir>> getReservoirMap() {
        return FluidTank.RESERVOIR_MAP;
    }

    @Override
    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.getCraftingRemainder();
    }

    @Override
    public Codec<Ingredient> ingredientCodec() {
        return Ingredient.CODEC;
    }

    @Override
    public JsonElement ingredientToJson(Ingredient ingredient) {
        return PlatformAccess.super.ingredientToJson(ingredient);
    }

    @Override
    public DataComponentType<Tank<FluidLike>> fluidTankComponentType() {
        return (DataComponentType)FluidTank.FLUID_TANK_DATA_COMPONENT.get();
    }

    @Override
    public Supplier<? extends BlockChestAsTank> getCATBlock() {
        return FluidTank.BLOCK_CAT;
    }

    @Override
    public BlockEntity createCATEntity(BlockPos pos, BlockState state) {
        return new EntityChestAsTank(pos, state);
    }

    @Override
    public List<GenericAmount<FluidLike>> getCATFluids(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EntityChestAsTank) {
            EntityChestAsTank cat = (EntityChestAsTank)blockEntity;
            return cat.getFluids().orElse(List.of());
        }
        return List.of();
    }

    @Override
    @NotNull
    public PlatformBaseAccess.Platforms getPlatform() {
        return PlatformBaseAccess.Platforms.NEOFORGE;
    }
}

