/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge.cat;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.FluidLikeKey;
import com.kotori316.fluidtank.neoforge.FluidTank;
import com.kotori316.fluidtank.neoforge.fluid.NeoForgeConverter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import scala.math.BigInt;

public class EntityChestAsTank
extends BlockEntity {
    @Nullable
    private FluidHandlerProxy proxy = null;

    public EntityChestAsTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)FluidTank.TILE_CAT.get(), pos, state);
    }

    @Nullable
    public ResourceHandler<FluidResource> getCapability(Direction ignored) {
        if (!(this.getLevel() instanceof ServerLevel)) {
            return null;
        }
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    private FluidHandlerProxy createProxy() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
        BlockPos pos = this.getBlockPos().relative(facing);
        BlockCapabilityCache cache = BlockCapabilityCache.create((BlockCapability)Capabilities.Item.BLOCK, (ServerLevel)((ServerLevel)Objects.requireNonNull(this.getLevel())), (BlockPos)pos, (Object)facing.getOpposite(), () -> true, () -> {
            this.proxy = null;
        });
        return new FluidHandlerProxy(cache);
    }

    public Optional<List<GenericAmount<FluidLike>>> getFluids() {
        return Optional.ofNullable(this.getCapability(null)).filter(FluidHandlerProxy.class::isInstance).map(FluidHandlerProxy.class::cast).map(FluidHandlerProxy::fluids).map(m -> m.entrySet().stream().map(e -> ((FluidLikeKey)e.getKey()).toAmount((BigInt)e.getValue())).toList());
    }

    @VisibleForTesting
    public static ResourceHandler<FluidResource> getProxy(ResourceHandler<ItemResource> handler) {
        return new FluidHandlerProxy(handler);
    }

    static class FluidHandlerProxy
    implements ResourceHandler<FluidResource> {
        private final Supplier<ResourceHandler<ItemResource>> cache;

        FluidHandlerProxy(BlockCapabilityCache<ResourceHandler<ItemResource>, ?> cache) {
            this.cache = () -> cache.getCapability();
        }

        @VisibleForTesting
        FluidHandlerProxy(ResourceHandler<ItemResource> handler) {
            this.cache = () -> handler;
        }

        public int size() {
            ResourceHandler<ItemResource> inventory = this.cache.get();
            if (inventory == null) {
                return 0;
            }
            return inventory.size();
        }

        public FluidResource getResource(int index) {
            return this.getHandler(index).map(h -> (FluidResource)h.getResource(0)).orElse(FluidResource.EMPTY);
        }

        public long getAmountAsLong(int index) {
            return this.getHandler(index).map(h -> h.getAmountAsLong(0)).orElse(0L);
        }

        public long getCapacityAsLong(int index, FluidResource resource) {
            return this.getHandler(index).map(h -> h.getCapacityAsLong(0, (Resource)resource)).orElse(0L);
        }

        public boolean isValid(int index, FluidResource resource) {
            return this.getHandler(index).filter(h -> h.isValid(0, (Resource)resource)).isPresent();
        }

        public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
            return this.getHandler(index).map(h -> h.insert((Resource)resource, amount, transaction)).orElse(0);
        }

        public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
            return this.getHandler(index).map(h -> h.extract((Resource)resource, amount, transaction)).orElse(0);
        }

        Optional<ResourceHandler<FluidResource>> getHandler(int slot) {
            return Optional.ofNullable(this.cache.get()).map(i -> ItemAccess.forHandlerIndexStrict((ResourceHandler)i, (int)slot)).map(i -> (ResourceHandler)i.getCapability(Capabilities.Fluid.ITEM));
        }

        Map<FluidLikeKey, BigInt> fluids() {
            return IntStream.range(0, this.size()).mapToObj(i -> NeoForgeConverter.toAmount(this.getResource(i), this.getAmountAsLong(i))).filter(Predicate.not(GenericAmount::isEmpty)).collect(Collectors.groupingBy(f -> FluidLikeKey.apply((FluidLike)f.content(), f.componentPatch()), Collectors.reducing(BigInt.apply((int)0), GenericAmount::amount, BigInt::$plus)));
        }
    }
}

