/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge.config;

import com.kotori316.fluidtank.config.ConfigData;
import com.kotori316.fluidtank.config.ConfigData$;
import com.kotori316.fluidtank.tank.Tier;
import java.io.Serializable;
import java.util.Locale;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.jdk.javaapi.FunctionConverters$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.util.Try$;

public class FluidTankConfig {
    private final ModConfigSpec.Builder builder;
    private final ModConfigSpec.DoubleValue renderLowerBound;
    private final ModConfigSpec.DoubleValue renderUpperBound;
    private final Map<Tier, ModConfigSpec.ConfigValue<String>> capacities;
    private final ModConfigSpec.BooleanValue debug;
    private final ModConfigSpec.BooleanValue changeItemInCreative;

    public FluidTankConfig(ModConfigSpec.Builder builder) {
        this.builder = builder;
        builder.push("client");
        this.renderLowerBound = builder.comment("The lower bound of tank renderer").comment("Default: " + ConfigData$.MODULE$.DEFAULT().renderLowerBound()).defineInRange("renderLowerBound", ConfigData$.MODULE$.DEFAULT().renderLowerBound(), 0.0, 1.0);
        this.renderUpperBound = builder.comment("The upper bound of tank renderer").comment("Default: " + ConfigData$.MODULE$.DEFAULT().renderUpperBound()).defineInRange("renderUpperBound", ConfigData$.MODULE$.DEFAULT().renderUpperBound(), 0.0, 1.0);
        builder.pop();
        builder.push("tank");
        builder.comment(new String[]{"The capacity of each tanks", "Unit is fabric one, 81000 unit is 1000 mB."}).push("capacity");
        Object object = Predef$.MODULE$.refArrayOps((Object[])Tier.values());
        this.capacities = ((IterableOnceOps)ArrayOps$.MODULE$.toSeq$extension(object).map((Function1 & Serializable)t -> {
            BigInt defaultCapacity = (BigInt)ConfigData$.MODULE$.DEFAULT().capacityMap().apply((Object)t);
            Tier tier = (Tier)((Object)((Object)Predef$.MODULE$.ArrowAssoc((Object)t)));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tier, (Object)builder.comment(new String[]{"Capacity of " + t, "Default: " + defaultCapacity + " unit(= " + defaultCapacity.$div(BigInt$.MODULE$.int2bigInt(81)) + " mB)"}).define(t.name().toLowerCase(Locale.ROOT), (Object)defaultCapacity.toString(), FunctionConverters$.MODULE$.asJavaPredicate((Function1 & Serializable)x$1 -> {
                Object object = x$1;
                if (object instanceof String) {
                    String string;
                    String s = string = (String)object;
                    return Predef$.MODULE$.boolean2Boolean(Try$.MODULE$.apply(() -> FluidTankConfig.$init$$$anonfun$1$$anonfun$1$$anonfun$1(s)).isSuccess());
                }
                return Predef$.MODULE$.boolean2Boolean(false);
            })));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        builder.pop();
        this.debug = builder.comment("Debug mode").comment("Default: " + (ConfigData$.MODULE$.DEFAULT().debug() || !FMLEnvironment.isProduction())).define("debug", ConfigData$.MODULE$.DEFAULT().debug() || !FMLEnvironment.isProduction());
        this.changeItemInCreative = builder.comment("True to allow to modify items in player attracting").comment("Default: " + ConfigData$.MODULE$.DEFAULT().changeItemInCreative()).define("changeItemInCreative", ConfigData$.MODULE$.DEFAULT().changeItemInCreative());
        builder.pop();
    }

    public ConfigData createConfigData() {
        return ConfigData$.MODULE$.apply((Map<Tier, BigInt>)((Map)this.capacities.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tier tier = (Tier)((Object)((Object)tuple2._1()));
                ModConfigSpec.ConfigValue value = (ModConfigSpec.ConfigValue)tuple2._2();
                Tier tier2 = (Tier)((Object)((Object)Predef$.MODULE$.ArrowAssoc((Object)tier)));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tier2, (Object)package$.MODULE$.BigInt().apply((String)value.get()));
            }
            throw new MatchError((Object)tuple2);
        })), Predef$.MODULE$.Double2double((Double)this.renderLowerBound.get()), Predef$.MODULE$.Double2double((Double)this.renderUpperBound.get()), Predef$.MODULE$.Boolean2boolean((Boolean)this.debug.get()), Predef$.MODULE$.Boolean2boolean((Boolean)this.changeItemInCreative.get()));
    }

    private static final BigInt $init$$$anonfun$1$$anonfun$1$$anonfun$1(String s$1) {
        return package$.MODULE$.BigInt().apply(s$1);
    }
}

