/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge.fluid;

import cats.Invariant$;
import cats.Monad;
import cats.data.Chain;
import cats.data.IndexedReaderWriterStateT;
import com.kotori316.fluidtank.contents.DefaultTransferEnv$;
import com.kotori316.fluidtank.contents.FluidTransferLog;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.TransferEnv;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.neoforge.fluid.NeoForgeConverter$;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import scala.Int$;
import scala.MatchError;
import scala.Tuple3;

public abstract class TankFluidHandler
implements ResourceHandler<FluidResource> {
    private final ItemAccess context;

    public TankFluidHandler(ItemAccess context) {
        this.context = context;
    }

    public final ItemAccess context() {
        return this.context;
    }

    public abstract Tank<FluidLike> getTank();

    public abstract ItemResource saveTank(Tank<FluidLike> var1);

    public int size() {
        return 1;
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return GenericUnit$.MODULE$.asNeoForge$extension(this.getTank().capacity());
    }

    public FluidResource getResource(int index) {
        return NeoForgeConverter$.MODULE$.asVariant(this.getTank().content());
    }

    public long getAmountAsLong(int index) {
        return GenericUnit$.MODULE$.asNeoForge$extension(this.getTank().content().amount());
    }

    public boolean isValid(int index, FluidResource resource) {
        return true;
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        return this.opInternal(this.getTank().fillOp(), NeoForgeConverter$.MODULE$.toAmount(resource, Int$.MODULE$.int2long(amount)), transaction);
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (this.getTank().isEmpty()) {
            return 0;
        }
        return this.opInternal(this.getTank().drainOp(), NeoForgeConverter$.MODULE$.toAmount(resource, Int$.MODULE$.int2long(amount)), transaction);
    }

    private int opInternal(IndexedReaderWriterStateT<Object, TransferEnv, Chain<FluidTransferLog>, GenericAmount<FluidLike>, GenericAmount<FluidLike>, Tank<FluidLike>> op, GenericAmount<FluidLike> fluid, TransactionContext transaction) {
        Tuple3 tuple3 = (Tuple3)op.run((Object)DefaultTransferEnv$.MODULE$, fluid, (Monad)Invariant$.MODULE$.catsInstancesForId());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Tuple3 $1$ = tuple3;
        Tuple3 tuple32 = $1$;
        GenericAmount rest = (GenericAmount)tuple32._2();
        Tank newTank = (Tank)tuple32._3();
        ItemResource newItem = this.saveTank(newTank);
        if (this.context().exchange(newItem, 1, transaction) == 1) {
            return GenericUnit$.MODULE$.asForge$extension(fluid.amount()) - GenericUnit$.MODULE$.asForge$extension(rest.amount());
        }
        return 0;
    }
}

