/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge.integration.ae2;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import cats.implicits$;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.FluidLikeKey;
import com.kotori316.fluidtank.fluids.FluidLikeKey$;
import com.kotori316.fluidtank.fluids.PotionType;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaFluid$;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.fluids.VanillaPotion$;
import com.kotori316.fluidtank.neoforge.fluid.NeoForgeConverter$;
import com.kotori316.fluidtank.neoforge.integration.ae2.TankMEStorage$;
import com.kotori316.fluidtank.tank.TileTank;
import java.io.Serializable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.hashing.MurmurHash3$;

public class TankMEStorage
implements MEStorage,
Product,
Serializable {
    private final TileTank tank;

    public static TankMEStorage apply(TileTank tileTank) {
        return TankMEStorage$.MODULE$.apply(tileTank);
    }

    public static TankMEStorage fromProduct(Product product) {
        return TankMEStorage$.MODULE$.fromProduct(product);
    }

    public static TankMEStorage unapply(TankMEStorage tankMEStorage) {
        return TankMEStorage$.MODULE$.unapply(tankMEStorage);
    }

    public TankMEStorage(TileTank tank) {
        this.tank = tank;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, 412460639, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        TankMEStorage tankMEStorage;
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TankMEStorage)) return false;
        TankMEStorage tankMEStorage2 = tankMEStorage = (TankMEStorage)object;
        TileTank tileTank = this.tank();
        TileTank tileTank2 = tankMEStorage2.tank();
        if (tileTank == null) {
            if (tileTank2 != null) {
                return false;
            }
        } else if (!((Object)((Object)tileTank)).equals((Object)tileTank2)) return false;
        if (!tankMEStorage2.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TankMEStorage;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "TankMEStorage";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "tank";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public TileTank tank() {
        return this.tank;
    }

    public Component getDescription() {
        return this.tank().getName();
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        AEKey aEKey = what;
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey aEFluidKey;
            AEFluidKey key = aEFluidKey = (AEFluidKey)aEKey;
            FluidLikeKey fluidKey = FluidLikeKey$.MODULE$.from(NeoForgeConverter$.MODULE$.toAmount(key.toStack(1)));
            return this.tank().getConnection().getContent().forall((Function1 & Serializable)c -> implicits$.MODULE$.catsSyntaxEq((Object)FluidLikeKey$.MODULE$.from((GenericAmount<FluidLike>)c), FluidLikeKey$.MODULE$.FluidKeyHash()).$eq$eq$eq((Object)fluidKey));
        }
        return false;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        MEStorage.checkPreconditions((AEKey)what, (long)amount, (Actionable)mode, (IActionSource)source);
        AEKey aEKey = what;
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey aEFluidKey;
            AEFluidKey key = aEFluidKey = (AEFluidKey)aEKey;
            GenericAmount<FluidLike> filled = this.tank().getConnection().getHandler().fill(this.fromAeFluid(key, amount), !mode.isSimulate());
            return Int$.MODULE$.int2long(GenericUnit$.MODULE$.asForge$extension(filled.amount()));
        }
        return 0L;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        MEStorage.checkPreconditions((AEKey)what, (long)amount, (Actionable)mode, (IActionSource)source);
        AEKey aEKey = what;
        if (aEKey instanceof AEFluidKey) {
            AEFluidKey aEFluidKey;
            AEFluidKey key = aEFluidKey = (AEFluidKey)aEKey;
            GenericAmount<FluidLike> drained = this.tank().getConnection().getHandler().drain(this.fromAeFluid(key, amount), !mode.isSimulate());
            return Int$.MODULE$.int2long(GenericUnit$.MODULE$.asForge$extension(drained.amount()));
        }
        return 0L;
    }

    public void getAvailableStacks(KeyCounter out) {
        this.tank().getConnection().getContent().foreach((Function1)(JProcedure1 & Serializable)c -> {
            FluidLike fluidLike = (FluidLike)c.content();
            if (fluidLike instanceof VanillaFluid) {
                Fluid fluid;
                VanillaFluid vanillaFluid = (VanillaFluid)fluidLike;
                VanillaFluid vanillaFluid2 = VanillaFluid$.MODULE$.unapply(vanillaFluid);
                Fluid fluid2 = fluid = vanillaFluid2._1();
                out.add((AEKey)AEFluidKey.of((FluidStack)NeoForgeConverter$.MODULE$.toStack((GenericAmount<FluidLike>)c)), GenericUnit$.MODULE$.asDisplay$extension(c.amount()));
                return;
            }
            if (fluidLike instanceof VanillaPotion) {
                VanillaPotion vanillaPotion = (VanillaPotion)fluidLike;
                VanillaPotion vanillaPotion2 = VanillaPotion$.MODULE$.unapply(vanillaPotion);
                PotionType potionType = vanillaPotion2._1();
                return;
            }
            throw new MatchError((Object)fluidLike);
        });
    }

    private GenericAmount<FluidLike> fromAeFluid(AEFluidKey fluidKey, long amount) {
        return NeoForgeConverter$.MODULE$.toAmount(fluidKey.toStack(1)).setAmount(GenericUnit$.MODULE$.fromForge(amount));
    }

    public TankMEStorage copy(TileTank tank) {
        return new TankMEStorage(tank);
    }

    public TileTank copy$default$1() {
        return this.tank();
    }

    public TileTank _1() {
        return this.tank();
    }
}

