/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge.integration.neoforge;

import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.BucketResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public final class SingleBucketResourceHandler
implements ResourceHandler<FluidResource> {
    private final ItemAccess itemAccess;
    private final BucketResourceHandler internal;

    public SingleBucketResourceHandler(ItemAccess itemAccess) {
        this.itemAccess = itemAccess;
        this.internal = new BucketResourceHandler(itemAccess);
    }

    public int size() {
        return this.internal.size();
    }

    public FluidResource getResource(int index) {
        return (FluidResource)this.internal.getResource(index);
    }

    public long getAmountAsLong(int index) {
        return this.internal.getAmountAsLong(index);
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return this.internal.getCapacityAsLong(index, (Resource)resource);
    }

    public boolean isValid(int index, FluidResource resource) {
        return this.internal.isValid(index, (Resource)resource);
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        ItemResource newBucket;
        int toInsert;
        Objects.checkIndex(index, this.size());
        TransferPreconditions.checkNonEmptyNonNegative((Resource)resource, (int)amount);
        if (this.itemAccess.getAmount() == 0) {
            return 0;
        }
        FluidResource resourceInBucket = this.getResource(index);
        int amountInBucket = this.getAmountAsInt(index);
        if ((amountInBucket == 0 || resourceInBucket.equals((Object)resource)) && this.isValid(index, resource) && (toInsert = Math.min(this.getCapacityAsInt(index, (Resource)resource) - amountInBucket, amount)) > 0 && !(newBucket = this.newBucket(resource, toInsert + amountInBucket)).isEmpty() && this.itemAccess.exchange(newBucket, 1, transaction) == 1) {
            return toInsert;
        }
        return 0;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        int toExtract;
        ItemResource newBucket;
        Objects.checkIndex(index, this.size());
        TransferPreconditions.checkNonEmptyNonNegative((Resource)resource, (int)amount);
        if (this.itemAccess.getAmount() != 1) {
            return 0;
        }
        FluidResource resourceInBucket = this.getResource(index);
        int amountInBucket = this.getAmountAsInt(index);
        if (resourceInBucket.equals((Object)resource) && amountInBucket > 0 && !(newBucket = this.newBucket(resource, amountInBucket - (toExtract = Math.min(amount, amountInBucket)))).isEmpty() && this.itemAccess.exchange(newBucket, 1, transaction) == 1) {
            return toExtract;
        }
        return 0;
    }

    public ItemResource newBucket(FluidResource newResource, int newAmount) {
        if (newAmount == 0) {
            return ItemResource.of((ItemLike)Items.BUCKET);
        }
        if (newAmount != 1000) {
            return ItemResource.EMPTY;
        }
        FluidStack newStack = newResource.toStack(newAmount);
        return ItemResource.of((ItemStack)newStack.getFluidType().getBucket(newStack));
    }
}

