/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge.render;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.FluidLike$;
import com.kotori316.fluidtank.fluids.PotionType;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaFluid$;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.fluids.VanillaPotion$;
import com.kotori316.fluidtank.neoforge.fluid.NeoForgeConverter$;
import com.kotori316.fluidtank.neoforge.render.JavaHelper;
import com.kotori316.fluidtank.render.RenderTank;
import com.kotori316.fluidtank.tank.TileTank;
import java.io.Serializable;
import java.util.Optional;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.textures.FluidSpriteCache;
import net.neoforged.neoforge.fluids.FluidType;
import scala.Function1;
import scala.MatchError;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxesRunTime;

public class RenderTankNeoForge
extends RenderTank {
    public RenderTankNeoForge(BlockEntityRendererProvider.Context d) {
        super(d);
    }

    @Override
    public TextureAtlasSprite getFluidTexture(Tank<FluidLike> tank, TileTank blockEntity) {
        Level world = this.getTankWorld(blockEntity);
        BlockPos pos = this.getTankPos(blockEntity);
        Fluid fluid = FluidLike$.MODULE$.asFluid(tank.content().content(), (Fluid)Fluids.WATER);
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation resource = attributes.getStillTexture(fluid.defaultFluidState(), (BlockAndTintGetter)world, pos);
        return FluidSpriteCache.getSprite((ResourceLocation)resource);
    }

    @Override
    public int getFluidColor(Tank<FluidLike> tank, TileTank blockEntity) {
        GenericAmount<FluidLike> fluidAmount = tank.content();
        FluidLike fluidLike = fluidAmount.content();
        if (fluidLike instanceof VanillaFluid) {
            Fluid fluid;
            VanillaFluid vanillaFluid = (VanillaFluid)fluidLike;
            VanillaFluid vanillaFluid2 = VanillaFluid$.MODULE$.unapply(vanillaFluid);
            Fluid fluid2 = fluid = vanillaFluid2._1();
            IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid2);
            int normal = attributes.getTintColor();
            Class clazz = attributes.getClass();
            Class<FluidType> clazz2 = FluidType.class;
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return normal;
            }
            int stackColor = attributes.getTintColor(NeoForgeConverter$.MODULE$.toStack(fluidAmount));
            if (normal == stackColor) {
                Level world = this.getTankWorld(blockEntity);
                BlockPos pos = this.getTankPos(blockEntity);
                int worldColor = attributes.getTintColor(fluid2.defaultFluidState(), (BlockAndTintGetter)world, pos);
                return worldColor;
            }
            return stackColor;
        }
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion = (VanillaPotion)fluidLike;
            VanillaPotion vanillaPotion2 = VanillaPotion$.MODULE$.unapply(vanillaPotion);
            PotionType potionType = vanillaPotion2._1();
            return BoxesRunTime.unboxToInt((Object)fluidAmount.componentPatch().flatMap((Function1 & Serializable)_$1 -> {
                Optional optional = OptionConverters$.MODULE$.RichOptional(_$1.get(DataComponents.POTION_CONTENTS));
                return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
            }).map((Function1 & Serializable)_$2 -> _$2.getColor()).getOrElse(RenderTankNeoForge::getFluidColor$$anonfun$3));
        }
        throw new MatchError((Object)fluidLike);
    }

    @Override
    public int getLuminance(Tank<FluidLike> tank) {
        return JavaHelper.getLightLevel(tank.content());
    }

    private static final int getFluidColor$$anonfun$3() {
        return 0xF800F8;
    }
}

