/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge.tank;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidConnection;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.neoforge.fluid.NeoForgeConverter$;
import java.io.Serializable;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import scala.Function1;
import scala.Int$;
import scala.runtime.BoxesRunTime;

public class ConnectionHandler
extends SnapshotJournal<GenericAmount<FluidLike>>
implements ResourceHandler<FluidResource> {
    private final FluidConnection connection;

    public ConnectionHandler(FluidConnection connection) {
        this.connection = connection;
    }

    public GenericAmount<FluidLike> createSnapshot() {
        return (GenericAmount)this.connection.getContent().getOrElse(ConnectionHandler::createSnapshot$$anonfun$1);
    }

    public void revertToSnapshot(GenericAmount<FluidLike> snapshot) {
        this.connection.getHandler().set(snapshot);
    }

    public int size() {
        return 1;
    }

    public FluidResource getResource(int i) {
        return (FluidResource)this.connection.getContent().map((Function1 & Serializable)_$1 -> NeoForgeConverter$.MODULE$.asVariant((GenericAmount<FluidLike>)_$1)).getOrElse(ConnectionHandler::getResource$$anonfun$2);
    }

    public long getAmountAsLong(int i) {
        return BoxesRunTime.unboxToLong((Object)this.connection.getContent().map((Function1 & Serializable)_$2 -> GenericUnit$.MODULE$.asNeoForge$extension(_$2.amount())).getOrElse(ConnectionHandler::getAmountAsLong$$anonfun$2));
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return GenericUnit$.MODULE$.asNeoForge$extension(this.connection.capacity());
    }

    public boolean isValid(int index, FluidResource resource) {
        return true;
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        GenericAmount<FluidLike> toFill = NeoForgeConverter$.MODULE$.toAmount(resource, Int$.MODULE$.int2long(amount));
        this.updateSnapshots(transaction);
        GenericAmount<FluidLike> filled = this.connection.getHandler().fill(toFill, true);
        return GenericUnit$.MODULE$.asForge$extension(filled.amount());
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        GenericAmount<FluidLike> toDrain = NeoForgeConverter$.MODULE$.toAmount(resource, Int$.MODULE$.int2long(amount));
        this.updateSnapshots(transaction);
        GenericAmount<FluidLike> drained = this.connection.getHandler().drain(toDrain, true);
        return GenericUnit$.MODULE$.asForge$extension(drained.amount());
    }

    private static final GenericAmount createSnapshot$$anonfun$1() {
        return FluidAmountUtil$.MODULE$.EMPTY();
    }

    private static final FluidResource getResource$$anonfun$2() {
        return FluidResource.EMPTY;
    }

    private static final long getAmountAsLong$$anonfun$2() {
        return 0L;
    }
}

