/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge.tank;

import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.Tank$;
import com.kotori316.fluidtank.contents.TankUtil$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.package$;
import com.kotori316.fluidtank.item.PlatformItemAccess;
import com.kotori316.fluidtank.neoforge.FluidTank;
import com.kotori316.fluidtank.neoforge.fluid.NeoForgeConverter$;
import com.kotori316.fluidtank.neoforge.fluid.TankFluidHandler;
import com.kotori316.fluidtank.tank.Tier;
import java.io.Serializable;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.TagValueOutput;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.VisibleForTesting;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public class TankFluidItemHandler
extends TankFluidHandler {
    private final Tier tier;

    public TankFluidItemHandler(Tier tier, ItemAccess access) {
        this.tier = tier;
        super(access);
    }

    public ItemStack getContainer() {
        return this.context().getResource().toStack();
    }

    @Override
    public Tank<FluidLike> getTank() {
        DataComponentPatch componentPatch = this.getContainer().getComponentsPatch();
        Option maybeTank = Option$.MODULE$.apply((Object)componentPatch.get(DataComponents.BLOCK_ENTITY_DATA)).flatMap((Function1 & Serializable)_$1 -> {
            Optional optional = OptionConverters$.MODULE$.RichOptional(_$1);
            return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
        }).withFilter((Function1 & Serializable)blockEntityData -> blockEntityData.contains("tank")).map((Function1 & Serializable)blockEntityData -> {
            CompoundTag customTag = blockEntityData.copyTagWithoutId();
            return Tuple2$.MODULE$.apply(blockEntityData, (Object)customTag);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TypedEntityData blockEntityData = (TypedEntityData)tuple2._1();
                CompoundTag customTag = (CompoundTag)tuple2._2();
                Optional optional = OptionConverters$.MODULE$.RichOptional(customTag.getCompound("tank"));
                return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional).map((Function1 & Serializable)tankTag -> TankUtil$.MODULE$.load((CompoundTag)tankTag, package$.MODULE$.fluidAccess()));
            }
            throw new MatchError((Object)tuple2);
        });
        return (Tank)maybeTank.getOrElse(this::getTank$$anonfun$1);
    }

    @Override
    public ItemResource saveTank(Tank<FluidLike> tank) {
        ItemStack stack = this.getContainer();
        if (tank.isEmpty()) {
            v0 = stack.remove(DataComponents.BLOCK_ENTITY_DATA);
        } else {
            TagValueOutput tagValueOutput = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            CompoundTag tag = (CompoundTag)Option$.MODULE$.apply((Object)stack.getComponentsPatch().get(DataComponents.BLOCK_ENTITY_DATA)).flatMap((Function1 & Serializable)_$2 -> {
                Optional optional = OptionConverters$.MODULE$.RichOptional(_$2);
                return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
            }).map((Function1 & Serializable)_$3 -> _$3.copyTagWithoutId()).getOrElse(TankFluidItemHandler::$anonfun$7);
            tagValueOutput.store(tag);
            tagValueOutput.store("tank", Tank$.MODULE$.codec(package$.MODULE$.fluidAccess()), tank);
            tagValueOutput.putString("tier", this.tier.name());
            PlatformItemAccess.setTileTag(stack, tagValueOutput, (BlockEntityType)FluidTank.TILE_TANK_TYPE.get());
            v0 = BoxedUnit.UNIT;
        }
        return ItemResource.of((ItemStack)stack);
    }

    @VisibleForTesting
    public void fill(GenericAmount<FluidLike> fill, boolean execute) {
        Using$.MODULE$.resource((Object)Transaction.openRoot(), (Function1)(JProcedure1 & Serializable)tx -> {
            this.insert((Resource)NeoForgeConverter$.MODULE$.asVariant(fill), GenericUnit$.MODULE$.asForge$extension(fill.amount()), (TransactionContext)tx);
            if (execute) {
                tx.commit();
                return;
            }
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public boolean fill$default$2() {
        return true;
    }

    @VisibleForTesting
    public void setTank(Tank<FluidLike> tank) {
        ItemResource savedStack = this.saveTank(tank);
        Using$.MODULE$.resource((Object)Transaction.openRoot(), (Function1)(JProcedure1 & Serializable)tx -> {
            this.context().exchange(savedStack, this.context().getAmount(), (TransactionContext)tx);
            tx.commit();
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private final Tank getTank$$anonfun$1() {
        return Tank$.MODULE$.apply(FluidAmountUtil$.MODULE$.EMPTY(), GenericUnit$.MODULE$.apply(this.tier.getCapacity()));
    }

    private static final CompoundTag $anonfun$7() {
        return new CompoundTag();
    }
}

