/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.neoforge.tank;

import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidConnection;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.neoforge.message.FluidTankContentMessageNeoForge;
import com.kotori316.fluidtank.neoforge.message.PacketHandler;
import com.kotori316.fluidtank.neoforge.tank.ConnectionHandler;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileTank;
import com.kotori316.fluidtank.tank.VisualTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TileTankNeoForge
extends TileTank {
    @NotNull
    private ResourceHandler<FluidResource> fluidHandler = this.createHandler();
    private final VisualTank visualTank = new VisualTank();

    public TileTankNeoForge(Tier tier, BlockPos p, BlockState s) {
        super(tier, p, s);
    }

    public TileTankNeoForge(BlockPos p, BlockState s) {
        super(p, s);
    }

    @Override
    public void setConnection(FluidConnection c) {
        super.setConnection(c);
        this.invalidateCapabilities();
        this.fluidHandler = this.createHandler();
    }

    @Override
    public void setTank(Tank<FluidLike> tank) {
        super.setTank(tank);
        if (this.level != null && !this.level.isClientSide()) {
            PacketHandler.sendToClient(new FluidTankContentMessageNeoForge(this), this.level);
        } else {
            this.visualTank.updateContent(tank.capacity(), tank.amount(), tank.content().isGaseous());
        }
    }

    @Override
    public VisualTank getVisualTank() {
        return this.visualTank;
    }

    @NotNull
    public ResourceHandler<FluidResource> getCapability(@Nullable Direction ignored) {
        return this.fluidHandler;
    }

    @NotNull
    private ResourceHandler<FluidResource> createHandler() {
        return new ConnectionHandler(this.getConnection());
    }
}

