/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.recipe;

import com.kotori316.fluidtank.DebugLogging;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.TankUtil;
import com.kotori316.fluidtank.fluids.FluidAmountUtil;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.FluidLikeKey;
import com.kotori316.fluidtank.item.PlatformItemAccess;
import com.kotori316.fluidtank.tank.BlockTank;
import com.kotori316.fluidtank.tank.ItemBlockTank;
import com.kotori316.fluidtank.tank.PlatformTankAccess;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileTank;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import org.apache.logging.log4j.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TierRecipe
implements CraftingRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(TierRecipe.class);
    public static final Serializer SERIALIZER = new Serializer();
    final Tier tier;
    final Ingredient tankItem;
    final Ingredient subItem;
    final ItemStack result;
    final ShapedRecipePattern pattern;
    final Lazy<PlacementInfo> placementInfo;
    public static final String KEY_TIER = "tier";
    public static final String KEY_SUB_ITEM = "sub_item";

    public TierRecipe(Tier tier, Ingredient tankItem, Ingredient subItem) {
        this.tier = tier;
        this.tankItem = tankItem;
        this.subItem = subItem;
        this.result = new ItemStack((ItemLike)PlatformTankAccess.getInstance().getTankBlockMap().get((Object)tier).get());
        this.pattern = ShapedRecipePattern.of(Map.of(Character.valueOf('t'), tankItem, Character.valueOf('s'), subItem), List.of("tst", "s s", "tst"));
        this.placementInfo = Lazy.lazy(() -> PlacementInfo.createFromOptionals((List)this.pattern.ingredients()));
        DebugLogging.LOGGER().debug("{} instance created for Tier {}({}).", (Object)this.getClass().getSimpleName(), (Object)tier, (Object)this.result);
    }

    public boolean matches(CraftingInput input, @Nullable Level worldIn) {
        if (!this.pattern.matches(input)) {
            return false;
        }
        List tankStacks = input.items().stream().filter(this.tankItem).toList();
        return tankStacks.size() == 4 && tankStacks.stream().map(s -> (TypedEntityData)s.get(DataComponents.BLOCK_ENTITY_DATA)).filter(Objects::nonNull).map(TypedEntityData::copyTagWithoutId).flatMap(n -> n.getCompound(TileTank.KEY_TANK()).stream()).map(nbt -> TankUtil.load(nbt, FluidAmountUtil.access())).map(Tank::content).filter(GenericAmount::nonEmpty).map(FluidLikeKey::from).distinct().count() <= 1L;
    }

    @NotNull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        if (!this.matches(inv, null)) {
            List stacks = inv.items();
            LOGGER.error("Requested to return crafting result for invalid inventory. {}", (Object)stacks);
            DebugLogging.LOGGER().error("Requested to return crafting result for invalid inventory. {}", (Object)stacks);
            return ItemStack.EMPTY;
        }
        ItemStack result = this.result.copy();
        GenericAmount<FluidLike> fluidAmount = IntStream.range(0, inv.size()).mapToObj(arg_0 -> ((CraftingInput)inv).getItem(arg_0)).filter(s -> s.getItem() instanceof ItemBlockTank).map(s -> (TypedEntityData)s.get(DataComponents.BLOCK_ENTITY_DATA)).filter(Objects::nonNull).map(TypedEntityData::copyTagWithoutId).flatMap(n -> n.getCompound(TileTank.KEY_TANK()).stream()).map(nbt -> TankUtil.load(nbt, FluidAmountUtil.access())).map(Tank::content).filter(GenericAmount::nonEmpty).reduce(GenericAmount::add).orElse(FluidAmountUtil.EMPTY());
        if (fluidAmount.nonEmpty()) {
            try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(LOGGER);){
                TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)reporter, (HolderLookup.Provider)access);
                Tank<FluidLike> tank = new Tank<FluidLike>(fluidAmount, GenericUnit.apply(this.tier.getCapacity()));
                tagValueOutput.store(TileTank.KEY_TANK(), Tank.codec(FluidAmountUtil.access()), tank);
                tagValueOutput.putString(TileTank.KEY_TIER(), this.tier.name());
                PlatformItemAccess.setTileTag(result, tagValueOutput, PlatformTankAccess.getInstance().getNormalType());
            }
        }
        return result;
    }

    @NotNull
    public RecipeSerializer<TierRecipe> getSerializer() {
        return SERIALIZER;
    }

    public PlacementInfo placementInfo() {
        return (PlacementInfo)this.placementInfo.get();
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapedCraftingRecipeDisplay(this.pattern.width(), this.pattern.height(), this.pattern.ingredients().stream().map(optional -> optional.map(Ingredient::display).orElse((SlotDisplay)SlotDisplay.Empty.INSTANCE)).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        return IntStream.range(0, inv.size()).mapToObj(arg_0 -> ((CraftingInput)inv).getItem(arg_0)).map(stack -> {
            if (stack.getItem() instanceof ItemBlockTank) {
                return ItemStack.EMPTY;
            }
            return PlatformItemAccess.getInstance().getCraftingRemainingItem((ItemStack)stack);
        }).collect(Collectors.toCollection(NonNullList::create));
    }

    public Tier getTier() {
        return this.tier;
    }

    private Ingredient getSubItem() {
        return this.subItem;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    @NotNull
    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public static final class Serializer
    implements RecipeSerializer<TierRecipe> {
        public static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fluidtank", (String)"crafting_grade_up");
        private final MapCodec<TierRecipe> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.xmap(Tier::valueOfIgnoreCase, Enum::name).fieldOf(TierRecipe.KEY_TIER).forGetter(TierRecipe::getTier), (App)Ingredient.CODEC.fieldOf(TierRecipe.KEY_SUB_ITEM).forGetter(TierRecipe::getSubItem)).apply((Applicative)instance, this::createInstanceInternal));
        private final StreamCodec<RegistryFriendlyByteBuf, TierRecipe> streamCodec = StreamCodec.ofMember(this::toNetwork, this::fromNetwork);

        private TierRecipe createInstance(Tier tier, Ingredient tankItem, Ingredient subItem) {
            return new TierRecipe(tier, tankItem, subItem);
        }

        private TierRecipe createInstanceInternal(Tier tier, Ingredient subItem) {
            return this.createInstance(tier, Serializer.getIngredientTankForTier(tier), subItem);
        }

        @NotNull
        public MapCodec<TierRecipe> codec() {
            return this.codec;
        }

        @Deprecated
        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, TierRecipe> streamCodec() {
            return this.streamCodec;
        }

        public TierRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String tierName = buffer.readUtf();
            Tier tier = Tier.valueOf(tierName);
            Ingredient tankItem = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient subItem = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            DebugLogging.LOGGER().debug("Serializer loaded from packet for tier {}, sub {}.", (Object)tier, (Object)PlatformItemAccess.convertIngredientToString(subItem));
            return this.createInstance(tier, tankItem, subItem);
        }

        public void toNetwork(TierRecipe recipe, RegistryFriendlyByteBuf buffer) {
            buffer.writeUtf(recipe.tier.name());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.tankItem);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.subItem);
            DebugLogging.LOGGER().debug("Serialized to packet for tier {}.", (Object)recipe.tier);
        }

        public static Ingredient getIngredientTankForTier(Tier tier) {
            return Ingredient.of(Serializer.getTankForTier(tier));
        }

        public static Stream<? extends BlockTank> getTankForTier(Tier tier) {
            Stream<Tier> targetTiers = Stream.of(Tier.values()).filter(t -> t.getRank() == tier.getRank() - 1);
            return targetTiers.map(PlatformTankAccess.getInstance().getTankBlockMap()::get).map(Supplier::get);
        }
    }
}

