/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.recipe;

import com.kotori316.fluidtank.recipe.TierRecipe;
import com.kotori316.fluidtank.tank.Tier;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public final class TierRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category = RecipeCategory.DECORATIONS;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private final TierRecipe recipe;

    public TierRecipeBuilder(Tier tier, Ingredient tankItem, Ingredient subItem) {
        this.recipe = new TierRecipe(tier, tankItem, subItem);
    }

    public TierRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public TierRecipeBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return this.recipe.result.getItem();
    }

    public void save(RecipeOutput recipeOutput, ResourceKey<Recipe<?>> id) {
        Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(id)).rewards(AdvancementRewards.Builder.recipe(id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        recipeOutput.accept(id, (Recipe)this.recipe, builder.build(id.location().withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }
}

