/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.render;

import com.kotori316.fluidtank.render.FluidRenderHelper;
import com.kotori316.fluidtank.render.RenderItemTank;
import com.kotori316.fluidtank.render.RenderReservoirItem;
import com.kotori316.fluidtank.render.ReservoirModel;
import com.kotori316.fluidtank.render.TankModel;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class RenderItemCodecs {
    public static final ResourceLocation RESERVOIR_MODEL = ResourceLocation.fromNamespaceAndPath((String)"fluidtank", (String)"reservoir");
    public static final ResourceLocation TANK_MODEL = ResourceLocation.fromNamespaceAndPath((String)"fluidtank", (String)"tank");

    public static SpecialModelRenderer.Unbaked reservoirModelUnbaked(FluidRenderHelper helper) {
        return new RenderReservoirItemUnbaked(helper);
    }

    public static SpecialModelRenderer.Unbaked tankModelUnbaked(FluidRenderHelper helper) {
        return new RenderTankItemUnbaked(helper);
    }

    public static void registerSpecialModelRenderersCodec(FluidRenderHelper helper, BiConsumer<ResourceLocation, MapCodec<? extends SpecialModelRenderer.Unbaked>> registerFunction, Map<ResourceLocation, SpecialModelRenderer.Unbaked> predefined) {
        SpecialModelRenderer.Unbaked unbaked = predefined.getOrDefault(RESERVOIR_MODEL, RenderItemCodecs.reservoirModelUnbaked(helper));
        registerFunction.accept(RESERVOIR_MODEL, (MapCodec<? extends SpecialModelRenderer.Unbaked>)unbaked.type());
        unbaked = predefined.getOrDefault(TANK_MODEL, RenderItemCodecs.tankModelUnbaked(helper));
        registerFunction.accept(TANK_MODEL, (MapCodec<? extends SpecialModelRenderer.Unbaked>)unbaked.type());
    }

    public static <T> void registerLayerDefinitions(BiConsumer<ModelLayerLocation, T> registerFunction, Function<Supplier<LayerDefinition>, T> converter) {
        Map<ModelLayerLocation, Supplier<LayerDefinition>> map = Map.of(ReservoirModel.LOCATION, ReservoirModel::createDefinition, TankModel.LOCATION, TankModel::createDefinition);
        map.forEach((modelLayer, supplier) -> registerFunction.accept((ModelLayerLocation)modelLayer, (Object)converter.apply((Supplier<LayerDefinition>)supplier)));
    }

    private static class RenderReservoirItemUnbaked
    implements SpecialModelRenderer.Unbaked {
        private final FluidRenderHelper helper;
        private final MapCodec<RenderReservoirItemUnbaked> codec;

        public RenderReservoirItemUnbaked(FluidRenderHelper helper) {
            this.helper = helper;
            this.codec = MapCodec.unit(() -> new RenderReservoirItemUnbaked(helper));
        }

        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
            ReservoirModel model = new ReservoirModel(context.entityModelSet().bakeLayer(ReservoirModel.LOCATION));
            return new RenderReservoirItem(model, context.materials(), this.helper);
        }

        @NotNull
        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return this.codec;
        }
    }

    private static class RenderTankItemUnbaked
    implements SpecialModelRenderer.Unbaked {
        private final FluidRenderHelper helper;
        private final MapCodec<RenderTankItemUnbaked> codec;

        public RenderTankItemUnbaked(FluidRenderHelper helper) {
            this.helper = helper;
            this.codec = MapCodec.unit(() -> new RenderTankItemUnbaked(helper));
        }

        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
            TankModel model = new TankModel(context.entityModelSet().bakeLayer(TankModel.LOCATION));
            return new RenderItemTank(model, this.helper);
        }

        @NotNull
        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return this.codec;
        }
    }
}

