/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.render;

import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.render.FluidRenderHelper;
import com.kotori316.fluidtank.render.RenderItemTank$RenderContext$;
import com.kotori316.fluidtank.render.TankModel;
import com.kotori316.fluidtank.render.TankRenderState;
import com.kotori316.fluidtank.tank.ItemBlockTank;
import com.kotori316.fluidtank.tank.PlatformTankAccess;
import com.kotori316.fluidtank.tank.Tier;
import com.kotori316.fluidtank.tank.TileTank;
import com.kotori316.fluidtank.tank.VisualTank;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import org.joml.Vector3f;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.hashing.MurmurHash3$;

public class RenderItemTank
implements SpecialModelRenderer<RenderContext> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RenderItemTank.class.getDeclaredField("tileTank$lzy1"));
    private final TankModel model;
    private volatile Object tileTank$lzy1;

    public RenderItemTank(TankModel model, FluidRenderHelper renderHelper) {
        this.model = model;
    }

    private TileTank tileTank() {
        Object object = this.tileTank$lzy1;
        if (object instanceof TileTank) {
            return (TileTank)((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (TileTank)((Object)this.tileTank$lzyINIT1());
    }

    private Object tileTank$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.tileTank$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    TileTankForRender tileTankForRender = null;
                    try {
                        tileTankForRender = new TileTankForRender();
                        object2 = tileTankForRender == null ? LazyVals.NullValue$.MODULE$ : tileTankForRender;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.tileTank$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return tileTankForRender;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void submit(RenderContext patterns, ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
        ResourceLocation textureLocation = ResourceLocation.fromNamespaceAndPath((String)"fluidtank", (String)("textures/block/" + patterns.tier().toString() + ".png").toLowerCase(Locale.ROOT));
        nodeCollector.submitModel((Model)this.model, (Object)Unit.INSTANCE, poseStack, this.model.renderType(textureLocation), packedLight, packedOverlay, outlineColor, null);
        this.tileTank().tier_$eq(patterns.tier());
        patterns.data().withFilter((Function1 & Serializable)d -> !d.isEmpty()).foreach((Function1)(JProcedure1 & Serializable)d -> {
            ClientLevel level = Minecraft.getInstance().level;
            this.tileTank().setLevel((Level)level);
            this.tileTank().loadAdditional(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)d));
            if (this.tileTank().getTank().hasContent()) {
                TankRenderState stateForTile = (TankRenderState)Minecraft.getInstance().getBlockEntityRenderDispatcher().tryExtractRenderState((BlockEntity)this.tileTank(), 0.0f, null);
                Minecraft.getInstance().getBlockEntityRenderDispatcher().submit((BlockEntityRenderState)stateForTile, poseStack, nodeCollector, new CameraRenderState());
                return;
            }
        });
    }

    public void getExtents(Set<Vector3f> output) {
        PoseStack pose = new PoseStack();
        pose.translate(0.5f, 0.0f, 0.5f);
        pose.scale(-1.0f, -1.0f, 1.0f);
        this.model.root().getExtentsForGui(pose, output);
    }

    public RenderContext extractArgument(ItemStack stack) {
        return RenderItemTank$RenderContext$.MODULE$.apply(((ItemBlockTank)stack.getItem()).blockTank().tier(), (Option<CompoundTag>)Option$.MODULE$.apply(stack.get(DataComponents.BLOCK_ENTITY_DATA)).map((Function1 & Serializable)_$1 -> _$1.copyTagWithoutId()));
    }

    public static class RenderContext
    implements Product,
    Serializable {
        private final Tier tier;
        private final Option<CompoundTag> data;

        public static RenderContext apply(Tier tier, Option<CompoundTag> option) {
            return RenderItemTank$RenderContext$.MODULE$.apply(tier, option);
        }

        public static RenderContext fromProduct(Product product) {
            return RenderItemTank$RenderContext$.MODULE$.fromProduct(product);
        }

        public static RenderContext unapply(RenderContext renderContext) {
            return RenderItemTank$RenderContext$.MODULE$.unapply(renderContext);
        }

        public RenderContext(Tier tier, Option<CompoundTag> data) {
            this.tier = tier;
            this.data = data;
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, 68785684, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            RenderContext renderContext;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RenderContext)) return false;
            RenderContext renderContext2 = renderContext = (RenderContext)object;
            Tier tier = this.tier();
            Tier tier2 = renderContext2.tier();
            if (tier == null) {
                if (tier2 != null) {
                    return false;
                }
            } else if (!((Object)((Object)tier)).equals((Object)tier2)) return false;
            Option<CompoundTag> option = this.data();
            Option<CompoundTag> option2 = renderContext2.data();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!renderContext2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RenderContext;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RenderContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tier";
            }
            if (1 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Tier tier() {
            return this.tier;
        }

        public Option<CompoundTag> data() {
            return this.data;
        }

        public RenderContext copy(Tier tier, Option<CompoundTag> data) {
            return new RenderContext(tier, data);
        }

        public Tier copy$default$1() {
            return this.tier();
        }

        public Option<CompoundTag> copy$default$2() {
            return this.data();
        }

        public Tier _1() {
            return this.tier();
        }

        public Option<CompoundTag> _2() {
            return this.data();
        }
    }

    public static class TileTankForRender
    extends TileTank {
        private final VisualTank getVisualTank = new VisualTank();

        public TileTankForRender() {
            super(BlockPos.ZERO, ((Block)PlatformTankAccess.getInstance().getTankBlockMap().get((Object)Tier.WOOD).get()).defaultBlockState());
        }

        @Override
        public VisualTank getVisualTank() {
            return this.getVisualTank;
        }

        @Override
        public void setTank(Tank<FluidLike> tank) {
            super.setTank(tank);
            this.getVisualTank().updateContent(tank.capacity(), tank.amount(), tank.content().isGaseous());
        }

        public BlockPos getBlockPos() {
            return Minecraft.getInstance().player.blockPosition();
        }
    }
}

