/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.render;

import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.render.Box;
import com.kotori316.fluidtank.render.Box$;
import com.kotori316.fluidtank.render.FluidRenderHelper;
import com.kotori316.fluidtank.render.RenderReservoirItem$;
import com.kotori316.fluidtank.render.RenderReservoirItem$RenderContext$;
import com.kotori316.fluidtank.render.ReservoirModel;
import com.kotori316.fluidtank.reservoir.ItemReservoir;
import com.kotori316.fluidtank.tank.Tier;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.Serializable;
import java.util.Set;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class RenderReservoirItem
implements SpecialModelRenderer<RenderContext> {
    private final ReservoirModel model;
    private final MaterialSet materialSet;
    private final FluidRenderHelper renderHelper;

    public RenderReservoirItem(ReservoirModel model, MaterialSet materialSet, FluidRenderHelper renderHelper) {
        this.model = model;
        this.materialSet = materialSet;
        this.renderHelper = renderHelper;
    }

    public ReservoirModel model() {
        return this.model;
    }

    public MaterialSet materialSet() {
        return this.materialSet;
    }

    public void submit(RenderContext patterns, ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, boolean hasFoilType, int outlineColor) {
        poseStack.pushPose();
        poseStack.scale(1.0f, 1.0f, 1.0f);
        poseStack.translate(0.0f, 0.0f, 0.5f);
        nodeCollector.submitModel((Model)this.model(), (Object)Unit.INSTANCE, poseStack, this.model().renderType((ResourceLocation)RenderReservoirItem$.com$kotori316$fluidtank$render$RenderReservoirItem$$$textureNameMap.apply((Object)patterns.tier())), packedLight, packedOverlay, outlineColor, null);
        Tank<FluidLike> tank = patterns.tank();
        if (tank.hasContent()) {
            double ratio = Mth.clamp((double)(GenericUnit$.MODULE$.asForgeDouble$extension(tank.content().amount()) / GenericUnit$.MODULE$.asForgeDouble$extension(tank.capacity())), (double)0.1, (double)1.0);
            Tuple2.mcDD.sp sp2 = tank.content().isGaseous() ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(1.0 - ratio)), (Object)BoxesRunTime.boxToDouble((double)1.0)) : new Tuple2.mcDD.sp(0.0, ratio);
            double minY = sp2._1$mcD$sp();
            double maxY = sp2._2$mcD$sp();
            Box box = Box$.MODULE$.apply(0.5, minY, 0.03125, 0.5, maxY, 0.03125, 0.74375, maxY - minY, 0.061875, false, false);
            TextureAtlasSprite texture = this.renderHelper.getFluidTexture(tank, this.materialSet());
            int color = this.renderHelper.getFluidColor(tank);
            int alpha = (color >> 24 & 0xFF) > 0 ? color >> 24 & 0xFF : 255;
            nodeCollector.submitCustomGeometry(poseStack, RenderType.translucentMovingBlock(), (pose, buffer) -> box.render(buffer, pose, texture, alpha, color >> 16 & 0xFF, color >> 8 & 0xFF, color >> 0 & 0xFF, Box$.MODULE$.lightValue()));
        }
        poseStack.popPose();
    }

    public void getExtents(Set<Vector3f> output) {
        PoseStack pose = new PoseStack();
        pose.translate(0.5f, 0.0f, 0.5f);
        pose.scale(-1.0f, -1.0f, 1.0f);
        this.model().root().getExtentsForGui(pose, output);
    }

    public RenderContext extractArgument(ItemStack stack) {
        ItemReservoir reservoir = (ItemReservoir)stack.getItem();
        Tank<FluidLike> tank = reservoir.getTank(stack);
        return RenderReservoirItem$RenderContext$.MODULE$.apply(reservoir.tier(), stack.hasFoil(), tank);
    }

    public static class RenderContext
    implements Product,
    Serializable {
        private final Tier tier;
        private final boolean hasFoil;
        private final Tank<FluidLike> tank;

        public static RenderContext apply(Tier tier, boolean bl, Tank<FluidLike> tank) {
            return RenderReservoirItem$RenderContext$.MODULE$.apply(tier, bl, tank);
        }

        public static RenderContext fromProduct(Product product) {
            return RenderReservoirItem$RenderContext$.MODULE$.fromProduct(product);
        }

        public static RenderContext unapply(RenderContext renderContext) {
            return RenderReservoirItem$RenderContext$.MODULE$.unapply(renderContext);
        }

        public RenderContext(Tier tier, boolean hasFoil, Tank<FluidLike> tank) {
            this.tier = tier;
            this.hasFoil = hasFoil;
            this.tank = tank;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)859367193);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)((Object)this.tier())));
            n = Statics.mix((int)n, (int)(this.hasFoil() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.tank()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            RenderContext renderContext;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RenderContext)) return false;
            RenderContext renderContext2 = renderContext = (RenderContext)object;
            if (this.hasFoil() != renderContext2.hasFoil()) return false;
            Tier tier = this.tier();
            Tier tier2 = renderContext2.tier();
            if (tier == null) {
                if (tier2 != null) {
                    return false;
                }
            } else if (!((Object)((Object)tier)).equals((Object)tier2)) return false;
            Tank<FluidLike> tank = this.tank();
            Tank<FluidLike> tank2 = renderContext2.tank();
            if (tank == null) {
                if (tank2 != null) {
                    return false;
                }
            } else if (!((Object)tank).equals(tank2)) return false;
            if (!renderContext2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RenderContext;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "RenderContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "tier";
                }
                case 1: {
                    return "hasFoil";
                }
                case 2: {
                    return "tank";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Tier tier() {
            return this.tier;
        }

        public boolean hasFoil() {
            return this.hasFoil;
        }

        public Tank<FluidLike> tank() {
            return this.tank;
        }

        public RenderContext copy(Tier tier, boolean hasFoil, Tank<FluidLike> tank) {
            return new RenderContext(tier, hasFoil, tank);
        }

        public Tier copy$default$1() {
            return this.tier();
        }

        public boolean copy$default$2() {
            return this.hasFoil();
        }

        public Tank<FluidLike> copy$default$3() {
            return this.tank();
        }

        public Tier _1() {
            return this.tier();
        }

        public boolean _2() {
            return this.hasFoil();
        }

        public Tank<FluidLike> _3() {
            return this.tank();
        }
    }
}

