/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.render;

import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.render.Box;
import com.kotori316.fluidtank.render.Box$LightValue$;
import com.kotori316.fluidtank.render.TankRenderState;
import com.kotori316.fluidtank.tank.TileTank;
import com.kotori316.fluidtank.tank.VisualTank;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public abstract class RenderTank
implements BlockEntityRenderer<TileTank, TankRenderState> {
    private final BlockEntityRendererProvider.Context context;

    public RenderTank(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public BlockEntityRendererProvider.Context context() {
        return this.context;
    }

    public final void submit(TankRenderState renderState, PoseStack matrix, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("RenderTank");
        if (!renderState.tank.isEmpty()) {
            profiler.push("Rendering");
            matrix.pushPose();
            VisualTank tank = renderState.visualTank;
            if (tank.box() != null) {
                TextureAtlasSprite texture = this.getFluidTexture(renderState.tank, renderState.tileTank);
                int color = this.getFluidColor(renderState.tank, renderState.tileTank);
                Box.LightValue value = Box$LightValue$.MODULE$.apply(renderState.lightCoords).overrideBlock(this.getLuminance(renderState.tank));
                int alpha = (color >> 24 & 0xFF) > 0 ? color >> 24 & 0xFF : 255;
                nodeCollector.submitCustomGeometry(matrix, RenderType.translucentMovingBlock(), (pose, buffer) -> tank.box().render(buffer, pose, texture, alpha, color >> 16 & 0xFF, color >> 8 & 0xFF, color >> 0 & 0xFF, value));
            }
            matrix.popPose();
            profiler.pop();
        }
        profiler.pop();
    }

    public TankRenderState createRenderState() {
        return new TankRenderState();
    }

    public void extractRenderState(TileTank blockEntity, TankRenderState renderState, float partialTick, Vec3 cameraPosition, ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.extract(blockEntity);
    }

    public abstract TextureAtlasSprite getFluidTexture(Tank<FluidLike> var1, TileTank var2);

    public abstract int getFluidColor(Tank<FluidLike> var1, TileTank var2);

    public abstract int getLuminance(Tank<FluidLike> var1);

    public final Level getTankWorld(TileTank tileTank) {
        if (tileTank.hasLevel()) {
            return tileTank.getLevel();
        }
        return Minecraft.getInstance().level;
    }

    public final BlockPos getTankPos(TileTank tileTank) {
        if (tileTank.hasLevel()) {
            return tileTank.getBlockPos();
        }
        return Minecraft.getInstance().player.getOnPos();
    }
}

