/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.fluidtank.reservoir;

import cats.implicits$;
import com.kotori316.fluidtank.contents.GenericAmount;
import com.kotori316.fluidtank.contents.GenericUnit;
import com.kotori316.fluidtank.contents.GenericUnit$;
import com.kotori316.fluidtank.contents.Tank;
import com.kotori316.fluidtank.contents.Tank$;
import com.kotori316.fluidtank.fluids.FluidAmountUtil$;
import com.kotori316.fluidtank.fluids.FluidLike;
import com.kotori316.fluidtank.fluids.PlatformFluidAccess;
import com.kotori316.fluidtank.fluids.PotionType;
import com.kotori316.fluidtank.fluids.VanillaFluid;
import com.kotori316.fluidtank.fluids.VanillaPotion;
import com.kotori316.fluidtank.item.PlatformItemAccess;
import com.kotori316.fluidtank.tank.Tier;
import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import scala.Function1;
import scala.Option$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class ItemReservoir
extends Item {
    private final Tier tier;

    public ItemReservoir(Tier tier) {
        this.tier = tier;
        super(new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fluidtank", (String)("reservoir_" + tier.name().toLowerCase(Locale.ROOT))))));
    }

    public Tier tier() {
        return this.tier;
    }

    public String toString() {
        return "ItemReservoir(" + this.tier().name().toLowerCase(Locale.ROOT) + ")";
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        FluidLike fluidLike = this.getTank(stack).content().content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion;
            VanillaPotion v = vanillaPotion = (VanillaPotion)fluidLike;
            PotionType potionType = v.potionType();
            PotionType potionType2 = PotionType.NORMAL;
            if (!(potionType != null ? !((Object)((Object)potionType)).equals((Object)potionType2) : potionType2 != null)) {
                return ItemUseAnimation.DRINK;
            }
        }
        return super.getUseAnimation(stack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        FluidLike fluidLike = this.getTank(stack).content().content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion;
            VanillaPotion v = vanillaPotion = (VanillaPotion)fluidLike;
            PotionType potionType = v.potionType();
            PotionType potionType2 = PotionType.NORMAL;
            if (!(potionType != null ? !((Object)((Object)potionType)).equals((Object)potionType2) : potionType2 != null)) {
                return 32;
            }
        }
        return super.getUseDuration(stack, entity);
    }

    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        GenericAmount<FluidLike> content = this.getTank(stack).content();
        FluidLike fluidLike = content.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion;
            VanillaPotion v = vanillaPotion = (VanillaPotion)fluidLike;
            PotionType potionType = v.potionType();
            PotionType potionType2 = PotionType.NORMAL;
            if (!(potionType != null ? !((Object)((Object)potionType)).equals((Object)potionType2) : potionType2 != null)) {
                return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
            }
        }
        if (fluidLike instanceof VanillaFluid) {
            VanillaFluid vanillaFluid = (VanillaFluid)fluidLike;
            BlockHitResult hitResult = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            HitResult.Type type = hitResult.getType();
            HitResult.Type type2 = HitResult.Type.BLOCK;
            if (type == null ? type2 != null : !type.equals(type2)) {
                return InteractionResult.PASS;
            }
            return this.fillOrDrainFluidInLevel(hitResult, stack, level, player, content, usedHand);
        }
        return super.use(level, player, usedHand);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        Tank<FluidLike> tank = this.getTank(stack);
        GenericAmount<FluidLike> content = tank.content();
        FluidLike fluidLike = content.content();
        if (fluidLike instanceof VanillaPotion) {
            VanillaPotion vanillaPotion = (VanillaPotion)fluidLike;
            if (content.hasOneBottle()) {
                content.componentPatch().iterator().foreach((Function1)(JProcedure1 & Serializable)patch -> Option$.MODULE$.apply((Object)patch.get(DataComponents.POTION_CONTENTS)).flatMap((Function1 & Serializable)_$1 -> {
                    Optional optional = OptionConverters$.MODULE$.RichOptional(_$1);
                    return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
                }).iterator().foreach((Function1)(JProcedure1 & Serializable)content -> content.applyToLivingEntity(livingEntity, 1.0f)));
                Object object = implicits$.MODULE$.catsSyntaxGroup((Object)new GenericUnit(content.amount()), GenericUnit$.MODULE$.groupGenericUnit()).$bar$minus$bar((Object)new GenericUnit(GenericUnit$.MODULE$.ONE_BOTTLE()));
                Tank<FluidLike> newTank = tank.copy(content.setAmount(object == null ? null : ((GenericUnit)object).value()), tank.copy$default$2());
                this.saveTank(stack, newTank);
                return stack;
            }
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltip, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltip, isAdvanced);
        Tank<FluidLike> tank = this.getTank(stack);
        if (tank.isEmpty()) {
            tooltip.accept((Component)Component.translatable((String)"fluidtank.waila.capacity", (Object[])new Object[]{GenericUnit$.MODULE$.asForgeFromBigInt(this.tier().getCapacity())}));
            return;
        }
        GenericAmount<FluidLike> fluid = tank.content();
        BigInt capacity = tank.capacity();
        tooltip.accept((Component)Component.translatable((String)"fluidtank.waila.short", (Object[])new Object[]{PlatformFluidAccess.getInstance().getDisplayName(fluid), BoxesRunTime.boxToLong((long)GenericUnit$.MODULE$.asDisplay$extension(fluid.amount())), BoxesRunTime.boxToLong((long)GenericUnit$.MODULE$.asDisplay$extension(capacity))}));
    }

    public Tank<FluidLike> getTank(ItemStack stack) {
        return (Tank)stack.getOrDefault(PlatformItemAccess.getInstance().fluidTankComponentType(), Tank$.MODULE$.apply(FluidAmountUtil$.MODULE$.EMPTY(), GenericUnit$.MODULE$.apply(this.tier().getCapacity())));
    }

    public void saveTank(ItemStack stack, Tank<FluidLike> tank) {
        if (tank.isEmpty()) {
            stack.remove(PlatformItemAccess.getInstance().fluidTankComponentType());
            return;
        }
        stack.set(PlatformItemAccess.getInstance().fluidTankComponentType(), tank);
    }

    private InteractionResult fillOrDrainFluidInLevel(BlockHitResult hitResult, ItemStack stack, Level level, Player player, GenericAmount<FluidLike> content, InteractionHand hand) {
        BlockPos hitPos = hitResult.getBlockPos();
        Direction hitFace = hitResult.getDirection();
        if (level.mayInteract((Entity)player, hitPos) && player.mayUseItemAt(hitPos.relative(hitFace), hitFace, stack)) {
            BlockState blockState = level.getBlockState(hitPos);
            GenericAmount<FluidLike> simulateFluid = FluidAmountUtil$.MODULE$.from(level.getFluidState(hitPos).getType(), GenericUnit$.MODULE$.ONE_BUCKET());
            Block block = blockState.getBlock();
            if (block instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block;
                Block pickUp = (Block)bucketPickup;
                if (content.isEmpty() || content.contentEqual(simulateFluid)) {
                    PlatformFluidAccess.TransferStack simulation = PlatformFluidAccess.getInstance().fillItem(simulateFluid, stack, player, hand, false);
                    if (simulation.moved().nonEmpty()) {
                        ItemStack picked = ((BucketPickup)pickUp).pickupBlock(null, (LevelAccessor)level, hitPos, blockState);
                        GenericAmount<FluidLike> actualFluid = PlatformFluidAccess.getInstance().getFluidContained(picked);
                        PlatformFluidAccess.TransferStack result = PlatformFluidAccess.getInstance().fillItem(actualFluid, stack, player, hand, true);
                        return InteractionResult.SUCCESS_SERVER.heldItemTransformedTo(result.toReplace());
                    }
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }
}

